//                              API LIBRARY
//                              ===========

// This file contains the library of functions for a pleasing
// "Applications Program Interface".

// You can modify it to suit your particular needs.  If you
// do then it would be a good idea to lable all your changes with a unique
// string in a comment so that if you get an upgrade you can remake those
// changes.

// Output from this API library cannot be redirected

// Output using this API is a lot faster than normal DOS calls
// because it accesses screen memory directly.

#define API   // Make some modifications to MAINLIB.APP

// These are the colors available
// To use a background color greater than 7 make sure that you first
// call TextBlinkOff()

#define BLACK      0
#define BLUE       1
#define GREEN      2
#define CYAN       3
#define RED        4
#define MAGENTA    5
#define BROWN      6
#define WHITE      7
#define GREY       8
#define LIGHTBLUE  9
#define LIGHTGREEN 10
#define LIGHTCYAN  11
#define LIGHTRED       12
#define LIGHTMAGENTA   13
#define YELLOW         14
#define BRILLIANTWHITE 15

void Vdu()
{
 // This function is to group data together like a "struct" command but faster
 byte Page;
 byte BackgroundColor;
 byte ForegroundColor;
 byte Blink;
 byte Attribute;
 byte CursorOn;
 int  OldCursorShape;
 byte Row;
 byte Column;

 // Screen border
 byte MinCol;
 byte MinRow;
 byte MaxCol;
 byte MaxRow;
}


void SetVideoMode(AL_VideoMode)
{
 // Sets the Video Mode for the screen.

 // 0 = 40 * 25    2  Color, CGA,EGA,MCGA,VGA
 // 1 = 40 * 25    16 Color, CGA,EGA,MCGA,VGA
 // 2 = 80 * 40    2  Color, CGA,EGA,MCGA,VGA
 // 3 = 80 * 40    16 Color, CGA,EGA,MCGA,VGA
 // 4 = 320 * 200  4 Color Graphics
 // 5 = 320 * 200  4 Color Graphics, Color Burst Disabled
 // 6 = 640 * 200  2 Color Graphics
 // 7 = 80 * 25    Mono, MDA,EGA,VGA
 // 8,9,10         PCjr only
 // 11,12          Used internally by EGA BIOS - Do not use ***
 // 13 = 320 * 200 16 Color, EGA,VGA
 // 14 = 640 * 200 16 Color, EGA,VGA
 // 15 = 640 * 350 Mono, EGA,VGA
 // 16 = 640 * 350 16 Color, EGA,VGA
 // 17 = 640 * 480 2 Color, MCGA,VGA
 // 18 = 640 * 480 16 Color, VGA
 // 19 = 320 * 200 256 Color, MCGA,VGA

 if(AL_VideoMode > 7 && AL_VideoMode < 13) End(31); // Prevent Modes 8 - 12 from being used.
 AH=00h; INT 10h;
}


byte GetVideoMode()
{
 // Returns a byte containing the Current Video Mode

 AH = 0Fh; INT 10h;
 return AL;   // Returns the video mode to the calling function.
}


void ClearScreen()
{
 // Clears the current video screen to be blank.
 byte MouseWasVisible;
 preserve DI, DX, ES;

 Vdu.Attribute = ( Vdu.ForegroundColor + Vdu.BackgroundColor << 4 ) | Vdu.Blink;
 CL = Vdu.MinCol;
 CH = Vdu.MinRow;
 DL = Vdu.MaxCol;
 DH = Vdu.MaxRow;
 BH = Vdu.Attribute;
 if(Mouse.Visible)
 {
  HideMouse();
  AX = 0600h; INT 10h; // BIOS scroll up by 0 (Clear screen)
  ShowMouse();
 }
 else { AX = 0600h; INT 10h; } // BIOS scroll up by 0 (Clear Screen)

 Vdu.Column = Vdu.MinCol;
 Vdu.Row    = Vdu.MinRow;
 Stream.ColumnNumber[cout] = 0;
 Stream.ColumnNumber[cerr] = 0;

 /*
 if(Mouse.Visible) { MouseWasVisible = Mouse.Visible; HideMouse(); }
 AL = Vdu.Page; AH = 0; AX = AX * 100h + B800h; ES = AX; // Page address
 Vdu.Attribute = ( Vdu.ForegroundColor + Vdu.BackgroundColor << 4 ) | Vdu.Blink;
 for(DI=0; DI<4000; DI=DI+2) { E1[DI] = ' '; E1[DI+1] = Vdu.Attribute; }
 Vdu.Column = 0;
 Vdu.Row = 0;
 Stream.ColumnNumber[cout] = 0;
 Stream.ColumnNumber[cerr] = 0;
 if(MouseWasVisible) ShowMouse();
 */
}


void ClearLine()
{
 preserve DI, SI, ES;

 Vdu.Attribute = ( Vdu.ForegroundColor + Vdu.BackgroundColor << 4 ) | Vdu.Blink;
 AL = Vdu.Page; AH = 0; AX = AX * 100h + B800h; ES = AX; // Page address

 // Calculate the character position on the screen
 AL = Vdu.Column; AH = 0;
 DI = AX;
 AL = Vdu.Row;
 DI = (DI + AX * 80) * 2;

 // Write the blank characters
 AL = Vdu.Column; AH = 0; SI_Column = AX;
 while(SI_Column < 80) { E1[DI++] = ' '; E1[DI++] = Vdu.Attribute; SI++; }
}



void CursorOff()
{
 DX = FFFFh; BH = Vdu.Page; AH = 02h; INT 10h; // Place BIOS cursor off page
 Vdu.CursorOn = 0; 
}


void CursorOn()
{
 DH = Vdu.Row; DL = Vdu.Column; BH = Vdu.Page; AH = 02h; INT 10h; // Place BIOS cursor off page
 Vdu.CursorOn = 1; 
}


void SetBorderColor(BH_Color)
{ 
 // This function sets the screen border color.
 
 AL=01h; AH=10h; INT 10h;
}


byte GetPaletteColor(BL_PaletteRegister)
{ 
 // This function returns the number of the color loaded into the specified
 // palette register. Set the Palette function to load a new color into
 // the color register.
 int ColorOut;

 AL=07h; AH=10h; INT 10h;
 return BH_PaletteColor;
}


void GetCursorPosition()
{
 // This function returns the current cursor postion.
 byte Row;
 byte Column;
 byte VideoPage;
 preserve DX;
 
 AH=03h; INT 10h;
 VideoPage = BH;
 Row = DH;
 Column = DL;
}


void SetCursorPosition(AL_Column,AH_Row,BH_VideoPage)
{
 // This function sets the cursor postion on the computers screen.
 byte Row;
 byte Column;
 preserve DX;
 
 DX=AX;             // Copy AL and AH to DL and DH
 AH=02h; INT 10h;   // Call Interrupt 10 Hex
}


void Palette(BL_PaletteRegister,BH_PaletteColor)
{
 preserve ALL;
 AL=00h; AH=10h; INT 10h;
}


void SetDisplayPage(AL_PageNumber)
{
 // This function sets the active video display page for the text and 
 // graphics screens. NOTE if you you this function on a CGA screen pages
 // 4-7 overlap pages 0-3 as CGA can only display 4 pages of text.
 // In all modes page 0 is the default page.

 AH=05h; INT 10h;
}


void TextBlinkOff()
{
 // This function turns off the effect of blinking or flashing text on
 // your screen or monitor. The advantage of doing this is with the 
 // text blink turned off you have access to 16 background colors instead
 // of 8 backgroud colors. See function TextBlinkOn to reverse this effect.
 // NOTE text blink is turned on by default.

 BL=00h; AL=03h; AH=10h; INT 10h;
}


void TextBlinkOn()
{
 // This function turns on the effect of blinking or flashing text on
 // your screen or monitor. The disadvantage of doing this is with the 
 // text blink turned on is that you have access to 8 background colors 
 // instead of 16 backgroud colors. See function TextBlinkOff to reverse 
 // this effect.
 // NOTE text blink is turned on by default.

 BL=01h; AL=03h; AH=10h; INT 10h;
}


void ScrollWindowUp(CL_TopLeftColumn, CH_TopLeftRow, AL_BottomRightColumn, AH_BottomRightRow)
{
 preserve DX;
 
 DX = AX;
 Vdu.Attribute = ( Vdu.ForegroundColor + Vdu.BackgroundColor << 4 ) | Vdu.Blink;
 BH = Vdu.Attribute.
 AX = 0601h; 
 if(Mouse.Visible)
 {
  HideMouse();
  INT 10h;
  ShowMouse();
 }
 else INT 10h;
}


void DrawBox(byte TopLeftColumn, byte TopLeftRow, byte BottomRightColumn, byte BottomRightRow)
{
 byte MouseWasVisible;
 preserve DX, SI, DI;

 if(Mouse.Visible) { MouseWasVisible = Mouse.Visible; HideMouse(); }
 Vdu.Column = TopLeftColumn;
 Vdu.Row = TopLeftRow;
 cout << "";
 for(DL=TopLeftColumn+1; DL<BottomRightColumn; DL++) cout << "";
 cout << "";
 for(DL=TopLeftRow+1; DL<BottomRightRow; DL++)
 {
  Vdu.Row    = DL;
  Vdu.Column = TopLeftColumn;      cout << "";
  AL_Count = BottomRightColumn - TopLeftColumn - 1; AH = 0; SI_Count = AX;
  for(DI=0; DI<SI_Count; DI++) cout << " ";
  Vdu.Column = BottomRightColumn;  cout << "";
 }
 Vdu.Column = TopLeftColumn;
 Vdu.Row = BottomRightRow;
 cout << "";
 for(DL=TopLeftColumn+1; DL<BottomRightColumn; DL++) cout << "";
 cout << "";
 Vdu.Column = TopLeftColumn + 1;
 Vdu.Row = TopLeftRow + 1;
 if(MouseWasVisible) ShowMouse();
}


// MOUSE FUNCTIONS
// ===============

void Mouse()
{
 // This function is to group data together like a "struct" command but faster
 byte Active;
 byte Visible;
 byte Row;
 byte Col;
 byte LeftButtonDown;
 byte RightButtonDown;
 byte CentreButtonDown;
}


byte InitialiseMouse()
{
 // This must be called before using the mouse
 // It resets the Hardware and Software.  It can take a while to reset
 // the mouse, so you may wish to display "Initialising Mouse" while
 // it is doing so.

 AX = 0000h; INT 33h;      // Initialise Mouse
 Mouse.Active = AH & 1;    // Only look at first bit
 if(Mouse.Active)
 {
  ShowMouse();             // Show Mouse
  UpdateMouseVariables();  // Initialise Mouse Variables
 }
 return Mouse.Active;      // Returns TRUE if mouse is installed else FALSE
}


void HideMouse()
{
 // Note that the library functions call HideMouse() before writing to the 
 // screen and then call ShowMouse() again.
 // This is to prevent "Mouse Droppings"
 preserve AX;

 AX = 0002h; INT 33h; // Hide Mouse Cursor
 Mouse.Visible = FALSE;
}


void ShowMouse()
{
 preserve AX;

 //if(Mouse.Active)
 //{
  AX = 0001h; INT 33h;  // Show Mouse Cursor
 //}
 Mouse.Visible = TRUE;
}


void UpdateMouseVariables()   
{
 // Update the Mouse variables
 preserve DX;

 //if(Mouse.Active)
 //{
  AX = 0003h; INT 33h; // Get Mouse Position
  CX = CX >> 3; Mouse.Col = CL;
  DX = DX >> 3; Mouse.Row = DL;
  Mouse.LeftButtonDown   = BL & 1;  BL = BL >> 1;
  Mouse.RightButtonDown  = BL & 1;  BL = BL >> 1;
  Mouse.CentreButtonDown = BL & 1;
 //}
}

