/***********   This program displays the DEMOVIEW.TXT file   *********/

#include "FILEIO.APP"  // Include File I/O library functions
#include "API.APP"     // Include functions for Application Programming Interface
#include "STRING.APP"  // Include String function library
#include "MAINLIB.APP" // MAINLIB.APP must always be the last #include

.STACKSIZE 2000
.STRINGHEAPSIZE 5000

// Declare Global variables
int  DemoViewFile;         // File Handle for DEMOVIEW.TXT
int  Page;                 // Current Page number
long PageAddress[100];     // Address of where page starts
int  NumberOfPages;        // Total number of pages


int Main()
{
 string Time;
 string PreviousTime;
 string FilePathAndName;
 string Line;

 // Open the file to view
 DemoViewFile = Open("DEMOVIEW.TXT", READ);
 if(!DemoViewFile) { cout << "Could not open DEMOVIEW.TXT\n"; return 0; }

 // Find all the page positions
 NumberOfPages = 0;
 // With A++ Underscores are used to give a register a name as shown below
 EDX_FilePosition = 0;
 while(!EOF(DemoViewFile))
 {
  EDX_FilePosition++;
  AL = GetByte(DemoViewFile);
  if(AL == 12)
  {
   if(NumberOfPages >= 100) { cout << "Too many pages\n"; return 0; }
   PageAddress[NumberOfPages] = EDX_FilePosition;
   NumberOfPages++;
  }
 }
 Stream.Err[DemoViewFile] = 0;     // Reset the Error (EOF) flag
 SetFilePosition(DemoViewFile, 0); // Move file pointer back to the start
 NumberOfPages--;                  // Last page is blank

 // Initialise the screen
 Vdu.BackgroundColor = BLUE;
 Vdu.ForegroundColor = WHITE;
 ClearScreen();
 CursorOff();

 // Draw the Box
 DrawBox(0,1,79,23);

 // Display the top Line
 Vdu.BackgroundColor = WHITE;
 Vdu.Row = 0; Vdu.Column = 0; ClearLine();
 Vdu.ForegroundColor = RED; Vdu.Column = 2;  cout << "Q"; Vdu.ForegroundColor = BLACK; cout << "uit";
 Vdu.ForegroundColor = RED; Vdu.Column = 9;  cout << "N"; Vdu.ForegroundColor = BLACK; cout << "extPage"; 
 Vdu.ForegroundColor = RED; Vdu.Column = 20; cout << "P"; Vdu.ForegroundColor = BLACK; cout << "reviousPage";
 Vdu.Column = 59; cout << GetDate() << "   " << GetTime() << "  ";

 // Display the Program Name
 Vdu.BackgroundColor = WHITE;
 Vdu.ForegroundColor = BLUE;
 FilePathAndName = " " + GetCurrentDrive() + GetCurrentDirectory();
 SI_Len = StringLength(FilePathAndName);
 if(FilePathAndName[SI_Len-1] != '\') FilePathAndName = FilePathAndName + "\\";  // "\"
 FilePathAndName = FilePathAndName + "DEMOVIEW.TXT" + " ";
 DX = 40 - StringLength(FilePathAndName) / 2; // Number of spaces to centre text
 Vdu.Row = 1; Vdu.Column = DL; cout << FilePathAndName;

 // Display the bottom Line
 Vdu.BackgroundColor = CYAN;
 Vdu.ForegroundColor = BRILLIANTWHITE;
 Vdu.Column = 0; Vdu.Row = 24;
 ClearLine();

 // Initialise the mouse
 Vdu.Column = 0; Vdu.Row = 24;
 cout << "Initialising the mouse";
 InitialiseMouse();
 Vdu.Column = 0;
 cout << "Please select a Red Key from the Menu, or PgDn, PgUp or ESC";

 // Set up the View Port
 Vdu.MinRow = 2;
 Vdu.MinCol = 1;
 Vdu.MaxRow = 22;
 Vdu.MaxCol = 78;

 // Display the first page
 Page = 0;
 DisplayPage(); 

 while(AX == AX)
 {
  while(!AKeyIsWaiting())
  { 
   // Only display the time when it changes
   Time = GetTime();
   if(Time != PreviousTime)
   {
    Vdu.ForegroundColor = BLACK;
    Vdu.BackgroundColor = WHITE;
    Vdu.Column = 59; Vdu.Row = 0;
    Vdu.MinRow = 0; // Temporarily let cout work outside its view port
    cout << GetDate() << "   " << Time << "  ";
    PreviousTime = Time;
    Vdu.MinRow = 2;
   }
   if(Mouse.Active)
   {
    UpdateMouseVariables();
    if(Mouse.LeftButtonDown)
    {
     if(Mouse.Row == 0) 
     {
      // On the top Line
      CL = Mouse.Col;
      if     (CL >= 2  && CL <= 5)   EndProgram();
      else if(CL >= 9  && CL <= 16)  { Page++; DisplayPage(); }
      else if(CL >= 20 && CL <= 31)  { Page--; DisplayPage(); }
     }    
    }
    while(Mouse.LeftButtonDown) UpdateMouseVariables();
   }
  }
  
  // Read the extended character
  AH = 0; INT 16h;  // Example of using Assembler to Call BIOS
                    // Returns ASCII character in AL and Scan Code in AH
  if     (AL == 0 && AH == 51h)   { Page++; DisplayPage(); }  // If a Scan Code == 51h
  else if(AL == 0 && AH == 49h)   { Page--; DisplayPage(); }  // If a Scan Code == 49h
  else if(AL == 'N' || AL == 'n') { Page++; DisplayPage(); } 
  else if(AL == 'P' || AL == 'p') { Page--; DisplayPage(); }  
  else if(AL == 27 || AL == 'Q' || AL == 'q') EndProgram();
 }
 return 0;
}


void EndProgram()
{
 Close(DemoViewFile);
 End(0);
}


void DisplayPage()
{
 string Line;

 if(Page < 0) { Page = 0; return; }
 if(Page >= NumberOfPages) { Page = NumberOfPages - 1; return; }
 SetFilePosition(DemoViewFile, PageAddress[Page]);
 Vdu.Row = 2; Vdu.Column = 1;
 Vdu.BackgroundColor = BLUE;
 Vdu.ForegroundColor = YELLOW;
 ClearScreen();
 DemoViewFile >> Line;   // Read the first line
 while(Line[0] != 12 && !EOF(DemoViewFile)) // while not FF (FormFeed) and not at end of file
 {
  cout << "\n" << Line;  // Put CR at start so that can scroll to bottom line
  DemoViewFile >> Line;  // Read the next line
 }
}


