//                             FILEIO LIBRARY
//                             ==============

// This file contains the library functions to Read or Write to files.

// You can modify it to suit your particular needs.  If you
// do then it would be a good idea to lable all your changes with a unique
// string in a comment so that if you get an upgrade you can remake those
// changes.

// Using buffers significantly increases the speed of File I/O even if you
// have a Cache program like SMARTDRV installed.  You can choose a value
// for FILEBUFFERSIZE to suit your particular speed/memory needs.

#define FILEIO                // Makes some modifications to MAINLIB.APP file

#define FILEBUFFERSIZE  10000 // Number of bytes in the file buffer
#define MAXHANDLES      20    // Maximum number of Open Files

int Open(AX_Name, byte ReadWriteType)
{
 // Opens a file for READ or WRITE
 // Returns the file Handle or 0 if could not open file
 int  Handle;
 preserve DX;

 DX = AX_Name;
 AX = 3D00h;               // DOS call to Open File to Read
 if(ReadWriteType == WRITE) { AH = 3Ch; CX = 0; } // DOS Call To Open create file
 PUSH DS; PUSH SS; POP DS; // Set up DS for DOS
 INT 21h;                  // Attempt to open the File
 POP DS;                   // Restore DS
 if(CARRYFLAG) return 0;   // Could not open file
 if(AX >= MAXHANDLES) End(4); // Too many open files so Terminate the Program
 Handle = AX ;             // Keep the Handle for later

 AX = AllocateMemoryBlock(FILEBUFFERSIZE); // Ask for a block of memory
 BX_Handle = Handle;
 if(AX == 0)
 {
  // Allocation failed so Terminate program
  AH = 3Eh; INT 21h;       // Call DOS to close file
  End(Error);
 }
 Stream.BufferSegment[BX_Handle] = AX; // Segment address of File Buffer
 Stream.BufferLength[BX_Handle] = 0;   // Position of last byte available to be read (ie. none)
 Stream.BufferPosition[BX_Handle] = 0; // Position of next byte available
 Stream.DOSPosition[BX_Handle] = 0;    // Position of DOS Pointer
 Stream.Err[BX_Handle] = 0;            // No Error
 Stream.ReadWriteType[BX_Handle] = ReadWriteType;
 Stream.ColumnNumber[BX_Handle] = 0;
 return BX_Handle;
}


void Close(BX_Handle)
{
 // Closes a file previously opened by Open()

 if(Stream.ReadWriteType[BX_Handle] == WRITE) Flush(BX_Handle);
 AH = 3Eh; INT 21h;       // Call DOS to close file
 if(CARRYFLAG) End(AX);   // Close failed so Terminate program
 Stream.Err[BX_Handle] = 6; // Error for invalid handle
 ReleaseMemoryBlock(Stream.BufferSegment[BX_Handle]);
}


int EOF(BX_Handle)
{
 // Checks if at the end of a file
 // Returns 1 if at end of file or 0 if not at end of file
 if(BX_Handle >= MAXHANDLES || Stream.Err[BX] == 6) End(4); // If invalid Handle then terminate program
 AL = Stream.Err[BX_Handle]; AH = 0;
 return AX;
}


long GetFilePosition(BX_Handle)
{
 // Get the Position of the next byte to be read for a File
 // Note that the first byte is at position Zero.

 ECX = 0;
 CX_BytesLeftInBuffer = Stream.BufferLength[BX_Handle] - Stream.BufferPosition[BX_Handle]; 
 if(CX_BytesLeftInBuffer < 0) CX_BytesLeftInBuffer = 0; // Make sure that bytes left is positive
 EAX = Stream.DOSPosition[BX] - ECX;
 return EAX;
}


void SetFilePosition(BX_Handle, long Position)
{
 // Set the position from which to start reading or writing to next
 preserve BX, EDX;

 // Note that the first byte is at position Zero.

 if(Stream.ReadWriteType[BX_Handle] == WRITE)
 {
  Flush(BX_Handle);
  ECX = Position;  DX = CX;  // Least significant part
  ECX = ECX >> 16;           // Most Significant part
  //Dot();
  AX = 0x4200; INT 21h;  // Move File Pointer  
  if(CARRYFLAG) End(AX); // If Error Terminate Program
 }
 else
 {
  EDX = 0;
  DX = Stream.BufferLength[BX_Handle]; 
  EDX = Stream.DOSPosition[BX_Handle] - EDX;
  if(Position < Stream.DOSPosition[BX_Handle] && Position >= EDX)
  {
   // Is within current Buffer
   ECX = Position - EDX;
   Stream.BufferPosition[BX_Handle] = CX;
  }      
  else
  {
   //PUSH BX; LogFile << "Outside Buffer\n"; POP BX;
   Stream.BufferLength[BX_Handle] = 0;
   Stream.BufferPosition[BX_Handle] = 0;
   Stream.DOSPosition[BX_Handle] = Position;
   ECX = Position;  DX = CX;  // Least significant part
   ECX = ECX >> 16;           // Most Significant part
   //Dot();
   AX = 0x4200; INT 21h;  // Move File Pointer  
   if(CARRYFLAG) End(AX); // If Error Terminate Program
  }
 }
}


void Flush(BX_Handle)
{
 // If there is stuff left in a stream buffer, then flush it out
 preserve DX;

 if(BX < 5) return; // Devices below 5 are hardware devices
 if(Stream.ReadWriteType[BX_Handle] != WRITE) End(5);
 ECX = 0; CX = Stream.BufferPosition[BX_Handle];
 Stream.BufferPosition[BX_Handle] = 0;
 Stream.DOSPosition[BX_Handle] = Stream.DOSPosition[BX_Handle] + ECX;
 Stream.BufferLength[BX_Handle] = 0;
 DX = 0;
 PUSH DS;
 DS = Stream.BufferSegment[BX_Handle];
 AH = 40h;
 INT 21h;
 POP DS;
 if(CARRYFLAG) End(AX);
}
 

