//                             A++ TSR LIBRARY
//                             ===============

// This file contains the library of functions with which you can build
// your own TSR's program.  You can modify it to suit your particular needs.
// If you do then it would be a good idea to lable all your changes with a
// unique string in a comment so that if you get an upgrade you can remake
// those changes.

// Note that DOS INT 21h functions below 0Dh do not work with TSR's

// TSR's use techniques which the DOS and Application writers did not count
// on, so they don't work with all programs.  If you see a way of making
// this TSR library work better, please contact Eric Schwerzel from
// Acclaim Software Ltd

#define TSR   // This makes some differences to Library Functions

// Simulate variables in the Start of the Code Segment.  These variables are 
// used by Interrupts which have been intercepted, and the only segment which is
// valid is the Code Segment, so rather than set up the Data Segment and Stack
// Segment each time an Interrupt is excecuted, some Data is placed in 
// the Code Segment.

// These variables overlap with the Start() function which is always
// at the start of the .EXE file.  If you need to edit the Start() function
// then do a FULL RECOMPILE !!!.  This is because the Start() function is then
// moved to the end and another function will be overwritten by these variables.
#define InROMBIOSPrintScreenInterrupt C1[40h]
#define HotKeyPressed                 C1[41h]
#define InDOSAddress                  C2[42h]
#define InDOSSegment                  C2[44h]
#define InKeyboardInterrupt1          C1[46h]
#define InVideoInterrupt              C1[47h]
#define InDiskIOInterrupt             C1[48h]
#define InDOSIdleInterrupt            C1[49h]
#define TSRActive                     C1[4Ah] // Note Start() must be past address 004Ah before this is initialised
#define InTimerTickInterrupt          C1[4Bh]
#define ControlBreakPressed           C1[4Ch]
#define DOSCriticalError              C1[4Dh]
#define DOSControlCPressed            C1[4Eh]
#define HotKey                        C1[50h]
#define CheckSHIFTKey                 C1[51h]
#define CheckCTRLKey                  C1[52h]
#define CheckALTKey                   C1[53h]
#define TSRDS                         C2[54h]
#define TSRSS                         C2[56h]
#define TSRSP                         C2[58h]
#define PreviousSS                    C2[5Ah]
#define PreviousSP                    C2[5Ch]
#define PreviousBreak                 C1[5Eh]
#define PreviousPSP                   C2[60h]
#define TSRPSP                        C2[62h]
#define PreviousDTAAddress            C2[64h]
#define PreviousDTASegment            C2[66h]
#define PreviousScreenNumber          C1[68h]
#define PreviousScreenDataHandle      C2[70h]
#define PreviousCursorPosition        C2[72h]
#define PreviousCursorShape           C2[74h]
//#define MouseWasInstalled             C1[76h]
#define InKeyboardInterrupt2          C1[77h]
//#define DelayTicks                    C1[78h]
#define InDOSInterrupt                C1[79h]
//#define FunctionNumber                C1[7Ah]
#define FromSegment                   C2[7Ch]
#define MainSP                        C2[7Eh]
#define AmountOfMemoryReserved        C2[80h]
#define SegmentOfMemoryReserved       C2[82h]
#define OldAH                         C1[84h]
#define OldFLAGS                      C1[86h]
#define TSRCursorShape                C2[88h]
#define SaveMouseStateSegment         C2[8Ah]
#define ThisInterrupt9AddressLow      C2[8Ch]
#define ThisInterrupt9AddressHigh     C2[8Eh]
#define ThisInterrupt9Address         C4[8Ch]
#define ApplicationInterrupt9Address  C4[90h]
#define ThisInterrupt16AddressLow     C2[94h]
#define ThisInterrupt16AddressHigh    C2[96h]
#define ThisInterrupt16Address        C4[94h]
#define ApplicationInterrupt16Address C4[98h]

// Use one of the following for your Hot Key when you call TSRWithHotKey()
// These are the Keyboard Scan Codes for some keys
//  A          0x1E
//  B          0x30
//  C          0x2E
//  D          0x20
//  E          0x12
//  F          0x21
//  G          0x22
//  H          0x23
//  I          0x17
//  J          0x24
//  K          0x25
//  L          0x26
//  M          0x32
//  N          0x31
//  O          0x18
//  P          0x19
//  Q          0x10
//  R          0x13
//  S          0x1F
//  T          0x14
//  U          0x16
//  V          0x2F
//  W          0x11
//  X          0x2D
//  Y          0x15
//  Z          0x2C
//  F1         0x3B
//  F2         0x3C
//  F3         0x3D
//  F4         0x3E
//  F5         0x3F
//  F6         0x40
//  F7         0x41
//  F8         0x42
//  F9         0x43
//  F10        0x44
//  F11        0x85
//  F12        0x86
//  Esc        0x01
//  Home       0x47
//  Up         0x48
//  PgUp       0x49
//  Left       0x4B
//  Centre     0x4C
//  Right      0x4D
//  End        0x4F
//  Down       0x50
//  PgDn       0x51
//  Ins        0x52
//  Del        0x53
//  BackSpace  0x0E
//  Tab        0x0F
//  Enter      0x1C


void TSRWithHotKey(AL_HotKey, AH_CheckSHIFTKey, BL_CheckCTRLKey, BH_CheckALTKey, CX_MemoryToReserve)
{
 // Call this routine with the Hot Key (0 = No Hot key, only use CTRL, 
 // ALT, SHIFT combination) you want together with which Control
 // Keys you want pressed together with the Hot Key.

 // Specify the Dynamic memory required in paragraghs (16 bytes in a paragraph)
 
 // This routine checks that the TSR is not already installed, and 
 // then sets up the TSR, and exits
 
 byte InterruptNumber[10];
 int  InterruptAddress[10];
 string EXEFileName;
 byte Match;

 HotKey        = AL;
 CheckSHIFTKey = AH;
 CheckCTRLKey  = BL;
 CheckALTKey   = BH;
 AmountOfMemoryReserved = (CX << 6) + 16;  // Convert to paragraphs and allow 16 paragraghs for mouse
 
 AX = 3000h; INT 21h; // Get DOS version
 XCHG AH,AL;          // Exchange AH and AL 
 // The following line tests that DOS version 3.1 (030Ah) or higher
 // and not OS2 (0A00h)
 if(AX <= 030Ah || AX >= 0A00h) { cout << "Requires DOS 3.1 or higher\n"; End(31); }

 // See if the program is already installed
 // This is done by searching through the PSP's of each program before this one
 // and then seeing if the Name matches this one
 for(SI=60; SI.<.Start.PSPAddress; SI++) // unsigned comparison
 {
  ES = SI;
  if(E2[0] == 20CDh)  // "PSP signature"
  {
   // Looks like a PSP
   DI = E2[2Ch]; // Get the environment segment address from the PSP
   ES = Start.PSPAddress;
   if(DI != E2[2Ch])  // if environment segments are different
   {
    ES = DI;
    for(DI=0; DI < 1000; DI++)
    {
     if((E1[DI] < ' ' || E1[DI] > 127) && E1[DI] != 0) break; // If invalid char then ignore
     if(E1[DI] == 0 && E1[DI+1] == 0)  // Search for double NULL
     {
      DI = DI + 4;  // move past double NULL and length byte
      if(E1[DI+1] == ':' && E1[DI+2] == '\')  // Looks like ?:\  ie. A Path
      {
       // Debug code. Print the Program Name found
       //PUSH DI; 
       //while(E1[DI] > 32 && E1[DI] < 127) { PrintChar(1,E1[DI]); DI++; }
       //POP DI;
       //PrintChar(1,13); PrintChar(1,10); 
       //cout << SI << "\n";
       //GetChar(0);
    
       // See if the .EXE file name is the same as this one
       PUSH SI;
       Match = TRUE;
       SI = 0;
       while(argv[0][SI] != 0) 
       {
        if(argv[0][SI] != E1[DI]) Match = FALSE;
        SI++; DI++; 
       }
       if(E1[DI] != 0) Match = FALSE;
       POP SI;
       if(Match)      
       {
        // Path and Name of this program match that of other program
        cout << "Already installed\n";
        End(0);
       }
      }
     }
    }
   }
  }
 }

 // Get the Full Address of the InDOS flag and ErrorMode (Byte before InDOS flag)
 AH = 34h; INT 21h;
 InDOSAddress = BX;
 InDOSSegment = ES;

 // List interrupts to redirect
 InterruptNumber[0] = 05h; // ROM BIOS PrintScreen Interrupt
 InterruptNumber[1] = 08h; // TimerTick Interrupt
 InterruptNumber[2] = 09h; // Keyboard Interrupt 1
 InterruptNumber[3] = 10h; // ROM BIOS Video Service Interrupt
 InterruptNumber[4] = 13h; // ROM BIOS Disk IO Interrupt
 InterruptNumber[5] = 28h; // DOS Idle Interrupt
 InterruptNumber[6] = 16h; // Keyboard Interrupt 2
 InterruptNumber[7] = 21h; // DOS Interrupt
 
 // Get New Addresses of Interrupts
 AX = ADDRESSOF(PrintScreenInterrupt);  InterruptAddress[0] = AX;
 AX = ADDRESSOF(TimerTickInterrupt);    InterruptAddress[1] = AX;
 AX = ADDRESSOF(KeyboardInterrupt1);    InterruptAddress[2] = AX;
 AX = ADDRESSOF(VideoServiceInterrupt); InterruptAddress[3] = AX;
 AX = ADDRESSOF(DiskIOInterrupt);       InterruptAddress[4] = AX;
 AX = ADDRESSOF(DOSIdleInterrupt);      InterruptAddress[5] = AX;
 AX = ADDRESSOF(KeyboardInterrupt2);    InterruptAddress[6] = AX;
 AX = ADDRESSOF(DOSInterrupt);          InterruptAddress[7] = AX;
 
 ThisInterrupt9AddressLow  = InterruptAddress[2];
 ThisInterrupt9AddressHigh = CS;

 ThisInterrupt16AddressLow  = InterruptAddress[6];
 ThisInterrupt16AddressHigh = CS;

 // Save and redirect interrupts (DOS method)
 for(SI=0; SI<8; SI++)
 {
  // Save old interrupt
  AL = InterruptNumber[SI];
  AH = 35h; INT 21h;
  C2[SI*4]   = BX;
  C2[SI*4+2] = ES;

  // Redirect Interrupts
  DX = InterruptAddress[SI];
  AL = InterruptNumber[SI];
  PUSH DS; PUSH CS; POP DS; // Get Address of new Interrupt
  AH = 25h; INT 21h;        // Set Interrupt vector
  POP DS;
 }
 
 /*
 // Save and redirect interrupts (Direct Method)
 for(SI=0; SI<8; SI++)
 {
  // Save old interrupt
  AX = 0; ES = AX;
  BL = InterruptNumber[SI]; BH = 0;
  C4[SI*4] = E4[BX*4]; // Save old Address
 
  // Redirect Interrupts
  E2[BX*4]   = InterruptAddress[SI]; // Get Address of new Interrupt
  E2[BX*4+2] = CS;                   // Get Segment of new Interrupt
 }
 */
  
 C1[28h] = ':';
 InROMBIOSPrintScreenInterrupt = 0;
 InKeyboardInterrupt1          = 0;
 InKeyboardInterrupt2          = 0;
 InVideoInterrupt              = 0;
 InDiskIOInterrupt             = 0;
 InTimerTickInterrupt          = 0;
 InDOSIdleInterrupt            = 0;
 TSRActive                     = 0;
 HotKeyPressed                 = 0;
 ControlBreakPressed           = 0;
 //DelayTicks                    = 0;
 InDOSInterrupt                = 0;

 // Save the Stack and Data Segment registers etc.
 TSRSS = SS;
 TSRSP = SP;
 TSRDS = DS;
 TSRPSP = Start.PSPAddress;
 
 /*
 cout << "CS  = " << IntegerToHexString(CS)     << "\n";
 cout << "SS  = " << IntegerToHexString(TSRSS)  << "\n";
 cout << "SP  = " << IntegerToHexString(TSRSP)  << "\n";
 cout << "DS  = " << IntegerToHexString(TSRDS)  << "\n";
 cout << "PSP = " << IntegerToHexString(TSRPSP) << "\n";
 AH = 51h; INT 21h; DX = BX; cout << "DOS PSP = " << IntegerToHexString(DX) << "\n";
 */

 // Reserve amount of dynamic memory required
 if(AmountOfMemoryReserved != 0)
 {
  BX = AmountOfMemoryReserved;
  AH = 48h; INT 21h; // Call DOS to Allocate memory Block
  if(CARRYFLAG) End(8); // If Error
  SegmentOfMemoryReserved = AX;
 }

 // Save the cursor attributes
 AH = 03h; INT 10h; 
 TSRCursorShape = CX;

 cout << "Installed " << argv[0] << "\n";

 // Terminate and Stay Resident
 DX = Start.ProgramSize;
 AL = 0; // Return code
 AH = 31h; INT 21h; 
}



interrupt PrintScreenInterrupt()
{
 // Interrupt 5 is redirected to this routine which then calls 
 // the origional Interrupt 5
 // This routine sets a flag to say that the ROM BIOS Print Screen is Active

 InROMBIOSPrintScreenInterrupt = 1;
 // Call origional interrupt
 PUSH FLAGS; // Simulate Call Interrupt with CALL below
 CLI;        // Disable Hardware Interrupts
 CALL FAR C4[0000h];
 InROMBIOSPrintScreenInterrupt = 0;
}


interrupt TimerTickInterrupt()
{
 // Interrupt 8 is redirected to this routine which then calls 
 // the origional Interrupt 8
 //POP FromSegment; PUSH FromSegment;
 preserve ES, AX, BX, CX, DX;
 
 InTimerTickInterrupt++;

 // Call origional interrupt
 PUSH FLAGS; // Simulate Call Interrupt with CALL below
 CLI;        // Disable Hardware Interrupts
 CALL FAR C4[0004h];
 STI;        // Enable Hardware Interrupts
 
 // The following line activates the TSR only if it cannot
 // be activated from the Keyboard Interrupt
 if(ActivateTheTSR() && !InKeyboardInterrupt2) TSRShell();
 
 // Decrement the Timer
 //if(DelayTicks > 0) DelayTicks--;

 #ifdef DEBUG
 // Display InDOS flag
 ES = InDOSSegment;
 BX = InDOSAddress;
 if(E1[BX])   { AX = B800h; ES = AX; E1[158] = 'D'; }
 else         { AX = B800h; ES = AX; E1[158] = ' '; }

 // Display Critical Error Flag
 ES = InDOSSegment;
 BX = InDOSAddress;
 if(E1[BX-1]) { AX = B800h; ES = AX; E1[156] = 'E'; }
 else         { AX = B800h; ES = AX; E1[156] = ' '; }
 E1[120] = ' ';
 
 if(InROMBIOSPrintScreenInterrupt) { AX = B800h; ES = AX; E1[154] = 'P'; }
 else                              { AX = B800h; ES = AX; E1[154] = ' '; }
  
 AL = 0Bh;   // AL = 0CW3 for Intel 8259A (RR = 1, RIS = 1)
 OUT 20h,AL; // Request 8259A's In Service register
 if(AL) {}   // Wait a few cycles
 IN AL,20h;  // Read In Service Register
 if(AL) { AX = B800h; ES = AX; E1[152] = 'H'; }
 else   { AX = B800h; ES = AX; E1[152] = ' '; }
 
 AX = B800h; ES = AX; E1[142] = ' '; // Overwrite DOS Idle Flag
 #endif 
 
 /*
 // Display Hex
 AX = B800h; ES = AX;
 DX_Word = FromSegment;
 BX = 50;
 for(CL=12; CL>=0; CL=CL-4)
 {
  AX = ((DX >> CL) & 0xF) + 48;
  if(AX > 57) AX = AX + 7;
  E1[BX] = AL;
  BX = BX + 2;
 }
 E1[BX] = 'h';
 */

 InTimerTickInterrupt--;
 if(InTimerTickInterrupt < 0) InTimerTickInterrupt = 0;
}



interrupt KeyboardInterrupt1()
{
 // Interrupt 9 is redirected to this routine which then calls 
 // the origional Interrupt 9
 preserve AX;

 InKeyboardInterrupt1++;

 // Read scan code
 IN AL,60h;

 // Call origional interrupt
 PUSH FLAGS; // Simulate Call Interrupt with CALL below
 CLI;        // Disable Hardware Interrupts
 CALL FAR C4[0008h];
 STI;        // Enable Hardware Interrupts

 if(!InKeyboardInterrupt2 && (AL_ScanCode == HotKey || HotKey == 0)) CheckHotKey();

 #ifdef DEBUG
 // Display the Scan Code
 PUSH BX; PUSH CX; PUSH ES;
 BX = B800h; ES = BX; 
 E1[148] = (CL >> 4) + 48; 
 if(E1[148] > 57) E1[148] = E1[148] + 7;
 E1[150] = (CL & 0Fh) + 48;
 if(E1[150] > 57) E1[150] = E1[150] + 7;
 POP ES; POP CX; POP BX;

 if(HotKeyPressed) E1[144] = 'H';
 #endif

 /*
 // Display Hex
 PUSH ALL; PUSH ES;
 AX = B800h; ES = AX;
 DX_Word = FromSegment;
 BX = 50;
 for(CL=12; CL>=0; CL=CL-4)
 {
  AX = ((DX >> CL) & 0xF) + 48;
  if(AX > 57) AX = AX + 7;
  E1[BX] = AL;
  BX = BX + 2;
 }
 E1[BX] = 'h';
 FromSegment++;
 POP ES; POP ALL; 
 */
  
 InKeyboardInterrupt1--;
 if(InKeyboardInterrupt1 < 0) InKeyboardInterrupt1 = 0;
}



interrupt VideoServiceInterrupt()
{
 // Interrupt 10h is redirected to this routine which then calls 
 // the origional Interrupt 10h
 
 InVideoInterrupt++;

 // Call origional interrupt
 PUSH FLAGS; // Simulate Call Interrupt with CALL below
 CLI;        // Disable Hardware Interrupts
 CALL FAR C4[000Ch];
 STI;        // Enable Hardware Interrupts

 InVideoInterrupt--;
 if(InVideoInterrupt < 0) InVideoInterrupt = 0;
}


interrupt DiskIOInterrupt()
{
 // Interrupt 13h is redirected to this routine which then calls 
 // the origional Interrupt 13h
 
 InDiskIOInterrupt = 1;
 // Call origional interrupt
 PUSH FLAGS; // Simulate Call Interrupt with CALL below
 CLI;        // Disable Hardware Interrupts
 CALL FAR C4[0010h];

 InDiskIOInterrupt = 0;

 STI;       // Enable Hardware interrupts  
 RETF 2;    // Simulate IRET without poping flags
}


interrupt ROMBIOSControlBreakInterrupt()
{
 // Interrupt 1Bh is redirected to this routine

 ControlBreakPressed = TRUE;
}


interrupt DOSControlCInterrupt()
{
 // Interrupt 23h is redirected to this routine

 DOSControlCPressed = TRUE;
}


interrupt DOSCriticalErrorInterrupt()
{
 // Interrupt 24h is redirected to this routine

 DOSCriticalError = TRUE;
 AL = 3;
}


interrupt DOSIdleInterrupt()
{
 // Interrupt 28h is redirected to this routine which then calls 
 // the origional Interrupt 28h
 preserve AX, ES;
 
 // Call origional interrupt
 PUSH FLAGS; // Simulate Call Interrupt with CALL below
 CLI;        // Disable Hardware Interrupts
 CALL FAR C4[0014h];

 #ifdef DEBUG
 PUSH ES; PUSH AX;
 AX = B800h; ES = AX; E1[142] = 'I';
 POP AX; POP ES;
 #endif

 // Prevent recursion
 if(InDOSIdleInterrupt) return;
 InDOSIdleInterrupt = TRUE;

 // The following line activates the TSR only if it cannot
 // be activated from the Keyboard Interrupt
 if(ActivateTheTSR() && !InKeyboardInterrupt2) TSRShell();

 InDOSIdleInterrupt = FALSE;
}



interrupt KeyboardInterrupt2()
{
 // Interrupt 16h is redirected to this routine which then calls 
 // the origional Interrupt 16h
 
 // This Interrupt is more difficult to deal with because it can be recursive

 //PUSH ALL; PUSH FLAGS;
 //if(ActivateTheTSR() && !InKeyboardInterrupt2) TSRShell();  // Call the TSR
 //POP FLAGS; POP ALL;

 PUSH FLAGS;
 if(!TSRActive && (AH == 00h || AH == 01h || AH == 10h || AH == 11h))
 {
  InKeyboardInterrupt2++;
  POP FLAGS;
  OldAH = AH;                // Save AH for later
  AH = FLAGS; OldFLAGS = AH; // Save flags for later
  AH = OldAH;

  //PUSH ES; PUSH AX; PUSH BX;
  //BX = B800h; ES = BX; AH = AH + '0'; E1[130] = AH;
  //POP BX; POP AX; POP ES;

  StartAgain:  // Lable

  // Call origional interrupt
  PUSH FLAGS; // Simulate Call Interrupt with CALL below
  CLI;        // Disable Hardware Interrupts
  CALL FAR C4[0018h];

  #ifdef DEBUG
  if(!ZEROFLAG)
  {
   // Display the Scan Code
   PUSH BX; PUSH CX; PUSH ES; PUSH FLAGS;
   BX = B800h; ES = BX; CL = AH;
   E1[148] = (CL >> 4) + 48;  
   if(E1[148] > 57) E1[148] = E1[148] + 7;
   E1[150] = (CL & 0Fh) + 48;
   if(E1[150] > 57) E1[150] = E1[150] + 7;
   POP FLAGS; POP ES; POP CX; POP BX;
  }
  #endif


  PUSH FLAGS; PUSH AX;
  if((!ZEROFLAG || OldAH == 00h || OldAH == 10h) && (AH == HotKey || HotKey == 0)) CheckHotKey();

  if(ActivateTheTSR() && InKeyboardInterrupt2 <= 1)
  {
   POP AX; POP FLAGS;   // Throw away old AX and FLAGS
   TSRShell();  // Call the TSR

   // Call origional interrupt
   AH = OldFLAGS; FLAGS = AH; // Restore FLAGS
   AH = OldAH;                // Restore AH
   goto StartAgain;
  }
  else 
  {
   //if(DelayTicks == 0) DelayTicks = 1;
   POP AX; POP FLAGS;
  }

  PUSH FLAGS;
  InKeyboardInterrupt2--;
  if(InKeyboardInterrupt2 < 0) InKeyboardInterrupt2 = 0;
  //if(!InKeyboardInterrupt2)
  //{
   //PUSH ES; PUSH AX;
   //AX = B800h; ES = AX; E1[130] = ' ';
   //POP AX; POP ES;
  //}
  POP FLAGS;
 }
 else
 {
  //if(DelayTicks == 0) DelayTicks = 1;
  POP FLAGS;

  // Call origional interrupt
  PUSH FLAGS; // Simulate Call Interrupt with CALL below
  CLI;        // Disable Hardware Interrupts
  CALL FAR C4[0018h];
 }

 STI;       // Enable Hardware interrupts  
 RETF 2;    // Simulate IRET without poping flags
}
 


interrupt DOSInterrupt()
{
 // Interrupt 21h is redirected to this routine which then calls 
 // the origional Interrupt 21h
 
 // This Interrupt is more difficult to deal with because it can be recursive

 PUSH FLAGS;
 if( AH >= 0Dh && AH <= 25h 
  || AH >= 27h && AH <= 2Eh
  || AH == 30h
  || AH >= 36h && AH <= 47h
  || AH >= 4Eh && AH <= 4Fh
  || AH == 54h 
  || AH >= 56h && AH <= 57h
  || AH >= 59h && AH <= 5Ch)
 {
  InDOSInterrupt++;
  POP FLAGS;

  //PUSH ES; PUSH AX; PUSH BX;
  //BX = B800h; ES = BX; AH = AH + '0'; E1[126] = AH; E1[120] = 'D';
  //POP BX; POP AX; POP ES;

  // Call origional interrupt
  PUSH FLAGS; // Simulate Call Interrupt with CALL below
  CLI;        // Disable Hardware Interrupts
  CALL FAR C4[001Ch];

  PUSH FLAGS;
  InDOSInterrupt--;
  if(InDOSInterrupt < 0) InDOSInterrupt = 0;
  POP FLAGS;
 }
 else
 {
  POP FLAGS;
  // Call origional interrupt
  PUSH FLAGS; // Simulate Call Interrupt with CALL below
  CLI;        // Disable Hardware Interrupts
  CALL FAR C4[001Ch];
 }

 STI;       // Enable Hardware interrupts  
 RETF 2;    // Simulate IRET without poping flags
}
 


void CheckHotKey()
{
 // When the Hot Key has been pressed then check that the SHIFT, CTRL and ALT
 // keys are also in the required state before turning on the Hot Key flag.
 preserve AX, CX, ES;

 // Check Hot Key not already pressed
 if(HotKeyPressed) return;

 // Get Keyboard Status byte
 AX = 0040h; ES = AX; CH = E1[0017h];

 // Check SHIFT key not required or pressed   
 if(CheckSHIFTKey && (CH & 3) == 0) return;

 // Check CTRL key not required or pressed   
 if(CheckCTRLKey && (CH & 4) == 0) return;

 // Check ALT key not required or pressed   
 if(CheckALTKey && (CH & 8) == 0) return;

 // The Hot key has been pressed
 HotKeyPressed = TRUE;
}



int ActivateTheTSR()
{
 // This checks to see if the TSR needs to be Popped up.
 
 preserve ES, BX, FLAGS;
 
 // Is TSR Hotkey pressed and not already active
 if(HotKeyPressed && !TSRActive)
 {
  // Check that DOS is available
  ES = InDOSSegment;
  BX = InDOSAddress;
  // E1[BX]   = InDOS
  // E1[BX-1] = DOSCriticalError
  if(E1[BX] <= InDOSIdleInterrupt && !E1[BX-1])
  //if(!E1[BX] && !E1[BX-1])
  {
   // Check that Hardware is available
   AL = 0Bh;   // AL = 0CW3 for Intel 8259A (RR = 1, RIS = 1)
   OUT 20h,AL; // Request 8259A's In Service register
   if(AL) {}   // Wait a few cycles
   IN AL,20h;  // Read In Service Register
   if(!AL_HardwareBusy)
   {
    // Check that ROM BIOS is not in use
    if(!InROMBIOSPrintScreenInterrupt
       && !InKeyboardInterrupt1
       //&& !InKeyboardInterrupt2
       && !InVideoInterrupt
       && !InDiskIOInterrupt
       && !InDOSInterrupt)
    {
     // Check that the Video Mode is OK (ie. not in graghics or Mono)
     PUSH ES; AX = 0040h; ES = AX; AL = E1[0049h]; POP ES; // Get video mode in AL
     if(AL == 3) // Only allow 80 X 25 color mode
     {
      return 1;
     }
    }
   }
  }
 }
 return 0;
}



void TSRShell()
{
 // This routine is called when the TSR needs to be popped up.
 // It is a shell around your application. 
 // It preserves and modifies a whole lot of stuff before calling TSRMain()
 byte InterruptNumber[5];
 int  InterruptAddress[5];

 preserve ALL, ES, DS;
 TSRActive = TRUE;
 PreviousSS = SS;
 PreviousSP = SP;
 SS = TSRSS;
 SP = TSRSP;
 DS = TSRDS;
 CLD;

 //AX = B800h; ES = AX; E1[140] = 'T'; 

 // List interrupts to redirect
 InterruptNumber[0] = 1Bh; // ROM BIOS Control Break Interrupt
 InterruptNumber[1] = 23h; // DOS Control C Interrupt
 InterruptNumber[2] = 24h; // DOS Critical Error Interrupt
 
 // Get New Addresses of Interrupts
 AX = ADDRESSOF(ROMBIOSControlBreakInterrupt); InterruptAddress[0] = AX;
 AX = ADDRESSOF(DOSControlCInterrupt);         InterruptAddress[1] = AX;
 AX = ADDRESSOF(DOSCriticalErrorInterrupt);    InterruptAddress[2] = AX;

 // Save and redirect interrupts (DOS method)
 for(SI=0; SI<3; SI++)
 {
  // Save old interrupt
  AL = InterruptNumber[SI];
  AH = 35h; INT 21h;
  C2[SI*4+28h] = BX;
  C2[SI*4+30h] = ES;

  // Redirect Interrupts
  DX = InterruptAddress[SI];
  AL = InterruptNumber[SI];
  PUSH DS; PUSH CS; POP DS; // Get Address of new Interrupt
  AH = 25h; INT 21h;        // Set Interrupt vector
  POP DS;
 }

 // Disable DOS Break checking
 AX = 3300h; INT 21h; PreviousBreak = DL; // Store origional Break state
 DL = 0; AX = 3301h; INT 21h;             // Set new Break state 
 
 // Inform DOS about TSR PSP
 AH = 51h; INT 21h; PreviousPSP = BX;     // Store origional PSP Address
 BX = TSRPSP; AH = 50h; INT 21h;          // Set new PSP Address

 // Inform DOS about new DTA Address
 AH = 2Fh; INT 21h;
 PreviousDTAAddress = BX; PreviousDTASegment = ES; // Store origional DTA Address
 PUSH DS; 
 DS = TSRPSP; DX = 80h;
 AH = 1Ah; INT 21h;          // Set new DTA Address
 POP DS;

 // Free up reserved memory
 ReleaseMemoryBlock(SegmentOfMemoryReserved);

 // Save the Mouse State
 AX = 0015h; INT 33h;                      // Get Save-State storage Size
 SaveMouseStateSegment = AllocateMemoryBlock(BX); // Allocate memory for mouse state
 if(!SaveMouseStateSegment)
 {
  cout << "Insufficient Memory\n";
  goto AbortBecauseNoMemory;
 }
 ES = SaveMouseStateSegment; DX = 0; AX = 0016h; INT 33h; // Save mouse state

 // Save the screen page number and change to page 7 (The last page)
 AH = 0Fh; INT 10h; PreviousScreenNumber = BH;   // Get Display Page number
 
 // Save the cursor attributes
 AH = 03h; INT 10h;
 PreviousCursorPosition = DX;
 PreviousCursorShape    = CX;

 Vdu.Page = BH;
 Vdu.Row = 0;
 Vdu.Column = 0;
 Vdu.BackgroundColor = BLACK;
 Vdu.ForegroundColor = WHITE;
 Vdu.Blink = 0;
 Vdu.MinCol = 0;
 Vdu.MinRow = 0;
 Vdu.MaxCol = 79;
 Vdu.MaxRow = 24;
 Vdu.CursorOn = 1;
 Mouse.Active = 0;
 Mouse.Visible = 0;
 DX = 0; AH = 02h; INT 10h;  // Set cursor position

 // Set the cursor shape
 CX = TSRCursorShape;
 AH = 01h; INT 10h;

 // Copy current page to page 7
 AX = B800h; ES = AX; // Video segment
 AL = Vdu.Page; AH = 0; SI = AX * 1000h; // Start of data for current page
 DI = 7000h;                             // Start of data for Page 7
 for(DX=0; DX<4000; DX=DX+4) { E4[DI] = E4[SI]; DI = DI + 4; SI = SI + 4; }

 // Sometimes Interrupt 9 is diverted, so make it point to this program
 AX = 0; ES = AX; 
 CLI;        // Disable Hardware Interrupts
 ApplicationInterrupt9Address = E4[0024h];
 E4[0024h] = ThisInterrupt9Address;

 // Sometimes Interrupt 16 is diverted, so make it point to this program
 ApplicationInterrupt16Address = E4[0058h];
 E4[0058h] = ThisInterrupt16Address;
 STI;       // Enable Hardware interrupts  

 // Save Stack pointer for End() function
 MainSP = SP - 2;

 // Call your TSR Application program
 TSRMain(); 

 // Make Interrupt 16 point back to the origional Appliction Program value
 CLI;        // Disable Hardware Interrupts
 E4[0058h] = ApplicationInterrupt16Address ;

 // Make Interrupt 9 point back to the origional Appliction Program value
 E4[0024h] = ApplicationInterrupt9Address ;
 STI;       // Enable Hardware interrupts  

 // Copy page 7 back to current page
 if(Mouse.Visible) HideMouse();
 AX = B800h; ES = AX; // Video segment
 AL = PreviousScreenNumber; AH = 0; SI = AX * 1000h; // Start of data for current page
 DI = 7000h;                             // Start of data for Page 7
 for(DX=0; DX<4000; DX=DX+4) { E4[SI] = E4[DI]; DI = DI + 4; SI = SI + 4; }

 // Restore the cursor position
 BH = PreviousScreenNumber;
 DX = PreviousCursorPosition;
 AH = 02h; INT 10h; 
 
 // Restore the cursor shape
 CX = PreviousCursorShape;
 AH = 01h; INT 10h;

 // Restore the screen page number
 AL = PreviousScreenNumber;
 AH = 05h; INT 10h;
 
 // Restore the Mouse State
 ES = SaveMouseStateSegment; DX = 0; AX = 0017h; INT 33h; // Restore mouse state
 ReleaseMemoryBlock(SaveMouseStateSegment);

 AbortBecauseNoMemory:

 // Reserve amount of reserved dynamic memory required again
 if(AmountOfMemoryReserved != 0)
 {
  BX = AmountOfMemoryReserved;
  AH = 48h; INT 21h; // Call DOS to Allocate memory Block
  if(CARRYFLAG) AmountOfMemoryReserved = 0; // If Error
  SegmentOfMemoryReserved = AX;
 }

 // Restore origional DTA Address
 PUSH DS; 
 DS = PreviousDTASegment;
 DX = PreviousDTAAddress;
 AH = 1Ah; INT 21h;          // Set new DTA Address
 POP DS;

 // Restore origional PSP
 BX = PreviousPSP; AH = 50h; INT 21h;     // Set new PSP Address

 // Restore previous DOS Break state
 DL = PreviousBreak; AX = 3301h; INT 21h; // Set new Break state 

 // Restore to origional interrupts (DOS method)
 for(SI=0; SI<3; SI++)
 {
  // Redirect Interrupts
  AL = InterruptNumber[SI];
  PUSH DS; 
  // Get Address of origional Interrupt
  DX = C2[SI*4+28h];
  BX = C2[SI*4+30h]; DS = BX;
  AH = 25h; INT 21h;          // Set Interrupt vector
  POP DS;
 }

 HotKeyPressed = FALSE;

 SS = PreviousSS;
 SP = PreviousSP;
 TSRActive = FALSE; 
}

