#INCLUDE "CLASSY2.CH"
#INCLUDE "FUNCKY.CH"
//  Class Ŀ
//          Name: Cnt62ASCII                                                 
//   Description: "Base 62" counter, 0-9 & A-Z.                              
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:04:52pm            Time updated: 03:04:52pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//  Parent class: CntASCII                                                   
//      See Also:                                                            
// 
//       History: $History: CNT62ASC.PRG $
/**/
/******************  Version 3  ******************/
/*User: Chris        Date: 5/03/94    Time: 1:28p */
/*Updated in /GBTLib*/
/*Added History keyword for version control and changed copyright to GBT.*/
/**/
/******************  Version 2  ******************/
/*User: Chris        Date: 5/02/94    Time: 3:09p */
/*Updated in /GBTLib*/
/*Standardized and improved documentation.*/
//

CREATE CLASS Cnt62ASCII INHERIT CntASCII

PROTECTED:

	METHOD LastASCII                     // Determines last ASCII character.
	METHOD NextASCII                     // Determines next ASCII character.

EXPORT:


	METHOD Init
	METHOD Reset                      // Resets to first ASCII character.

END CLASS

//  Method Ŀ
//          Name: Init()                                                     
//   Description: Initialize the class.                                      
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:06:11pm            Time updated: 03:06:11pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cInitial                                                   
//  Return Value: (self)                                                   
//      See Also:                                                            
// 
METHOD Init( cInitial ),( cInitial )
RETURN (self)

//  Method Ŀ
//          Name: LastASCII()                                                
//   Description: Return last ASCII character in set.                        
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:06:24pm            Time updated: 03:06:24pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cChar                                                      
//  Return Value: @( if@( ASC@( cChar @)==122, @.T@., @.F@. @) @)                      
//      See Also:                                                            
// 
METHOD LastASCII( cChar )
RETURN( if( ASC( cChar )==122, .T., .F. ) )

//  Method Ŀ
//          Name: Reset()                                                 
//   Description: Reset to first ASCII character in set.                     
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:06:40pm            Time updated: 03:06:40pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: None                                                       
//  Return Value: @( CHR@(48@) @)                                              
//      See Also:                                                            
// 
METHOD Reset()
RETURN ( CHR(48) )

//  Method Ŀ
//          Name: NextASCII()                                                
//   Description: Increment to next ASCII character in set.                  
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:06:55pm            Time updated: 03:06:55pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cChar                                                      
//  Return Value: @( chr@( nASC @) @)                                            
//      See Also:                                                            
// 
METHOD NextASCII( cChar )

	Local ;
		nASC := ASC( cChar )+1

	IF (nASC > 57) .AND. (nASC < 65)     // Outside 0-9.
		nASC := 65                         // A.
	ELSEIF (nASC >90 ) .AND. (nASC < 97) // Outside A-Z.
		nASC := 97                         // a.
	END

RETURN ( chr( nASC ) )
