#INCLUDE "CLASSY2.CH"
#INCLUDE "FUNCKY.CH"

//  Class Ŀ
//          Name: CntAlphaNum                                                
//   Description: Alphanumeric ASCII counter (not lower a-z).                
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:08:56pm            Time updated: 03:08:56pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//  Parent class: CntASCII                                                   
//      See Also:                                                            
// 
//       History: $History: CNTALPNM.PRG $
/**/
/******************  Version 3  ******************/
/*User: Chris        Date: 5/03/94    Time: 1:28p */
/*Updated in /GBTLib*/
/*Added History keyword for version control and changed copyright to GBT.*/
/**/
/******************  Version 2  ******************/
/*User: Chris        Date: 5/02/94    Time: 3:09p */
/*Updated in /GBTLib*/
/*Standardized and improved documentation.*/
//

CREATE CLASS CntAlphaNum INHERIT CntASCII

PROTECTED:

	METHOD LastASCII                     // Determines last ASCII character.
	METHOD NextASCII                     // Determines next ASCII character.

EXPORT:

	METHOD Init
	METHOD Reset                      // Resets to first ASCII character.

END CLASS

//  Method Ŀ
//          Name: Init()                                                     
//   Description: Initialize the class.                                      
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:09:26pm            Time updated: 03:09:26pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cInitial                                                   
//  Return Value: (self)                                                   
//      See Also:                                                            
// 
METHOD Init( cInitial ),( cInitial )
RETURN (self)

//  Method Ŀ
//          Name: LastASCII()                                                
//   Description: Return the last character in the set.                      
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:09:35pm            Time updated: 03:09:35pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cChar                                                      
//  Return Value: @( if@( ASC@( cChar @)==90, @.T@., @.F@. @) @)                       
//      See Also:                                                            
// 
METHOD LastASCII( cChar )
RETURN( if( ASC( cChar )==90, .T., .F. ) )

//  Method Ŀ
//          Name: Reset()                                                 
//   Description: Reset to the first character in the set.                   
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:09:50pm            Time updated: 03:09:50pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: None                                                       
//  Return Value: @( CHR@(48@) @)                                              
//      See Also:                                                            
// 
METHOD Reset()
RETURN ( CHR(48) )

//  Method Ŀ
//          Name: NextASCII()                                                
//   Description: Increment to the next character in the set.                
//        Author: Chris Pels                                                 
//  Date created: 04-13-94              Date updated: 04-13-94              
//  Time created: 03:10:01pm            Time updated: 03:10:01pm            
//     Copyright: Greenwich Bay Technologies                                 
// Ĵ
//     Arguments: cChar                                                      
//  Return Value: @( chr@( nASC @) @)                                            
//      See Also:                                                            
// 
METHOD NextASCII( cChar )

	Local ;
		nASC := ASC( cChar )+1

	IF (nASC > 57) .AND. (nASC < 65)     // Outside 0-9.
		nASC := 65                         // A.
	END

RETURN ( chr( nASC ) )
