#include "Controller.h"

@implementation Controller

- windowWillClose: sender
{
  if (WinMessageBox (HWND_DESKTOP,[sender window],
		     "Do you really want to quit?",
		     "Listbox sample",
		     0,MB_YESNO | MB_QUERY) == MBID_YES)
    return self;
  else
    return nil;
}

- windowDidResize: sender
{
  ListBox *listBox = [sender findFromID: 1001];

  [listBox setSize: 0:0:[sender width]:[sender height]];
  return self;
}

- (MRESULT) handleMessage: (ULONG) msg withParams: (MPARAM) mp1
                      and: (MPARAM) mp2 : sender
{
  if ((msg == WM_CONTROL) && 
      (SHORT1FROMMP (mp1) == 1001) && 
      (SHORT2FROMMP (mp1) == LN_SELECT)) {
    char *buffer;

    buffer = [[sender findFromID: 1001] 
	    item: [[sender findFromID: 1001] selected]
	    text: NULL];

    [sender setTitle: buffer];

    free (buffer);
  }

  return (MRESULT) FALSE;
}

@end
