#ifndef _LIST_H_
#define _LIST_H_

#include <objc/os2.h>
#include <objc/Object.h>

@interface List : Object
{
  ULONG  key;
  void  *data;
  List  *next;
}

- init: (ULONG) aKey data: (void *) aData;
- free;

- insert: (List *) element;
- (int) compare: (List *) elem1 with: (List *) elem2;

- find: (ULONG) aKey;

- setKey: (ULONG) aKey;
- setData: (void *) aData;
- setNext: (List *) element;
- (ULONG) key;
- (void *) data;
- next;

@end

#endif
