*:*****************************************************************************
*:
*: Procedure file: E:\MAILMERG\MERGE.PRG
*:
*:         System: Mail Merge
*:         Author: Phil Barnett
*:      Copyright (c) NONE, Donated to Public Domain June 1994
*:  Last modified: 06/26/94     23:50
*:
*:  Procs & Fncts: MERGE()
*:
*:      Documented 06/26/94 at 23:50                SNAP!  version 5.02
*:*****************************************************************************
#include "common.ch"
#include "box.ch"
#include "mailmerg.ch"
*!*****************************************************************************
*!
*!       Function: MERGE()
*!
*!          Calls: PRB_POP.PRG
*!               : NEWXPND.PRG
*!               : ATTENTION()        (function  in PRB_POP.PRG)
*!               : POP_MSG()          (function  in PRB_POP.PRG)
*!               : PICKFILE()         (function  in PICKFILE.PRG)
*!               : MERGEDIT()         (function  in MERGEDIT.PRG)
*!               : MERGPRNT()         (function  in MERGPRNT.PRG)
*!
*!           Uses: PR_CODES.DBF       
*!
*!        Indexes: PR_CODES.NTX       
*!
*!*****************************************************************************
function MERGE()

local PROMPTS
local selection := 1
local MENU_WIDTH, MENU_DEPTH
local LC, TR, br, RC, FILE_NAME, TXT
LOCAL HEADEREND, header, DATA_FILE

field PR_TOKEN

*# SNAPCODE do PRB_POP
*# SNAPCODE do NEWXPND

set wrap (.t.)

use PR_CODES NEW
if !file('pr_codes.ntx')
   index on PR_TOKEN to PR_CODES
else
   set index to PR_CODES
endif

do while .t.
   Cls()
   
   ATTENTION( 'Pure Clipper (almost) Mail Merge', 4 )
   ATTENTION( 'Public Domain from Phil Barnett', 22 )
   
   MENU_WIDTH := 35
   MENU_DEPTH := 3
   
   LC := Maxcol() / 2 - MENU_WIDTH / 2
   TR := int( maxrow() / 2 ) - 2
   br := TR + MENU_DEPTH + 1
   RC := LC + MENU_WIDTH
   
   dispbox( TR, LC, br, RC, B_DOUBLE_SINGLE + ' ', 'GR+/GR' )
   
   setcolor( 'GR+/GR' )
   
   @ TR + 1, LC + 1 prompt '  E - Edit or Create a Text File  '
   @ TR + 2, LC + 1 prompt '  P - Print the Mail Merge        '
   @ TR + 3, LC + 1 prompt '  X - <Esc>                       '
   
   menu to selection
   
   if selection == 3 .or. lastkey() == 27
      exit
   endif
   
   Cls()
   do case
   case selection == 1
      MERGEDIT( )
   case selection == 2
      ATTENTION( 'Select a Text File to Merge', 5 )
      ATTENTION( 'Press <Esc> to start a new Text File.', 23 )
      FILE_NAME := PICKFILE( "*.MRG" )
      if Empty( FILE_NAME )
         loop
      endif
      TXT := memoread( FILE_NAME )

      if at( HEADER_SEPARATOR, txt ) == 0
         POP_MSG({'You must use the edit feature','to attach a file to this merge file'})
         return NIL
      ENDIF

      POP_MSG( 'Processing ' + alltrim( FILE_NAME ) + ', Please Wait . . .', .f. )
      ATTENTION( 'Press <Esc> to abort process', 24 )

      set print (.t.)
      set console (.f.)
      MERGPRNT( TXT )  // sets page length for forms
      set print (.f.)
      set console (.t.)

      pop_msgscr()

      select FILE_BASE
      dbclosearea()
   endcase
   
enddo

Cls( 'w/n', 32 )

return NIL

external Ampm
*: EOF: MERGE.PRG
