*:*****************************************************************************
*:
*: Procedure file: E:\MAILMERG\NEWXPND.PRG
*:
*:         System: Mail Merge
*:         Author: Phil Barnett
*:      Copyright (c) NONE, Donated to Public Domain June 1994
*:  Last modified: 06/26/94     23:50
*:
*:  Procs & Fncts: EXPAND_TXT()
*:
*:         Set by: MERGE()            (function  in MERGE.PRG)
*:
*:      Documented 06/26/94 at 23:50                SNAP!  version 5.02
*:*****************************************************************************
#include 'mailmerg.ch'

*!*****************************************************************************
*!
*!       Function: EXPAND_TXT()
*!
*!      Called by: MERGPRNT()         (function  in MERGPRNT.PRG)
*!
*!          Calls: ATTENTION()        (function  in PRB_POP.PRG)
*!               : POP_MSG()          (function  in PRB_POP.PRG)
*!               : CR_COUNT()         (function  in ?)
*!
*!*****************************************************************************
function EXPAND_TXT( THE_MEMO, ABORTED )

local NUM_LINES, I, THIS_LINE, START_MARK, END_MARK, META_TYPE
local NO_TRIM, FLD_POS, FLD_DATA, IS_REPL, REP_COMMAND, NSM
local STARTMARK, META_SYMBOL, REP_WITH, FLAG1, DONE_YET,THE_TEXT
local CRLF := chr(13)+chr(10)
local CURR_LM, CURR_RM, REAL_CHAR, CRLF_FLAG, CUR_PNTR, REAL_CHARS
local THIS_CHAR, TEMP_STR, _TS, REMEMBER, M_TOKEN

memvar SOME_TEXT

private SOME_TEXT

ATTENTION( alltrim( str( recno() ) ), 16 )

NO_TRIM := !(0 = at( LEFTPDELIM + 'NOTRIM' + RIGHTPDELIM, THE_MEMO ) )

if NO_TRIM
   THE_MEMO := strtran( THE_MEMO, LEFTPDELIM + 'NOTRIM' + RIGHTPDELIM )
endif

******************************
* Enforce Replicate function *
******************************

IS_REPL := at( LEFTPDELIM + 'RC', THE_MEMO )
do while IS_REPL > 0
   REP_COMMAND := substr( THE_MEMO, IS_REPL + 1, 10 )
   
   THE_MEMO := left( THE_MEMO, IS_REPL - 1 ) + ;
      replicate( chr( val( substr( REP_COMMAND, 3, 3 ) ) ) , ;
      val( substr( REP_COMMAND, 7, 3 ) ) ) + ;
      substr( THE_MEMO, IS_REPL + 12 )
   
   IS_REPL := at( LEFTPDELIM + 'RC', THE_MEMO )
enddo

***************************
* Look for 'META symbols' *
***************************

START_MARK := at( LEFT_DELIM, THE_MEMO )

if START_MARK > 0
   do while .t.
      if inkey() = 27 .or. lastkey() = 27
         ABORTED := .t.
         return 0
      endif
      
      **************************
      * Expand the META symbol *
      **************************
      
      END_MARK := at( RIGHT_DELIM, substr( THE_MEMO, START_MARK + 1 ) )
      
      NSM := at( LEFT_DELIM, substr( THE_MEMO, START_MARK + 1 ) )
      
      if ( ( END_MARK > 12 .or. NSM < END_MARK ) .and. ;
            NSM != 0 ) .or. END_MARK == 0
         
         POP_MSG( 'Location ' + alltrim( str( STARTMARK, 5 ) ) + ;
            '  Damaged Field Symbol => ' + ;
            substr( THE_MEMO, START_MARK, min( 10, NSM ) ) )
         START_MARK += at( LEFT_DELIM, substr( THE_MEMO, START_MARK + 1 ) )
         loop
      endif
      
      META_SYMBOL := substr( THE_MEMO, START_MARK + 1, END_MARK - 1 )
      
      FLD_POS := fieldpos( META_SYMBOL )
      
      if FLD_POS == 0
         POP_MSG( 'Field => ' + META_SYMBOL + ' <= not from this database.' )
         REP_WITH := ''
      else
         
         FLD_DATA := fieldget( FLD_POS )
         
         META_TYPE := valtype( FLD_DATA )
         
         do case
         case META_TYPE = 'C'
            if NO_TRIM
               REP_WITH := FLD_DATA
            else
               REP_WITH := trim( FLD_DATA )
            endif
         case META_TYPE = 'D'
            REP_WITH := dtoc( FLD_DATA )
         case META_TYPE = 'N'
            if NO_TRIM
               REP_WITH := str( FLD_DATA )
            else
               REP_WITH := ltrim( str( FLD_DATA ) )
            endif
         case META_TYPE = 'M'
            REP_WITH := FLD_DATA
         endcase
      endif
      
      
      ****************************************
      * Handle the expanded symbol correctly *
      ****************************************
      
      
      FLAG1 := ( substr( THE_MEMO, END_MARK + 1, 1 ) == chr( 13 ) )
      
      do case
         * There was something in the field
      case !empty( REP_WITH )
         
         THE_MEMO := left( THE_MEMO, START_MARK - 1 ) + ;
            REP_WITH + ;
            substr( THE_MEMO, START_MARK + END_MARK + 1 )
         
         * it was empty and there was an eol flag
      case REP_WITH == "" .and. FLAG1
         
         THE_MEMO := left( THE_MEMO, START_MARK - 1 ) + ;
            substr( THE_MEMO, START_MARK + END_MARK + 3 )
         
         * it was empty and there was NO eol flag
      case REP_WITH == "" .and. !FLAG1
         
         THE_MEMO := left( THE_MEMO, START_MARK - 1 ) + ;
            substr( THE_MEMO, START_MARK + END_MARK + 2 )
         
      otherwise
         
         THE_MEMO := left( THE_MEMO, START_MARK - 1 ) + ;
            substr( THE_MEMO, START_MARK + END_MARK + 1 )
         
      endcase
      
      *******************************
      * Check for more META symbols *
      *******************************
      
      DONE_YET := at( LEFT_DELIM, substr( THE_MEMO, START_MARK ) )
      if DONE_YET = 0
         exit
      endif
      START_MARK += DONE_YET - 1
      
   enddo
endif

**************************************************************************
* Look for Margins and Insert CRLF's & keep track of new margin commands *
* CRLF will be inserted between words for perfect wordwrap.              *
**************************************************************************

THE_TEXT := strtran( THE_MEMO, chr( 141 ) + chr( 10 ), ' ' )
THE_MEMO := ''

CURR_LM := 0
CURR_RM := 78
do while !Empty( THE_TEXT )
   if inkey() = 27 .or. lastkey() = 27
      ABORTED := .t.
      return 0
   endif
   REAL_CHARS := 0
   CRLF_FLAG := .f.
   CUR_PNTR := 1
   
   do while REAL_CHARS < CURR_RM - CURR_LM
      
      THIS_CHAR := substr( THE_TEXT, CUR_PNTR, 1 )
      CUR_PNTR ++
      REAL_CHARS ++
      do case
      case THIS_CHAR = chr( 13 )
         CRLF_FLAG := .t.
         exit
      case THIS_CHAR = chr( 243 )
         if substr( THE_TEXT, CUR_PNTR, 2 ) = 'ML'
            TEMP_STR := substr( THE_TEXT, CUR_PNTR + 2, 3 )
            CURR_LM := val( TEMP_STR )
         endif
         if substr( THE_TEXT, CUR_PNTR, 2 ) = 'MR'
            TEMP_STR := substr( THE_TEXT, CUR_PNTR + 2, 3 )
            CURR_RM := val( TEMP_STR )
         endif
         do while THIS_CHAR <> chr( 242 )
            THIS_CHAR := substr( THE_TEXT, CUR_PNTR, 1 )
            CUR_PNTR ++
         enddo
      otherwise
      endcase
   enddo
   
   
   if CRLF_FLAG
      THE_MEMO += left( THE_TEXT, CUR_PNTR )
   else
      _TS := left( THE_TEXT, CUR_PNTR )
      CUR_PNTR := if( rat( ' ', _TS ) = 0, CUR_PNTR, rat( ' ', _TS ) )
      THE_MEMO += left( THE_TEXT, CUR_PNTR ) + CRLF
   endif
   THE_TEXT := substr( THE_TEXT, CUR_PNTR + 1 )
   CRLF_FLAG := .f.
enddo

*********************************************
* Look for 'META symbols' FOR PRINTER CODES *
*********************************************

THE_TEXT := THE_MEMO
THE_MEMO := THE_TEXT

REMEMBER := select()
select PR_CODES
set order to 1


START_MARK := at( LEFTPDELIM, THE_MEMO )

if START_MARK > 0
   do while .t.
      if inkey() == 27 .or. lastkey() == 27
         ABORTED := .t.
         return 0
      endif
      
      **********************************
      * Expand the Printer META symbol *
      **********************************
      
      END_MARK := at( RIGHTPDELIM, substr( THE_MEMO, START_MARK + 1 ) )
      
      NSM := at( LEFTPDELIM, substr( THE_MEMO, START_MARK + 1 ) )
      
      if ( ( END_MARK > 12 .or. NSM < END_MARK ) .and. ;
            !NSM = 0) .or. END_MARK = 0
         
         POP_MSG( 'Location ' + alltrim( str( START_MARK, 5 ) ) + ;
            ' Damaged Printer Code Symbol => '+;
            substr( THE_MEMO, START_MARK, min( 10, NSM ) ) )
         
         START_MARK += at( LEFTPDELIM, substr( THE_MEMO, START_MARK + 1 ) )
         loop
      endif
      
      META_SYMBOL := substr( THE_MEMO, START_MARK + 1, END_MARK - 1 )
      dbseek( META_SYMBOL )
      
      M_TOKEN := PR_CODES->PR_TOKEN
      
      do case
      case upper( META_SYMBOL ) = 'DATEFULL'
         
         REP_WITH := cmonth( date() ) + ' ' + ;
            alltrim( substr( dtoc( date() ), 4, 2 ) ) + ', ' + ;
            str( year( date() ), 4 )
         
      case found() .and. META_SYMBOL == alltrim( M_TOKEN )
         SOME_TEXT := PR_CODES->PR_CODE
         REP_WITH := &SOME_TEXT
      otherwise
         POP_MSG('Symbol => ' + META_SYMBOL + ;
            ' <= not found in Printer Code table.')
         REP_WITH := ''
      endcase
      
      
      ****************************************
      * Handle the expanded symbol correctly *
      ****************************************
      
      
      
      THE_MEMO := left( THE_MEMO, START_MARK - 1 ) + REP_WITH + ;
         substr( THE_MEMO, START_MARK + END_MARK + 1 )
      
      
      *******************************
      * Check for more META symbols *
      *******************************
      
      DONE_YET := at( LEFTPDELIM, substr( THE_MEMO, START_MARK ) )
      if DONE_YET = 0
         exit
      endif
      START_MARK += DONE_YET - 1
      
   enddo
endif
select(REMEMBER)

*******************************
* Print out the entire letter *
*******************************

THE_MEMO := strtran( THE_MEMO , chr( 141 ) + chr( 10 ) , ' ' )

THE_MEMO := strtran( THE_MEMO, chr( 32 ) + chr( 13 ), chr( 13 ) )

if right( THE_MEMO, 2 ) <> CRLF
   THE_MEMO += CRLF
endif

?? THE_MEMO

return CR_COUNT( THE_MEMO )
*: EOF: NEWXPND.PRG
