*:*****************************************************************************
*:
*: Procedure file: E:\MAILMERG\PICKFILE.PRG
*:
*:         System: Mail Merge
*:         Author: Phil Barnett
*:      Copyright (c) NONE, Donated to Public Domain June 1994
*:  Last modified: 06/26/94     23:48
*:
*:  Procs & Fncts: PICKFILE()
*:
*:      Documented 06/26/94 at 23:50                SNAP!  version 5.02
*:*****************************************************************************
/*
PICKFILE.PRG

Author     : Phil Barnett

Written    : 18-Apr-93

Function   : PICKFILE()

Purpose    : Generic file picking routine that pops a picklist of files.

Syntax     : PICKFILE( [FILESPEC] )

Parameters : FILESPEC is a DOS filename. Wildcards permitted

Returns    : Character file name of selected file or "" if nothing picked.

Example    : yourfile := pickfile( '*.dbf' )

if empty(yourfile)
? 'You pressed Escape or No Matching File'
else
? 'The file you selected is: '+yourfile
endif

Released to Public Domain by Author.             

*/

#include "box.ch"
#include "directry.ch"
#include "common.ch"
   
*!*****************************************************************************
*!
*!       Function: PICKFILE()
*!
*!      Called by: MERGE()            (function  in MERGE.PRG)
*!               : MERGEDIT()         (function  in MERGEDIT.PRG)
*!
*!*****************************************************************************
function PICKFILE( CFILESPEC, CURRENT_FILE )

local COLDSTRING := Savescreen( 8, 19, 16, 61 )
local AFILES := directory( CFILESPEC )
local APICKLIST := {}
local CRETVAL := ''
local SEL
LOCAL POINTER := ASCAN( AFILES, {|XX| XX[1] == CURRENT_FILE } )

Default CFILESPEC to '*.*'
DEFAULT CURRENT_FILE TO ''

dispbox( 8, 19, 16, 61, B_SINGLE + " ", "+W/R" )

if len( AFILES ) > 0
   
   aeval( AFILES, {|XX| Aadd( APICKLIST, ;
               pad( XX[ F_NAME ],13 ) + ;
               str( XX[ F_SIZE ],8 ) + '  ' + ;
              dtoc( XX[ F_DATE ] ) + '  ' + ;
                    XX[ F_TIME ] ) } )
   
   SEL := achoice( 9, 20, 15, 60, APICKLIST,,, POINTER )
   
   CRETVAL := iif( lastkey() == 27, '', AFILES[ sel ][ 1 ] )
   
else
   
   SEL := achoice( 9, 20, 15, 60, { "No files match " + CFILESPEC } )
   
endif

restscreen( 8, 19, 16, 61, COLDSTRING )

return CRETVAL

*: EOF: PICKFILE.PRG
