; File......: DISPA.ASM
; Author....: Mike Taylor
; CIS ID....: ?

; This is an original work by Mike Taylor and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
;     Rev 1.4   01 Jan 1995 03:01:00   TED
;  Modified video detection to use CRT controller base address rather
;  than current video mode.  Also converted to IDEAL mode because
;  simplified segment directives were generating incorrect segment
;  fixups which generated GPFs in protected mode.
;
;     Rev 1.3   14 Feb 1994 16:47:46   GLENN
;  Malc Shedden fixed for protected mode; Steve Tyrakowski modified
;  for CPMI compatibility.
;
;     Rev 1.2   15 Aug 1991 23:06:48   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;
;     Rev 1.1   14 Jun 1991 19:54:28   GLENN
;  Minor edit to file header
;
;     Rev 1.0   01 Apr 1991 01:03:14   GLENN
;  Nanforum Toolkit
;
;

IDEAL
P286

Public    __ft_vconfig
Public    __ft_gotoxy
Public    __ft_fileread
Public    __ft_fileseek
Public    __ft_getkey

Extrn     cpmiProtectedPtr:Far
Extrn     cpmiIsProtected:Far

Group     DGROUP    _DATA

Segment   _DATA     Word      Public    "DATA"

VidSel    DW        0

Ends      _DATA



Segment   _Nanfor   Word      Public    "CODE"
          Assume    CS:_Nanfor,DS:DGROUP

Proc      __ft_vconfig        Far

          Mov       AX,[VidSel]                   ; Get video selector
          Or        AX,AX                         ; Is there one already?
          JNZ       V2                            ; Yes, don't create another

          Mov       AX,40h                        ; Low memory selector
          Mov       ES,AX                         ; Load selector into ES
          Mov       AX,0B800h                     ; Default to color
          Cmp       [Word Ptr ES:63h],3B4h        ; Check for mono
          JNE       V1                            ; No, continue
          Mov       AX,0B000h                     ; Yes, switch to mono

V1:       Mov       [VidSel],AX                   ; Save the segment
          Call      cpmiIsProtected               ; Check for protected mode
          Or        AX,AX                         ; 0=real, else protected
          Mov       AX,[VidSel]                   ; Load return value
          JZ        V2                            ; If real, done

          Push      AX                            ; Pass segment
          Push      0                             ; Pass offset
          Push      8000h                         ; Length of video buffer
          Call      cpmiProtectedPtr              ; Generate selector
          Mov       [VidSel],AX                   ; Save the selector

V2:       RetF                                    ; Return segment in AX
Endp      __ft_vconfig



Proc      __ft_gotoxy         Far

          Push      BP              ; save the caller's BP register
          Mov       BP,SP           ; establish our base pointer into the stack

          Xor       AX,AX           ; clear AX register
          Xor       BX,BX           ; bx = 0 means video page 0
          Mov       DH,[BP + 8]     ; get y coordinate
          Mov       DL,[BP + 6]     ; get x coordinate
          Mov       AH,2            ; bios function 02h, set cursor position
          Int       10h

          Xor       AX,AX           ; clear AX register

          Pop       BP
          RetF
Endp      __ft_gotoxy



Proc      __ft_fileread       Far

          Push      BP              ; save the caller's BP register
          Mov       BP,SP           ; establish our base poInter Into the stack

          Push      DS
          Mov       BX,[BP + 6]     ; file handle
          Mov       DX,[BP + 8]     ; offset of buffer
          Mov       AX,[BP + 10]    ; segment of buffer
          Mov       DS,AX           ; make buffer segment Into default data segment
          Mov       Cx,[BP + 12]    ; byte count to read in
          Mov       AX,3F00h        ; dos function 3fh, file block read
          Int       21h
          Pop       DS
          JNC       fr1             ; if carry flag set then error occured
          Xor       AX,AX           ;   and notify by returning 0 bytes
                                    ; otherwise AX will contain the actual
                                    ; bytes read in.

fr1:      Pop       BP
          RetF
Endp      __ft_fileread



Proc      __ft_fileseek       Far

        Push        BP              ; save the caller's BP register
        Mov         BP,SP           ; establish our base poInter Into the stack

        Mov         BX,[BP + 6]     ; file handle
        Mov         CX,[BP + 10]    ; msb of long offset parameter
        Mov         DX,[BP + 8]     ; lsb of long offset parameter
        Mov         AL,[BP + 12]    ; seek direction code
        Mov         AH,42h          ; dos function 42h, set file poInter
        Int         21h

        JNC         fs1             ; if carry flag not set, no error
        Xor         AX,AX           ; if error, clear poInter msb and lsb
        Xor         DX,DX

fs1:    Pop         BP
        RetF
Endp      __ft_fileseek



Proc      __ft_getkey         Far

          Xor       AX,AX           ; clear AX register
          Mov       AH,07h          ; dos function 07h, get key pressed
          Int       21h

          Mov       AH,0            ; zero out msb of AX to make sure returned
          RetF                      ; value is only a byte value

Endp      __ft_getkey
Ends      _NanFor
End