; File......: REBOOT.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
;
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
;     Rev 1.3   01 Jan 1995 03:01:00   TED
;  Added dual-mode capability.
;
;     Rev 1.2   15 Aug 1991 23:08:04   GLENN
;  Forest Belt proofread/edited/cleaned up doc
;
;     Rev 1.1   12 Jun 1991 01:28:02   GLENN
;  Added choice of warm or cold reboot.  Documentation and code change.
;
;     Rev 1.0   01 Apr 1991 01:03:50   GLENN
;  Nanforum Toolkit
;



;  $DOC$
;  $FUNCNAME$
;      FT_REBOOT()
;  $CATEGORY$
;      DOS/BIOS
;  $ONELINER$
;      Force a warm or cold boot
;  $SYNTAX$
;      FT_REBOOT( <nBootType> ) -> NIL
;  $ARGUMENTS$
;      <nBootType> is used to indicate the type of reboot.  A value of zero
;      will cause a cold boot, while any other value will cause a warm boot.
;  $RETURNS$
;      NIL
;  $DESCRIPTION$
;      This function is valuable if you need to reboot the PC for some
;      reason; e.g. an installation routine that modifies CONFIG.SYS or
;      AUTOEXEC.BAT.
;
;      The source code is written to adhere to Turbo Assembler's IDEAL mode.
;      To use another assembler, you will need to rearrange the PROC and
;      SEGMENT directives, and also the ENDP and ENDS directives (a very
;      minor task).
;  $EXAMPLES$
;      #define COLD 0
;      #define WARM 1
;
;      // Issue a warm boot
;
;      FT_Reboot(WARM)
;
;  $END$
;


IDEAL
P286

Public    FT_REBOOT

Extrn     __ParNI:Far
Extrn     cpmiIsProtected:Far
Extrn     cpmiProtectedPtr:Far
Extrn     cpmiMakeAlias:Far
Extrn     cpmiFarCallReal:Far

Segment   _NanFor   Word      Public    "CODE"
          Assume    CS:_NanFor

Proc      FT_REBOOT Far

          Mov       AX,1                          ; Specify first param
          Push      AX                            ; Put on stack
          Call      __ParNI                       ; Get param
          Mov       DX,40h                        ; Get selector for low mem
          Mov       ES,DX                         ; Set DS to low memory
          Or        AX,AX                         ; Cold boot requested?
          JZ        @@POST                        ; If so, don't set for warm
          Mov       AX,1234h                      ; Set up AX for warm boot

@@POST:   Mov       [Word Ptr ES:72h],AX          ; Indicate a warm boot

          Call      cpmiIsProtected               ; Do protected mode check
          Or        AX,AX                         ; Real mode?
          JNZ       @@PMode                       ; If not, can't reboot yet
          DB        0EAh                          ; JMP to POST -- this method
          DD        0F000FFF0h                    ; overcomes TASM bug

@@PMode:  Push      0F000h                        ; Segment of POST
          Push      0FFF0h                        ; Offset of POST
          Push      DS
          Push      0
          Push      DS
          Push      0
          Call      cpmiFarCallReal

Endp     FT_REBOOT
Ends     _NanFor
End