; File......: SETLASTK.ASM
; Author....: Ted Means
; CIS ID....: 73067,3332
;
; This is an original work by Ted Means and is placed in the
; public domain.
;
; Modification history:
; ---------------------
;
;     Rev 1.0   01 Jul 1992 01:23:06   GLENN
;  Initial revision.
;

;  $DOC$
;  $FUNCNAME$
;     FT_LASTKEY()
;  $CATEGORY$
;     Keyboard/Mouse
;  $ONELINER$
;     Force LastKey() to return a programmer-defined value.
;  $SYNTAX$
;     FT_LastKey( <nKey> ) -> NIL
;  $ARGUMENTS$
;     <nKey> is the Inkey() value of the desired key.
;  $RETURNS$
;     NIL
;  $DESCRIPTION$
;     It is occasionally useful to force LastKey() to return a known value.
;     This is easily accomplishing by using the KEYBOARD command, but this
;     has undesireable side effects (the keyboard buffer is cleared, and
;     the keystroke is processed whether you needed it to be or not).  This
;     function accomplishes the same task but without the side effects.  It
;     does so by directly modifying the memory location where Clipper stores
;     the LastKey() value.
;
;     Some highly unorthodox programming techniques, not to mention rather
;     strange use of Clipper internals, was necessary to make this function
;     work.  If this makes you uncomfortable, then don't use this function,
;     you worthless crybaby.
;  $EXAMPLES$
;     keyboard chr( K_ESC )
;
;     ? lastkey()  // returns 27
;
;     FT_LastKey( K_F1 )
;
;     ? lastkey()  // now returns 28
;  $END$
;

IDEAL

Public    FT_LastKey

Extrn     LastKey:Far
Extrn     __ParNL:Far

Segment   _NanFor   Word      "CODE"
          Assume    CS:_NanFor

Proc      FT_LastKey          Far

          Mov       AX,1                          ; Specify param #1
          Push      AX                            ; Put on stack
          Call      __ParNL                       ; Get key value
          Add       SP,2                          ; Realign stack

          Mov       CX,Seg LastKey                ; Load segment of known symbol
          Mov       BX,Offset LastKey             ; Load offset of known symbol
          Mov       ES,CX                         ; Load segment register
          Mov       BX,[Word Ptr ES:BX + 14]      ; Get address
          Mov       [Word Ptr BX],AX              ; Store key value
          Mov       [Word Ptr BX + 2],DX
          RetF
Endp      FT_LastKey
Ends      _NanFor
End