/*
 * File......: ONIDLE.C
 * Author....: Ted Means
 * CIS ID....: 73067,3332
 *
 * This function is an original work by Ted Means and is placed in the
 * public domain.
 *
 * Modification history:
 * ---------------------
 *
 *    Rev 1.0   01 Jan 1995 03:01:00   TED
 * Initial release
 */


/*  $DOC$
 *  $FUNCNAME$
 *     FT_OnIdle()
 *  $CATEGORY$
 *     Event
 *  $ONELINER$
 *     Evaluate a designated code block during idle states.
 *  $SYNTAX$
 *     FT_OnIdle( bCode )
 *  $ARGUMENTS$
 *     <bCode> is the code block to evaluate.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This function allows you to evaluate code blocks in the background
 *     while the foreground is in an idle state.
 *
 *     To halt the evaluation of the code block during idle states, call
 *     FT_OnIdle() with no arguments.
 *
 *     This function makes heavy use of several undocumented internal
 *     routines.  If this fact makes you uncomfortable then don't use
 *     this function, you putrid pile of chicken excrement.
 *  $EXAMPLES$
 *
 *     FT_OnIdle( {|| QOut( "Hey, I'm not busy!" )} )
 *
 *     Inkey( 0 )    // Let the fun begin
 *  $SEEALSO$
 *     FT_Idle()
 *  $END$
 */

#include <EXTEND.API>
#include <ITEM.API>

typedef struct
{
   unsigned int unknown;
   unsigned int ID;
} EVENT;

unsigned int _evRegReceiverFunc( void *, unsigned int );
void _evDeregReceiver( unsigned int );

static ITEM codeBlock;
static unsigned int Handle = 0;

static void theReceiver( EVENT * event )
{
   auto EVALINFO eval;

   if ( event->ID == 0x5108 )
   {
      _evalNew( &eval, codeBlock );

      _itemRelease( _evalLaunch( &eval ) );
   }

   return;
}



void pascal FT_OnIdle( void )
{
   if ( Handle != 0 )
   {
      _evDeregReceiver( Handle );

      Handle = 0;
   }

   codeBlock = _itemParam( 1 );

   if ( _itemType( codeBlock ) == BLOCK )
       Handle = _evRegReceiverFunc( theReceiver, 0x6001 );

   return;
}