/*
 * File......: VIDEO1.C
 * Author....: Robert A. DiFalco
 * CIS ID....: 71610,1705
 *
 * This function is an original work by Robert A. DiFalco and is placed
 * in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 *    Rev 1.6   01 Jan 1995 03:01:00   TED
 * Ted Means updated source code to use the CPMI functions for dual-mode
 * operation.
 *
 *    Rev 1.5   27 Dec 1993 00:56:16   GLENN
 * Robert van der Hulst (CIS ID: 70032,1725) corrected a problem in line 181
 * (FT_WRTCHR) which contained (iTRow * _gtMaxCol() + 1), which he changed to
 * (iTRow * (_gtMaxCol() + 1)) because `calculation takes precedence over
 * addition.'
 *
 *
 *    Rev 1.4   23 Sep 1991 01:07:12   GLENN
 * Mark Lussier corrected a bug in the doc for FT_SETATTR() in the example.
 * For Bright White on Magenta, the value should be 95, not 165.
 *
 *    Rev 1.3   15 Aug 1991 23:29:26   GLENN
 * Robert made, in his words, some "big ol hairy ass changes" which
 * included using the Clipper internals _gtPreExt() and _gtPostExt()
 * to avoid conflict with dispBegin() and dispEnd() display buffers.
 *
 * Forest's documentation was left unscathed.
 *
 *
 *    Rev 1.2   15 Aug 1991 23:08:40   GLENN
 * Forest Belt proofread/edited/cleaned up doc
 *
 *    Rev 1.1   23 May 1991 02:22:16   GLENN
 * Change to internal function _ftscrptr().
 *
 *    Rev 1.0   01 Apr 1991 01:03:02   GLENN
 * Nanforum Toolkit
 *
 *
 */


#include <EXTEND.API>
#include <GT.API>
#include <CPMI.H>

#define CRTADDR  ( *( ( unsigned int * ) 0x00400063 ) )
#define MONO     0xB000
#define COLOR    0xB800
#define VIDSEG   ( ( CRTADDR == 0x03B4 ) ? MONO : COLOR )

#define MK_FP(seg,ofs)  ((void far *) (((unsigned long)(seg) << 16) | \
                        (unsigned)(ofs)));

/*  $DOC$
 *  $FUNCNAME$
 *     FT_VIDSTR()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Display string on screen in specified attribute
 *  $SYNTAX$
 *     FT_VIDSTR( <nRow>, <nCol>, <cString> [, <nColor> ] ) -> NIL
 *  $ARGUMENTS$
 *     <nRow> and <nCol> are the screen coordinates.
 *
 *     <cString> is the string to be printed on the screen.
 *
 *     <nColor> is an integer representing the color attribute.
 *     The formula is:
 *
 *       nFore + ( nBack * 16 )
 *
 *     FT_VIDSTR() will display the string in the current color if
 *     <nColor> is not passed.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This is a high speed function to display a string of any ASCII
 *     characters on screen in a specified color attribute.  This function
 *     is useful for constructing screens with a lot of text or repetitive
 *     screen prints where speed is important.
 *  $EXAMPLES$
 *     FT_VIDSTR( 10, 20, "Enter Name :", 165 )
 *
 *     This example will print the specified text at coordinates 10, 20
 *     in bright white on top of Magenta.
 *
 *  $END$
 */


CLIPPER FT_VIDSTR(void)
{
   char far *scrPtr;
   int i, j;

   int vidSeg  = VIDSEG;
   int numCols = _gtMaxCol() + 1;

   int iTRow   = _parni(1);
   int iLCol   = _parni(2);
   char *cStr  = _parc(3);
   int iLen    = _parclen(3);
   int iAttr   = _parni(4);
   int iIsAttr = ISNUM(4);

   int isProtected = cpmiIsProtected();

   if ( isProtected )
   {
      scrPtr = MK_FP( vidSeg, 0 );
      vidSeg = cpmiProtectedPtr( scrPtr, 0x8000 );
   }

   _gtPreExt();

   for ( i = 0, j = iLCol; i < iLen; ++i, ++j ) {
      scrPtr = MK_FP( vidSeg, ( ( iTRow * numCols ) + j ) * 2 );
      *scrPtr++ = cStr[i];

      if ( iIsAttr )
         *scrPtr = (unsigned char) iAttr;
   }

   _gtPostExt();

   if ( isProtected ) cpmiFreeSelector( vidSeg );

   return;
}


/*  $DOC$
 *  $FUNCNAME$
 *     FT_WRTCHR()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Display character on screen
 *  $SYNTAX$
 *     FT_WRTCHR( <nRow>, <nCol>, <cChar>, <nColor> ) -> NIL
 *  $ARGUMENTS$
 *     <nRow> and <nCol> are the screen coordinates.
 *
 *     <cChar> is the single character to print on the screen.
 *
 *     <nColor> is an integer representing the color attribute.
 *     The formula is:
 *
 *        nFore + ( nBack * 16 )
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This is a high speed function to display a single ASCII character
 *     on screen in a specified color attribute.  This function is useful
 *     for constructing screens with a lot of text or repetitive screen prints
 *     where speed is important.  It is faster and requires less memory than
 *     FT_VIDSTR().  A working example is contained in ClrTable.Prg.
 *  $EXAMPLES$
 *      FOR nX = 1 to MaxRow()
 *         FOR nY = 1 to MaxCol()
 *            FT_PRNTCHR( nX, nY, "", (nX - 1)+(nY * 16) )
 *         NEXT
 *      NEXT
 *
 *      This example will write the ASCII character 249 to every location
 *      on screen in every possible color combination.  It will recognize
 *      the status of SetBlink().  It uses direct video writes for speed.
 *
 *  $END$
 */

CLIPPER FT_WRTCHR(void)
{
   char far *scrPtr;

   int vidSeg  = VIDSEG;
   int  iTRow  = _parni(1);
   int  iLCol  = _parni(2);
   char *cChar = _parc(3);
   int  iAttr  = _parni(4);

   int isProtected = cpmiIsProtected();

   if ( isProtected )
   {
      scrPtr = MK_FP( vidSeg, 0 );
      vidSeg = cpmiProtectedPtr( scrPtr, 0x8000 );
   }

   _gtPreExt();

   scrPtr = MK_FP( vidSeg, ( ( iTRow * ( _gtMaxCol()+1 ) ) + iLCol ) * 2 );
   *scrPtr++ = cChar[0];

   if( ISNUM( 4 ) ) *scrPtr = (unsigned char) iAttr;

   _gtPostExt();

   if ( isProtected ) cpmiFreeSelector( vidSeg );

   return;
}


/*  $DOC$
 *  $FUNCNAME$
 *     FT_CLS()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Clear screen
 *  $SYNTAX$
 *     FT_CLS( <nTRow>, <nLCol>, <nBRow>, <nRCol>, <nColor> ) -> NIL
 *  $ARGUMENTS$
 *     <nTRow>, <nLCol>, <nBRow> and  <nRCol> are the screen coordinates
 *     to clear.
 *
 *     <nColor> is an integer representing the color attribute.
 *     The formula is:
 *
 *       nFore + ( nBack * 16 )
 *
 *     The default is black.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This is a high speed function to clear the screen at the given
 *     coordinates with the given color attribute.  This does not change
 *     Clipper's color settings.  It uses direct video writes for speed.
 *
 *  $EXAMPLES$
 *     FT_CLS( 0, 0, MaxRow(), MaxCol(), 165 )
 *
 *     This example will clear the entire screen with the colors
 *     bright white on magenta.
 *  $END$
 */

CLIPPER FT_CLS(void)
{
   char far *scptr;
   int i, j;

   int vidSeg  = VIDSEG;
   int numCols = _gtMaxCol() + 1;

   int iTRow = ISNUM(1) ? _parni(1) : 0;
   int iLCol = ISNUM(2) ? _parni(2) : 0;
   int iBRow = ISNUM(3) ? _parni(3) : _gtMaxRow();
   int iRCol = ISNUM(4) ? _parni(4) : _gtMaxCol();
   int iAttr = _parni(5);

   int fIsAttr = ISNUM(5);

   int isProtected = cpmiIsProtected();

   if ( isProtected )
   {
      scptr = MK_FP( vidSeg, 0 );
      vidSeg = cpmiProtectedPtr( scptr, 0x8000 );
   }

   _gtPreExt();

   for (i = iTRow; i <= iBRow; ++i) {
      scptr = MK_FP( vidSeg, ( ( i * numCols ) + iLCol ) * 2 );

      for (j = iLCol; j <= iRCol; ++j) {
         *scptr++ = 32;

         if( fIsAttr )
            *scptr++ = (unsigned char) iAttr;
         else
            *scptr++;
       }
   }

   _gtPostExt();

   if ( isProtected ) cpmiFreeSelector( vidSeg );

   return;

}



/*  $DOC$
 *  $FUNCNAME$
 *     FT_SETATTR()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Change color attributes of screen region
 *  $SYNTAX$
 *     FT_SETATTR( <nTRow>, <nLCol>, <nBRow>, <nRCol>, <nColor> ) -> NIL
 *  $ARGUMENTS$
 *     <nTRow>, <nLCol>, <nBRow>, and <nRCol> are the coordinates of the
 *     screen region.
 *
 *     <nColor> is an integer representing the new color attribute.
 *     The formula is:
 *
 *         nFore + ( nBack * 16 )
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This is a high speed function to change the colors of a specified
 *     region of the screen without disturbing any text.  Uses direct
 *     video writes.
 *  $EXAMPLES$
 *     FT_SETATTR( 0, 0, MaxRow(), MaxCol(), 95 )
 *
 *     This example will change the entire screen's colors to bright white on
 *     magenta without changing or overwriting any text on the screen.
 *  $END$
 */

CLIPPER FT_SETATTR(void)
{
   char far *scptr;
   int    i, j;

   int iTRow = ISNUM(1) ? _parni(1) : 0;
   int iLCol = ISNUM(2) ? _parni(2) : 0;
   int iBRow = ISNUM(3) ? _parni(3) : _gtMaxRow();
   int iRCol = ISNUM(4) ? _parni(4) : _gtMaxCol();

   int iAttr = _parni(5);

   int vidSeg  = VIDSEG;
   int numCols = _gtMaxCol() + 1;

   int isProtected = cpmiIsProtected();

   if ( isProtected )
   {
      scptr = MK_FP( vidSeg, 0 );
      vidSeg = cpmiProtectedPtr( scptr, 0x8000 );
   }

   _gtPreExt();

   for (i = iTRow; i <= iBRow; ++i) {
      scptr = MK_FP( vidSeg, ( ( i * numCols ) + iLCol ) * 2 );
      scptr++;

      for (j = iLCol; j <= iRCol; ++j) {
         *scptr = (unsigned char) iAttr;
         scptr += 2;
      }
   }

   _gtPostExt();

   if ( isProtected ) cpmiFreeSelector( vidSeg );

   return;
}



/*  $DOC$
 *  $FUNCNAME$
 *     FT_REVATTR()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Reverse colors of specified screen coordinates
 *  $SYNTAX$
 *     FT_REVATTR( <nTRow>, <nLCol>, <nBRow>, <nRCol> ) -> NIL
 *  $ARGUMENTS$
 *     <nTRow>, <nLCol>, <nBRow>, and <nRCol> are the coordinates of the
 *     screen region.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This is a high speed function to reverse the color of a specified
 *     screen region without disturbing any text on the screen.  This
 *     function will correctly reverse the color attributes in a region
 *     containing multiple color combinations.
 *  $EXAMPLES$
 *     FT_REVATTR( 0, 0, MaxRow(), MaxCol() )
 *
 *     This example will change the entire screen's colors to their reverse
 *     attributes without changing  or overwriting any text.
 *  $END$
 */


CLIPPER FT_REVATTR(void)
{
   char far *scrPtr;
   int i, j;

   int iTRow = ISNUM(1) ? _parni(1) : 0;
   int iLCol = ISNUM(2) ? _parni(2) : 0;
   int iBRow = ISNUM(3) ? _parni(3) : _gtMaxRow();
   int iRCol = ISNUM(4) ? _parni(4) : _gtMaxCol();

   int vidSeg  = VIDSEG;
   int numCols = _gtMaxCol() + 1;

   int isProtected = cpmiIsProtected();

   if ( isProtected )
   {
      scrPtr = MK_FP( vidSeg, 0 );
      vidSeg = cpmiProtectedPtr( scrPtr, 0x8000 );
   }

   _gtPreExt();

   for (i = iTRow; i <= iBRow; ++i) {
      scrPtr = MK_FP( vidSeg, ( ( i * numCols ) + iLCol ) * 2 );
      scrPtr++;

      for (j = iLCol; j <= iRCol; ++j) {
        *scrPtr = (*scrPtr>>4)|((*scrPtr&0x07)<<4)|
                 (*scrPtr&0x08)|(*scrPtr&128);
        scrPtr += 2;
      }
   }

   _gtPostExt();

   if ( isProtected ) cpmiFreeSelector( vidSeg );

   return;
}

/*  $DOC$
 *  $FUNCNAME$
 *     FT_REVCHR()
 *  $CATEGORY$
 *     Video
 *  $ONELINER$
 *     Reverse the color of a single character on the screen
 *  $SYNTAX$
 *     FT_REVCHR( <nTRow>, <nLCol> ) -> NIL
 *  $ARGUMENTS$
 *     <nTRow>, <nLCol> are the screen coordinates of the character.
 *  $RETURNS$
 *     NIL
 *  $DESCRIPTION$
 *     This is a high speed function to reverse the color of a single
 *     character on the screen without changing the character itself.
 *     This function is the same as FT_REVATTR() except that it changes
 *     only one character on screen and hence is faster and uses less memory.
 *  $EXAMPLES$
 *     FT_REVCHR( 10, 20 )
 *
 *     This example will change the text and background at 10, 20 to it's
 *     reverse color attributes without changing or overwriting the
 *     character itself.
 *  $END$
 */

CLIPPER FT_REVCHR(void)
{
   char far *scrPtr;

   int iTRow = _parni(1);
   int iLCol = _parni(2);

   int vidSeg = VIDSEG;

   int isProtected = cpmiIsProtected();

   if ( isProtected )
   {
      scrPtr = MK_FP( vidSeg, 0 );
      vidSeg = cpmiProtectedPtr( scrPtr, 0x8000 );
   }

   _gtPreExt();
   scrPtr = MK_FP( vidSeg, ( ( iTRow * _gtMaxCol()+1 ) + iLCol ) * 2 );
   scrPtr++;
   *scrPtr = (*scrPtr>>4)|((*scrPtr&0x07)<<4)|(*scrPtr&0x08)|(*scrPtr&128);
   _gtPostExt();

   if ( isProtected ) cpmiFreeSelector( vidSeg );

   return;
}