*
*  FILE......: DEMO.PRG
*  AUTHOR....: Berend M. Tober
*  DATE......: 1994/08/13
*

#include "common.ch"
#include "inkey.ch"
#include "netutils.ch"

************************************ DEMO() ************************************
*  Usage:
*      DEMO()
*  Parameters:
*     -None-
*  Description:
*     Exercises various routines in my Networks library.
*
PROCEDURE DEMO( lMode )
   FIELD Id, LName, FName, YearBeg, Seq IN CHIEF
   DEFAULT lMode TO "SHARED"
   lMode := IF( UPPER( lMode ) == "SHARED", TRUE, FALSE )
   CLEAR SCREEN
   ? "Demonstration of function NetPersist and"
   ? "preprocessor commands NetAppend, NetFLock, NetRLock"
   IF !FILE( "CHIEF.DBF")         // Create a sample database
      ? "Creating database"
      CreateDbf()
   ENDIF

   // Open database in  SHARED mode
   ? "Opening CHIEF.DBF"
   USE ( "CHIEF") NEW SHARED

   IF LASTREC() == 0             // Fill database with sample data
      AddData()
      Prompt()
   ENDIF

   LIST Id, LName, FName, YearBeg, Seq
   ? LASTREC(), " records"
   Prompt()

   // Demonstrate file and record locking in SHARED mode
   GO TOP
   ALTD()
   ?
   ? "Pre-processor locking commands:"
   ? "File lock ", IF (NetFlock(), "OBTAINED", "FAILED")
   ? "Record lock ", IF (NetRlock(), "OBTAINED", "FAILED")
   Prompt()

   RETURN
* end of DEMO()

STATIC FUNCTION CreateDbf()
   * Create demo database
   LOCAL aDbf := {}

   * Create structure
   AADD( aDbf, {"Id"       , "C",  9, 0})
   AADD( aDbf, {"Lname"    , "C", 20, 0})
   AADD( aDbf, {"Fname"    , "C", 10, 0})
   AADD( aDbf, {"Yearbeg"  , "C",  4, 0})
   AADD( aDbf, {"SEQ"      , "N",  3, 0})

   DBCREATE( "CHIEF", aDbf )

   RETURN NIL

STATIC FUNCTION AddData()
   * Add some data
   LOCAL aFldVal := {}
   LOCAL bGather  := {|a| AEVAL( a, {|x,i| FIELDPUT(i,x)})}

   AADD( aFldVal, {"001", "Clinton", "Bill   ", "1993", 42 })
   AADD( aFldVal, {"002", "Bush   ", "George ", "1989", 41 })
   AADD( aFldVal, {"003", "Reagan ", "Ronald ", "1981", 40 })
   AADD( aFldVal, {"004", "Carter ", "Jimmy  ", "1977", 39 })
   AADD( aFldVal, {"005", "Ford   ", "Gerald ", "1974", 38 })
   AADD( aFldVal, {"006", "Nixon  ", "Richard", "1969", 37 })
   AADD( aFldVal, {"007", "Johnson", "Lyndon ", "1963", 36 })
   AADD( aFldVal, {"008", "Kennedy", "John   ", "1961", 35 })

   ? "Using pre-processor command NetAppend to expand .dbf"
   ALTD()
   AEVAL( aFldVal, {|x,i| NetAppend(), EVAL( bGather, x )})
   RETURN NIL

STATIC FUNCTION Prompt()
   ?
   ? "Press any key to continue ..."
   INKEY(0)
   RETURN NIL
*  eof: DEMO.PRG

