*  BOF: NETFLOCK.CH

*  FILE.......: NETFLOCK.CH
*  AUTHOR.....: Berend Tober
*  CIS id #...: 70541,1030
*  DATE.......: Wed  94/08/10 12:48:21

/* Modification History
*/


 * File......: NETFLOCK.CH
 * Author....: Berend M. Tober
 * CIS ID....: 700541,1030
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Berend M. Tober
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     NETFLOCK()
 *  $CATEGORY$
 *     Networks
 *  $ONELINER$
 *     Attempt to FLOCK() with optional retry.
 *  $SYNTAX$
 *     NetFLock( [<nWaitSeconds>] ) --> lSuccess
 *  $ARGUMENTS$
 *     [<nWaitSeconds>] is the time in seconds to retry operation,
 *     defaults to NET_SECS (defined in netutils.ch).
 *  $RETURNS$
 *     TRUE if lock is successful, FALSE otherwise.
 *  $DESCRIPTION$
 *     Persistently attempts to obtain file lock for specified number
 *     of seconds.  Returns TRUE if lock was successful and returns
 *     FALSE if lock failed.
 *  $EXAMPLES$
 *     lSuccess := NetFLock()
 *  $SEEALSO$
 *     NETAPPEN NETDEL NETMODE NETPACK NETRLOCK NETUSE NETUTILS
 *  $INCLUDE$
 *  $END$
 */

********************************** NetFLock() **********************************
#xtranslate NetFLock([<nSec>])   => NetPersist( {|| FLOCK() }, <nSec> )

* EOF: NETFLOCK.CH

