*  BOF: NETRLOCK.CH

*  FILE.......: NETRLOCK.CH
*  AUTHOR.....: Berend Tober
*  CIS id #...: 70541,1030
*  DATE.......: Wed  94/08/10 12:48:21

/* Modification History
*/


 * File......: NETRLOCK.CH
 * Author....: Berend M. Tober
 * CIS ID....: 700541,1030
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Berend M. Tober
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     NetRLock()
 *  $CATEGORY$
 *     Networks
 *  $ONELINER$
 *     Attempt to RLOCK() with optional retry.
 *  $SYNTAX$
 *     NetRLock( [<nWaitSeconds>] ) --> lSuccess
 *  $ARGUMENTS$
 *     [<nWaitSeconds>] is the time in seconds to retry operation,
 *     defaults to NET_SECS (defined in netutils.ch).
 *  $RETURNS$
 *     TRUE if lock is successful, FALSE otherwise.
 *  $DESCRIPTION$
 *     Persistently attempts to obtain record lock for specified number
 *     of seconds.  Returns TRUE if lock was successful and returns
 *     FALSE if lock failed.
 *  $EXAMPLES$
 *     lSuccess := NetRLock()
 *  $SEEALSO$
 *     NETAPPEN NETDEL NETFLOCK NETMODE NETPACK NETUSE NETUTILS
 *  $INCLUDE$
 *  $END$
 */

********************************** NetRLock() **********************************
#xtranslate NetRLock([<nSec>])   => NetPersist( {|| RLOCK() }, <nSec> )

* EOF: NETRLOCK.CH


