*  BOF: n_persis.prg

*  FILE.......: n_persis.prg
*  AUTHOR.....: Berend Tober
*  CIS id #...: 70541,1030
*  DATE.......: Wed  94/08/10 12:48:21

/* Modification History
*/


 * File......: n_persis.prg
 * Author....: Berend M. Tober
 * CIS ID....: 700541,1030
 * Date......: $Date$
 * Revision..: $Revision$
 * Log file..: $Logfile$
 * 
 * This is an original work by Berend M. Tober
 * and is placed in the public domain.
 *
 * Modification history:
 * ---------------------
 *
 * $Log$
 *
 */


/*  $DOC$
 *  $FUNCNAME$
 *     NetPersist()
 *  $CATEGORY$
 *     Networks
 *  $ONELINER$
 *     Persistent attempt execute a code block.
 *  $SYNTAX$
 *     NetPersist( <bBlock>, [<nSeconds>] ) --> lSuccess
 *  $ARGUMENTS$
 *     <bBlock> is a code block which NetPersist will attempt
 *     repeatedly to execute.  The attempts will be made at
 *     intervals of NET_WAIT seconds while the block returns FALSE.
 *     The attempts terminate when either 1) the block returns
 *     TRUE, or 2) the lessor of a) nSeconds or b) NET_SECS has
 *     been exceeded.
 *
 *     [<nSeconds>] is the time in seconds to retry operation,
 *     defaults to NET_SECS.  If zero is specified, then the
 *     operation is attempted without time limit.
 *  $RETURNS$
 *     TRUE if <bBlock> was executed, FALSE otherwise.
 *  $DESCRIPTION$
 *     This function is useful in networked applications where
 *     certain operations may fail due to network conflicts on the
 *     initial attempt, such as obtaining record or file locks, but
 *     may be successful on subsequent attempts.
 *
 *     NetPersist will make repeated attempts to execute any code
 *     block until either the codeblock returns TRUE, or the upper
 *     limit of persistency time is exceeded (in which case
 *     NetPersist returns FALSE).
 *
 *     The codeblock you supply must return FALSE if the attempt to
 *     execute fails and must return TRUE when the operation is
 *     successful.
 *
 *     The file netutils.ch defines pre-processor commands that
 *     implement NetPersist for file and record locking and
 *     for appending records
 *  $EXAMPLES$
 *     lSuccess := NetPersist({|| FLOCK() })
 *  $SEEALSO$
 *     NETAPPEN NETDEL NETMODE NETPACK NETRLOCK NETUSE NETUTILS
 *  $INCLUDE$
 *     netutils.ch
 *  $END$
 */

#include "Common.ch"
#include "netutils.ch"

#define NET_WAIT     0.5   // Seconds to wait between between retries
#define NET_SECS     2     // Number of seconds to continue retry

********************************** NetPersist() **********************************
FUNCTION NetPersist( bBlock, nSeconds )
   
   LOCAL lForever    // Retry forever?

   DEFAULT nSeconds TO NET_SECS
   lForever := ( nSeconds == 0 )

   // Keep trying as long as specified or default
   DO WHILE ( lForever .OR. ( nSeconds > 0 ) )
      
      IF EVAL( bBlock )
         RETURN ( TRUE )    // NOTE
      ENDIF

      INKEY( NET_WAIT )    // Wait NET_WAIT seconds
      nSeconds -= NET_WAIT
   ENDDO
   RETURN ( FALSE )          // Not locked
*  end of NetPersist()

* EOF: n_persis.prg

