

DEFINT A-Z
'15-Nov-93-chh
'PWB-run program to remove #$(OBJS) from inline file output since
'this causes an error on subsequent .MAK read by PWB. The #$(OBJS)
'is always placed there by the "Library" template and each "save list"
'of a project edit does it. Customizing the template does not work since
'the #$(OBJS) must be there when editing the project list.

'This program creates a list of all *.MAK files and reads each file in
'the list scanning for #$(OBJS) and replaces those eight characters with
'ASCII 32 (space). File is modified there only, and not re-written.

DIM MakeName$(1 TO 128)
DIM MatchLoc&(1 TO 16)

version$ = "CLNPWB 1.00 15-Nov-93"
  match$ = "#$(OBJS)"
replace$ = "        "

PRINT

location$ = COMMAND$
IF location$ = "" THEN location$ = ".\"
IF RIGHT$(location$, 1) <> "\" THEN location$ = location$ + "\"
path$ = location$
location$ = location$ + "*.MAK"
index = 1

MakeName$(index) = DIR$(location$)
DO WHILE LEN(MakeName$(index))
   index = index + 1
   MakeName$(index) = DIR$
LOOP

PRINT version$
PRINT "Using "; location$
PRINT "Cleaning"; index - 1; "PWB project make files, Library template, of "; match$
PRINT

FOR i = 1 TO index - 1

   'find matches within file

   matches = 0
   PRINT MakeName$(i),
   OPEN path$ + MakeName$(i) FOR INPUT AS #1 LEN = 8192
   SEEK #1, 1
   curPos& = SEEK(1)
   LINE INPUT #1, ln$
   DO WHILE NOT EOF(1)
      IF ln$ = match$ THEN
         matches = matches + 1
         PRINT RIGHT$("     " + HEX$(curPos&), 6);
         MatchLoc&(matches) = curPos&
      END IF
      curPos& = SEEK(1)
      LINE INPUT #1, ln$
   LOOP
   CLOSE #1
   
   'process, if required

   IF matches = 0 THEN
      PRINT "  none"
   ELSE
      OPEN path$ + MakeName$(i) FOR APPEND AS #1 LEN = 8192
      SEEK #1, MatchLoc&(1)
      PRINT #1, replace$
      FOR j = 2 TO matches
         SEEK #1, MatchLoc&(j)
         PRINT #1, replace$
      NEXT
      PRINT " - Updated"
      CLOSE #1
   END IF
NEXT

PRINT "ok"
CLOSE



