

DEFINT A-Z

'20-Jun-94-chh
'PWB-run program to set project DEBUG mode based on command-line switch

'This program creates a list of all *.MAK/STS files and reads each file in
'the list scanning for DEBUG and replaces the value to the one specified.
'File is modified there only, and not re-written.
'Done with this since doing so in PWB causes PWB to duplicate project
'entries within the .MAK causing redundant assembling

DIM location$(1 TO 2)
DIM MakeName$(1 TO 2, 1 TO 128)
DIM match$(1 TO 2)
DIM replace$(1 TO 2)
DIM index(1 TO 2)
Q$ = CHR$(34)

CLS

cl$ = LEFT$(COMMAND$, 2)
SELECT CASE cl$
CASE "/1"
   oldSwitch$ = "0"
   newswitch$ = "1"
CASE "/0"
   oldSwitch$ = "1"
   newswitch$ = "0"
CASE ELSE
   PRINT "DBGPWB requires /1 or /0 switch  (C>dbgpwb /1 [path])"
   END
END SELECT
version$ = "DBGPWB 1.00 20-Jun-94"
  match$(1) = "DEBUG = " + oldSwitch$
replace$(1) = "DEBUG = " + newswitch$
  match$(2) = "    build: macro DEBUG " + Q$ + oldSwitch$ + Q$
replace$(2) = "    build: macro DEBUG " + Q$ + newswitch$ + Q$

cl$ = COMMAND$
locate$ = LTRIM$(MID$(cl$, INSTR(cl$, "/") + 3))      'after /0_
IF locate$ = "" THEN locate$ = ".\"
IF RIGHT$(locate$, 1) <> "\" THEN locate$ = locate$ + "\"
path$ = locate$
location$(1) = path$ + "*.MAK"
location$(2) = path$ + "*.STS"

FOR file = 1 TO 2
   index(file) = 1
   MakeName$(file, index(file)) = DIR$(location$(file))
   DO WHILE LEN(MakeName$(file, index(file)))
      index(file) = index(file) + 1
      MakeName$(file, index(file)) = DIR$
      ''PRINT MakeName$(file, index(file))
   LOOP
NEXT

PRINT version$
PRINT "Checking"; index(1) - 1; ".MAK &"; index(2) - 1; ".STS PWB project files"
PRINT "All "; CHR$(34); path$ + "*.MAK/STS"; CHR$(34); " being set to ";
IF newswitch$ = "0" THEN
   COLOR 10, 0
   PRINT "RELEASE";
ELSE
   COLOR 12, 0
   PRINT "DEBUG";
END IF
COLOR 7, 0
PRINT " mode"
PRINT

file = 1
FOR i = 1 TO index(file) - 1
   FOR file = 1 TO 2
      matched = 0
      'find matches within file
      f$ = MakeName$(file, i)
      IF LEN(f$) THEN
         PRINT f$,
         OPEN path$ + MakeName$(file, i) FOR INPUT AS #1 LEN = 8192
         SEEK #1, 1
         curPos& = SEEK(1)
         LINE INPUT #1, ln$
         DO WHILE NOT EOF(1)
            ''IF file = 2 AND INSTR(ln$, "macro DEBUG") THEN PRINT ln$, match$(file), MakeName$(file, i)
            IF ln$ = match$(file) THEN
               matched = 1
               EXIT DO     'only single occurance
            END IF
            curPos& = SEEK(1)
            LINE INPUT #1, ln$
         LOOP
         CLOSE #1
      ELSE
         PRINT "",
      END IF

      'process, if required
      
      IF matched THEN
         OPEN path$ + MakeName$(file, i) FOR APPEND AS #1 LEN = 8192
         SEEK #1, curPos&
         PRINT #1, replace$(file)
         PRINT "UPDATED",
         CLOSE #1
      ELSEIF LEN(f$) THEN
         PRINT "  n/c  ",
      END IF
   NEXT
   PRINT
NEXT

PRINT "ok"
CLOSE



