/* Modified by Shamim Islam to demonstrate switch45.ch, switch45.obj        */
/* NOTE: Switch assumes non C_LIKE syntax unless this macro is defined  */
/* Therefore there is no need for a break between individual cases      */
/* Please see switch v4.5 documentation (current revision level) for    */
/* more information                                                     */
/*                                                                      */
/* Original routine: copyright (c) CA Intl (sample directory)           */
/*                                                                      */
#include "switch45.ch"
/*                                                                      */
/* Switch is only compatible with Clipper v5.0 and above                */
/* Non C_LIKE demo                                                      */

// Tbdemo() omitted for brevity
// Mybrowse omitted for brevity
// Skipper omitted for brevity

/***
*
*   ApplyKey()
*
*   Apply one keystroke to the oBrowse.
*
*   NOTE: uses the cargo #defines shown at the top of Tbdemo.prg
*
*/
STATIC PROCEDURE ApplyKey( oBrowse, nKey )

    switch nKey
        case K_DOWN      : oBrowse:down()
        case K_PGDN      : oBrowse:pageDown()
        case K_CTRL_PGDN : oBrowse:goBottom()
                           APP_MODE_OFF( oBrowse )
        case K_UP        : oBrowse:up()
                           if APP_MODE_ACTIVE( oBrowse )
                               APP_MODE_OFF( oBrowse )
                               oBrowse:refreshAll()
                           endif
        case K_PGUP      : oBrowse:pageUp()
                           if APP_MODE_ACTIVE( oBrowse )
                               APP_MODE_OFF( oBrowse )
                               oBrowse:refreshAll()
                           endif
        case K_CTRL_PGUP : oBrowse:goTop()
                           APP_MODE_OFF( oBrowse )

        case K_RIGHT     : oBrowse:right()
        case K_LEFT      : oBrowse:left()
        case K_HOME      : oBrowse:home()
        case K_END       : oBrowse:end()
        case K_CTRL_LEFT : oBrowse:panLeft()
        case K_CTRL_RIGHT: oBrowse:panRight()
        case K_CTRL_HOME : oBrowse:panHome()
        case K_CTRL_END  : oBrowse:panEnd()
        case K_RETURN    : DoGet( oBrowse )
        default          : KEYBOARD chr( nKey )
                           DoGet( oBrowse )
    endswitch

RETURN

// Remainder omitted for brevity
