/* Modified by Shamim Islam to demonstrate switch45.ch, switch45.obj        */
/* NOTE: Switch assumes non C_LIKE syntax unless this macro is defined  */
/* Therefore there is no need for a break between individual cases      */
/* Please see switch v4.5 documentation (current revision level) for    */
/* more information                                                     */
/*                                                                      */
/* Original routine: copyright (c) CA Intl (sample directory)           */
/*                                                                      */
#include "switch45.ch"
/*                                                                      */
/* Switch is only compatible with Clipper v5.0 and above                */
/* Non C_LIKE demo                                                      */

#include "inkey.ch"


/***
*
*  ValEdit( <nRow>, <nCol>, <xValue>, <[cPicture]>, <[cColor]> ) --> xNewValue
*
*  Uses a get object to edit value <xValue> at the screen location given
*  by <nRow> and <nCol>. Uses picture <cPicture> and color <cColor> if
*  passed.
*
*  Parameters:
*     nRow     - Row at which to edit <xValue>
*     nCol     - Column at which to edit <xValue>
*     xValue   - The value to be edited
*     cPicture - Optional picture clause for edit
*     cColor   - Optional color specification for edit
*
*  Returns:
*     The new (edited) value
*
*	Example usage:
*
*		// edits contents of myVar
*		myVar := ValEdit( 10, 10, myVar )
*
*		// edits flashing Y/N (default N), assigns to myVar
*		myVar := ValEdit( 10, 10, .F., "Y", "*W/R" )
*
*     // edits contents of a[i]
*     a[i] := ValEdit( 10, 10, a[i] )
*
*/
FUNCTION ValEdit( nRow, nCol, xValue, cPicture, cColor )

   LOCAL ExitRequested     // User requested termination of exit
   LOCAL nKey              // Current keypress
   LOCAL cKey              // Character string representation of nKey
   LOCAL lInsert := SET( _SET_INSERT )    // Current insert mode
   LOCAL g       := GetNew( nRow, nCol,                                     ;
                            { |p| IF( p == NIL, xValue, xValue := p ) }, "",;
                            cPicture,                                       ;
                            IF( cColor<>NIL , cColor + "," + cColor, NIL)   )

   g:setFocus()

   IF ( g:typeOut )        // No editable positions
      ExitRequested := .T.
   ELSE
      ExitRequested := .F.
   END

	//
   // Keystroke processing loop
	//
   WHILE ( !ExitRequested )

      // Key processing construct
        switch nKey:=INKEY(0)
            case K_UP,K_DOWN,K_PGDN,K_PGUP,K_CTRL_HOME;
                 K_CTRL_W,K_ENTER:  ExitRequested := .t.
            case K_ESC:
                g:Undo()
                g:KillFocus()
                SWRETURN (g:VarGet()) // NOTE

            case K_CTRL_U:     g:Undo()
            case K_INS:        lInsert := !lInsert
            case K_HOME:       g:Home()
            case K_END:        g:End()
            case K_RIGHT:      g:Right()
            case K_LEFT:       g:Left()
            case K_CTRL_RIGHT: g:WordRight()
            case K_CTRL_LEFT:  g:WordLeft()
            case K_BS:         g:BackSpace()
            case K_DEL:        g:Delete()
            case K_CTRL_T:     g:DelWordRight()
            case K_CTRL_Y:     g:DelEnd()
            default:
                if (nKey >= 32 .and. nKey <= 127)
                    // data key
                    cKey := Chr(nKey)

                    if (g:Type == "N" .and. ;
                        (cKey == "." .or. cKey == ","))
                        // go to decimal point
                        g:ToDecPos()
                    else
                        // send it to the get
                        if ( Set(_SET_INSERT) )
                            g:Insert(cKey)
                        else
                            g:Overstrike(cKey)
                        end
                    end


#ifdef NOTDEF
                    if (g:TypeOut)
                        // exit get without confirm
                        ExitRequested := .t.
                    end
#endif

                end

        endswitch

	//
	//	end of keystroke processing loop
	//
	end

    if (g:Changed)
		g:Assign()
    end

	g:Reset()
	g:KillFocus()

// return final value
RETURN (g:VarGet())

