' Area: F-QUICKBASIC 
'  Msg#: 399                                          Date: 28 Apr 94  05:22:25
'  From: Mark Butler                                  Read: Yes    Replied: No 
'    To: Bill White                                   Mark:                     
'  Subj: Help with Ascii
'
'Once upon a time Bill White uttered these sage words to David Cassell:

' Bill, when printing to the console PRINT #1, CHR$(7) works exactly the
' same as PRINT CHR$(7). That is, you _hear the bell rather than see it on
' your screen. I think David would like to know how to *literally* print
' the character symbol to the screen without it taking action (beeping).
' One way to print unprintable chars is by POKEing them directly into the
' video segment. Below is an example that prints everything in the ASCII
' chart that has a literal symbol. Chars 0 and 255 don't have symbols so
' we won't bother with those and print chars 1 through 254....


    CLS

    DEF SEG = &H40                   ' \
    equip = PEEK(&H10)               ' -First well need to discern
    IF (equip AND 48) = 48 THEN      ' whether we're going to be
        DEF SEG = &HB000             ' poking to a mono card or
    ELSE                             ' a color card and set the
        DEF SEG = &HB800             ' segment accordingly
    END IF                           ' /

    x = 1                            ' -we'll start with char$(1)
                                     ' and end with char$(254)
    FOR offset = 0 TO 510 STEP 2     ' -Individual screen offset is
                                     ' arranged as location/attribute
                                     ' so we'll increment by 2s so as
                                     ' to poke X only to the screen
                                     ' location not the color attrib.
        POKE offset, x               ' -Poke char X at the offset.
        x = x + 1                    ' -Increment char by 1

    NEXT offset                      ' -do it again

    DEF SEG                          ' -restore BASIC segment

