' Area: F-QUICKBASIC 
'  Msg#: 427                                          Date: 13 Apr 94  15:37:06
'  From: Jeff Root                                    Read: Yes    Replied: No 
'    To: Eric Nadeau                                  Mark:                     
'  Subj: Keyboard Lights
'
'Eric Nadeau asked for help in making his keyboard lights
'flash on and off.  The following two little routines work
'on my 84-key keyboard.  I think that adding "POKE 151, n"
'wherever "POKE 23, n" appears will enable them to work on
'101-key keyboards.  Poke the same value into both locations.
'Please let me know whether it actually works.  If it doesn't,
'it will be necessary to send the command byte ED followed by
'a data byte (value 0-7) to I/O port 64 hex.
' 
'Warning: 101-keyboard lights will get out of synch with the
'lock status if you only do one poke and not both.
' 
'The keyboard needs to be reset before the POKEs take effect.
'Just POKEing is not enough.  Doing an INKEY$ causes it to be
'reset, and that's what I do here.  Try pressing the lock
'keys while CYLON is running, and see what happens.
' 
 ' BLINKEY.BAS   Jeff Root   4-12-94
 DEFINT A-Z
 DEF SEG = 64
 DO
   FOR c = 0 TO 1
     FOR b = 0 TO 1
       FOR a = 0 TO 1
         POKE 23, a * 16 + b * 32 + c * 64
         IF INKEY$ > "" THEN POKE 23, 0: END
         FOR delay = 1 TO 12000: NEXT
       NEXT
     NEXT
   NEXT
 LOOP
 
 ' CYLON.BAS   Jeff Root   4-12-94
 DEFINT A-Z
 DEF SEG = 64
 POKE 23, 32
 DO
   a = (a MOD 96) + 48
   FOR i = 1 TO 2
     POKE 23, PEEK(23) XOR a
     IF INKEY$ > "" THEN EXIT DO
     FOR delay = 1 TO 6500: NEXT
   NEXT
 LOOP
 POKE 23, 0
