' Area: F-QUICKBASIC 
'  Msg#: 414                                          Date: 14 Apr 94  14:26:05
'  From: Coridon Henshaw                              Read: Yes    Replied: No 
'    To: All                                          Mark:                     
'  Subj: Directory list routine 1/2
'
FUNCTION FileSearch (LookFor$, Attributes%, FileNames() AS FileSpecs)

DIM Regs AS RegTypeX
DIM DOSFindBuff AS DOSFindType  'DOS Findfirst buffer

Regs.AX = &H2F00              'Get the old DTA address
InterruptX &H21, Regs, Regs

OldDTASeg% = Regs.ES          'Save it to restore later
OldDTAOff% = Regs.BX

Regs.AX = &H1A00              'Set our filefind buffer as
Regs.DS = VARSEG(DOSFindBuff) 'the new DTA
Regs.DX = VARPTR(DOSFindBuff)
InterruptX &H21, Regs, Regs

FindFileBuff$ = LookFor$ + CHR$(0)
Regs.AX = &H4E00
Regs.CX = Attributes%
Regs.DS = SSEG(FindFileBuff$)
Regs.DX = SADD(FindFileBuff$)
InterruptX &H21, Regs, Regs

IF Regs.AX = 0 THEN 'No Error
    Pntr = 1
    GOSUB SaveData
    DO
        Pntr = Pntr + 1
        Regs.AX = &H4F00
        InterruptX &H21, Regs, Regs
        IF Regs.AX = &H12 THEN 'No more files
            ExitFlag = True
        ELSE
            GOSUB SaveData
        END IF
    LOOP UNTIL ExitFlag = True
END IF

Regs.AX = &H1A00              '| Restore the original DTA
Regs.DS = OldDTASeg%
Regs.DX = OldDTAOff%
InterruptX &H21, Regs, Regs

IF Pntr > 1 THEN REDIM PRESERVE FileNames(1 TO Pntr - 1) AS FileSpecs
FileSearch = Pntr - 1

EXIT FUNCTION
SaveData:

IF Pntr = UBOUND(FileNames) THEN
    REDIM PRESERVE FileNames(1 TO Pntr + 64) AS FileSpecs
END IF

FileNames(Pntr).FileName = SPACE$(12)
FileNames(Pntr).FileName = LEFT$(DOSFindBuff.FileName,_
 INSTR(DOSFindBuff.FileName, CHR$(0)) - 1)
FileNames(Pntr).Attributes = ASC(DOSFindBuff.DFileAttr)
FileNames(Pntr).FileSize = DOSFindBuff.FileSize

HMS& = CVTLong(DOSFindBuff.DosTime)                  ' Use long integer_
' for
IF HMS& < 0& THEN HMS& = 65536 + HMS&   ' positive numbers
Hours = (HMS& \ 2048&) AND 31           ' Hours is first 5 bits
Minutes = (HMS& \ 32&) AND 63&          ' Minutes is nxt 6 bits
Seconds = (HMS& AND 31&) * 2            ' Secnds is last 5 bits
h$ = LTRIM$(STR$(Hours)): IF LEN(h$) = 1 THEN h$ = "0" + h$
m$ = LTRIM$(STR$(Minutes)): IF LEN(m$) = 1 THEN m$ = "0" + m$
s$ = LTRIM$(STR$(Seconds)): IF LEN(s$) = 1 THEN s$ = "0" + s$
FileNames(Pntr).FileTime = h$ + ":" + m$ + ":" + s$

YMD& = CVTLong(DOSFindBuff.DOSDate)                   ' Long int here_
' too
IF YMD& < 0 THEN YMD& = 65536 + YMD&    ' Cnv +
Year = 1980& + YMD& \ 512&              ' Year is first 7 bits
Month = (YMD& AND 511&) \ 31&           ' Month is next 4 bits
Day = YMD& AND 31&                      ' Day is last 5 bits
Y$ = LTRIM$(STR$(Year))
m$ = LTRIM$(STR$(Month)): IF LEN(m$) = 1 THEN m$ = "0" + m$
d$ = LTRIM$(STR$(Day)): IF LEN(d$) = 1 THEN d$ = "0" + d$
FileNames(Pntr).FileDate = m$ + "-" + d$ + "-" + Y$

RETURN

END FUNCTION

'Here's the TYPE structure you'll need:

TYPE FileSpecs
 Attributes  AS INTEGER
 FileTime    AS STRING * 8
 FileDate    AS STRING * 10
 FileSize    AS LONG
 FileName    AS STRING * 12
END TYPE
