' Area: F-PowerBASIC 
'  Msg#: 26                                           Date: 07 Apr 94  20:03:32
'  From: Frank Cox                                    Read: Yes    Replied: No 
'    To: David Wrobel                                 Mark:                     
'  Subj: Re: The Rules
'
'=========================================================================
'                                 DIRU.BAS
'                            Unit in PowerBASIC
'                   for Retrieval of Directory Information
'
' CopyRight 1991 by Dave Navarro, Jr.             All Rights Reserved
'               Documentation "Prettified" by Ann Goodman
'=========================================================================
' Permission is granted to use these routines in your programs with the
' following restrictions:
'  - You may NOT distribute this source in part or whole as part of
'    any library for PowerBASIC or Turbo BASIC
'  - If you use these routines in any commercial program (commercial
'    meaning anything you get paid for, including shareware), you must
'    give the original author, Dave Navarro credit in either the program
'    or in the documentation.
'  - In no way shape or form may you remove the copyright notice from
'    this, or any part of the source.
' These routines were tested on a generic XT clone and a 486 machine and
' found to work without fail, however, should you encounter any problems,
' the author cannot be held responsible for any problems/damage you may
' encounter, you use these at your own risk.
'=========================================================================
' Author can be contacted on The Bard's Lair BBS (718) 381-3651
'=========================================================================
'
' About DIRU:BAS:
' --------------
'      This unit contains routines for obtaining directory information
' for files names found by the PowerBASIC function DIR$ (PowerBASIC
' version 2.1).
'
'     The DIR$ function uses functions 11H or 12H of DOS interrupt
' 21H (the "Find First" and "Find Next" file functions) to find
' a directory entry that satisfies the arguments to the DIR$ function,
' and returns the name of this file.  However, since the whole
' directory entry for the found file is placed in the DOS Data Transfer
' Area (the DTA) by the interrupt, the rest of the directory information
' for the file, (file size, date and time stamps, and file type), can be
' retrieved from there.
'      Though the DTA is normally found at offset 80H of the PSP,
' the DOS interrupts used by DIR$ can move it, so the current address
' of the DTA must be determined after each execution of DIR$ before
' attempting to access the directory information.
'
'      The routines in this unit retrieve the directory information
' and put it in usable format.
'    The routines are:
'
'  FUNCTION   GetAttrib%      Returns the attribute code of the file
'                             as an integer.
'
'  FUNCTION   GetFileSize&    Returns the file size as a long integer
'
'  FUNCTION   GetFileDate$    Retrieves the file date stamp from DTA
'                             and returns date as string MM-DD-YY
'
'  FUNCTION   GetFileTime$    Retrieves the file time stamp from DTA
'                             and returns time as string HH:MMa or HH:MMp
'
'  FUNCTION   DOS2Date$       Decrypts file date stamp and converts it
'                             to string of format MM-DD-YY
'
'  FUNCTION   DOS2Time$       Decrypts file time stamp and converts it
'                             to string of format HH:MMa or HH:MMp.
'
'  SUB        GetDTA          Gets current address of Data Transfer Area.
'
'========================================================================

'========================================================================
'|  Setup for Unit                                                      |
'========================================================================
$CPU 8086               'Compile with 8086 specific code
$ERROR ALL OFF          'No error checking needed
$COMPILE UNIT           'Compile to a UNIT (PBU)
$STACK 0                'Requires no Stack Space
$LIB ALL OFF            'Requires no PB libraries

'=======================================================================
'|                  FUNCTIONS AND SUB-ROUTINES                         |
'=======================================================================
'-----------------------------------------------------------------------
'| FUNCTION: FileAttrib%   | Get file attribute of filename returned   |
'|                         | by last DIR$ statement executed.          |
'-----------------------------------------------------------------------

' The file attribute is a single byte located at offset 21 of the DTA.
' This function retrieves it and returns it as an integer.

FUNCTION FileAttrib% PUBLIC
  CALL GetDTA(DtaSeg%, DtaOfs%)   'Get DTA address. (See SUB GetDTA
      '                  in this unit.)
  DEF SEG=DtaSeg%                 'Set segment to DTA address segment.
    FileAttrib%=PEEK(DtaOfs%+21)  'Use PEEK to retrieve attribute byte.
  DEF SEG                         'Return previous value of segment.
END FUNCTION

'-----------------------------------------------------------------------
'| FUNCTION: FileDate$     | Get file date of filename returned by     |
'|                         | last execution of DIR$ function.          |
'-----------------------------------------------------------------------

' The file date stamp is found at offset 25 of the DTA as an encrypted
' integer (two bytes).  This function retrieves the date stamp and uses
' DOS2Date$ to decrypt it and to convert it to a string of format MM-DD-YY.

FUNCTION FileDate$ PUBLIC
  CALL GetDTA(DtaSeg%, DtaOfs%)   'Get DTA address. (See SUB GetDTA
      '                  in this unit.)
  DEF SEG=DtaSeg%                 ' Set segment to DTA address segment.
    FileDate$=DOS2Date$(PEEKI(Dtaofs% + 24))
      ' use PB's PEEKI to retrieve two-byte
      ' date stamp.  Use DOS2Date$ to decrypt
      ' the date and convert it to a string.
  DEF SEG                         ' Return previous value of segment.
END FUNCTION

'-----------------------------------------------------------------------
'| FUNCTION: FileTime$     | Get time stamp from file name returned    |
'|                         | by last DIR$ statement executed.          |
'-----------------------------------------------------------------------

' The file time stamp is found at offset 22 of the DTA as an encrypted
' integer (two bytes).  This function retrieves the time stamp and uses
' DOS2Time$ to decrypt it and to convert it to a string of format HH:MMa.



FUNCTION FileTime$ PUBLIC
  CALL GetDTA(DtaSeg%, DtaOfs%)   'Get DTA address. (See SUB GetDTA
      '                  in this unit.)
  DEF SEG=DtaSeg%                 ' Set segment to DTA address segment.
    FileTime$=DOS2Time$(PEEKI(DtaOfs%+22))  'use PB's PEEKI to convert
      ' use PB's PEEKI to retrieve two-byte
      ' time stamp.  Use DOS2Time$ to decrypt
      ' the time and convert it to a string.
  DEF SEG                         ' Return segment to previous value.
END FUNCTION

'-----------------------------------------------------------------------
'| FUNCTION: FileSize$     | Get file size of file name returned       |
'|                         | by last DIR$ statement executed.          |
'-----------------------------------------------------------------------


' The file size is found at offset 26 of the DTA as a
' long integer.

FUNCTION FileSize& PUBLIC
  CALL GetDTA(DtaSeg%, DtaOfs%)   'Get DTA address. (See SUB GetDTA
      '                  in this unit.)
  DEF SEG=DtaSeg%                 ' Set segment to DTA address segment
     FileSize&=PEEKL(DtaOfs%+26)  ' Use PB's PEEKL to retrieve four-byte
      ' file size and convert to long integer.
  DEF SEG                         ' Return segment to previous value.
END FUNCTION


'-----------------------------------------------------------------------
'| FUNCTION: DOS2Date$     | Convert encrypted date stamp from DTA     |
'|                         | to time string of format MM-DD-YY         |
'-----------------------------------------------------------------------
'
' The file date stamp is encrypted by the following formula:
'      Stamp = 512 * (Year - 1980)  + 32 * Month + Day
' The following routine decrypts the date stamp and converts the
' date to a string of format MM-DD-YY.
'
'
FUNCTION DOS2Date$(Fd%) PUBLIC
  Year% = Fd% \ 512  + 1980
  Remainder% = Fd% MOD 512
  Year$ = RIGHT$(STR$(Year%),2)
  Month% = Remainder% \ 32
  Month$ = MID$(STR$(Month%),2)
  Day$ = MID$(STR$(Remainder% MOD 32),2)
  IF LEN(day$) = 1 THEN   day$ = "0" + day$
  IF LEN(MONTH$) = 1 THEN   MONTH$ = " " + MONTH$
  DOS2Date$ = Month$ + "-" + Day$ + "-" + Year$
END FUNCTION

'-----------------------------------------------------------------------
'| FUNCTION: DOS2Time$     | Convert encrypted time stamp from DTA     |
'|                         | to time string of format HH:MMp.          |
'-----------------------------------------------------------------------

'The file time stamp is accurate to the nearest even second.
'This function rounds it to minutes, makes a string of format HH:MM
'and appends "a" or "p" for AM or PM.

FUNCTION DOS2Time$(Ft%) PUBLIC
  Ft%=INT(Ft%/2)
  Hours%=(Ft% AND &B111110000000000)\1024
  IF Hours%>12 THEN
    DECR Hours%,12
    Pm% = -1
  END IF
  Hour$=MID$(STR$(Hours%),2)
  Minutes=(Ft%\16) AND &B111111
  Minutes$=MID$(STR$(Minutes),2)
  IF LEN(Minutes$)=1 THEN Minutes$="0"+Minutes$
  IF LEN(Hour$)=1 THEN Hour$=" "+Hour$
  IF Pm% THEN
    Minutes$=Minutes$+"p"
  ELSE
    Minutes$=Minutes$+"a"
  END IF
  DOS2Time$=Hour$+":"+Minutes$
END FUNCTION


'-----------------------------------------------------------------------
'| SUB : GetDTA         |  Get Disk Transfer Address (DTA) from DOS    |
'-----------------------------------------------------------------------
'
'  The DTA is usually located in the PSP.  However, any routine that
'  calls the FINDFIRST, FINDNEXT functions from DOS (such as the
'  PowerBASIC statement DIR$) can change the location of the DTA.
'  This sub-routine uses DOS interrupt 33, function 47, to get
'  the current location of the DTA.

SUB GetDTA(DtaSeg%, DtaOfs%) PUBLIC
  REG 1, &h2F00            ' Set function number to 47.
  CALL INTERRUPT &h21      ' Call interrupt 33 (Hex 21).
  DtaSeg%=REG(9)           ' Register 9 contains Segment of DTA address.
  DtaOfs%=REG(2)           ' Register 2 contains Offset of DTA address
END SUB
