' Area: F-QUICKBASIC 
'  Msg#: 299                                          Date: 10 Apr 94  19:52:21
'  From: Coridon Henshaw                              Read: Yes    Replied: No 
'    To: All                                          Mark:                     
'  Subj: Multiple fonts on screen at once
'
'Here's a little something I cooked up to display two fonts on the screen at
'once:
'
'Note: EGA or better required.
'
DECLARE SUB LoadFont (Font$, Num%)
DEFINT A-Z

'$INCLUDE: 'qbx.bi'  'QB users use QB.BI.  Remember to load with /L.

DIM Regs AS RegTypeX

CLS

Buffer1$ = SPACE$(4096)
Buffer2$ = SPACE$(4096)

OPEN "\text\fonts\medieval.fnt" FOR BINARY AS #1 'Standard format text fonts
GET #1, , Buffer1$
CLOSE

OPEN "\text\fonts\itt.fnt" FOR BINARY AS #1
GET #1, , Buffer2$
CLOSE

LoadFont Buffer1$, 0
LoadFont Buffer2$, 1

FontCode = 4
'Binary format of the font code:
'
'  /Attribute 0-7 font highbit (VGA Only)
'  |/Attribute 8-15 font highbit (VGA Only)
'  ||/Attribute 0-7 font (EGA/VGA)
'  ||| /Attribute 8-15 font (EGA/VGA)
'  ||| |
'00000000
'76543210
'
'Font block number  Binary value (First bit in highbit)
'
' EGA/VGA:
' 0                 000
' 1                 001
' 2                 010
' VGA:
' 3                 011
' 4                 100
' 5                 101
' 6                 110
' 7                 111

OUT &H3C4, 3   'Squencer address port: Select Char Map Select register.
OUT &H3C5, FontCode

'Colors 0-7: Font 0, unless FontCode is changed
'Colors 8-15: Font 1, unless FontCode is changed

FOR X = 0 TO 15
 COLOR X
 PRINT "TESTING TESTING 1 2 3"
NEXT

SLEEP

OUT &H3C4, 3   'Squencer address port: Select Char Map Select register.
OUT &H3C5, 0   'Return to normal one font mode

WIDTH 40:WIDTH 80 'Restore to default font

SUB LoadFont (Font$, BlockCode)
'Loads a standard font using the BIOS
'
'Font$ contains the entire font
'BlockCode is a number between 0-3 for EGA and 0-7 for VGA.  This number
'designates the bank that the font is loaded into.  You can only display
'two fonts at once, but upto 8 can be loaded at a time.

DIM Regs AS RegTypeX
Regs.AX = &H1100
Regs.BX = &H1000 + BlockCode
Regs.CX = &H100
Regs.DX = 0
Regs.ES = SSEG(Font$)
Regs.BP = SADD(Font$)
InterruptX &H10, Regs, Regs
END SUB
