' ***************************************************************************
'   AHNUTS.BAS
'   VERSION 2.0a, 7/29/1993
'   Released to the PUBLIC DOMAIN by the author: Lewis E. Balentine
' ***************************************************************************
' 29 July 1994
' The previous version of Power Basic would allow the use of a semicolon
' or an apostophe to designate remarks in inline assembly code. The
' current version does nut. That is te only change for this version
' -----------------------------------------------------------------------------
' 14 August 1993
' Version 1.0 was written in assembly language for MS-PDS 7.0
' This is a port to PB3 and function much differently due to the my lack
' of determination when I rewrote it. I also had a different need at this
' time. Whatever .... 
'
' --------------- DOS directory functions for PB3 -----------------
'   Among my list of complaints is the inability to read subdirectory names,
'   files sizes and dates. This file is a direct result of that flustration. 
'
'   I ordered a third party library so I would have those functions. Its
'   directory functions were very fancy ... but not what I needed. All I 
'   really wanted is a simple implimentation of DOS findfirst and findnext 
'   functions.
'
'   All else has failed... ... ... Ah Nuts ! ! ! ----------------------------
'
' WARNING #1: ASSEMBLER code is not my cup of tea. 
'
' WARNING #2: What you see is what you get. There is no warranty exspressed,
'   implied or otherwise.
'
' REFFERENCES:
'   The following manuals/books were used in developing this code:
'   Basic Programer's Guide version 7.0 (c)1989,1988,1887, Microsoft
'   Macro Assembler 5.0 Programers Guide (c)1987, Microsoft
'   Macro Assembler 5.1 Update (c)1987, Microsoft
'   Disk Operating System Ver 3.3 Technical Reference (c)1987,1985, IBM
'   The 8086 Book (c)1980, Osborne/McGraw-Hill, Russell Rector, George Alexy
'
' ***************************************************************************

type dtatype
	reserve 	as string * 21				' reserved for use by DOS
	atrib   	as byte					' file atribute
	filetime	as Word					' file time
	filedate	as Word					' file date
	filesize    as Dword				' size of file in bytes
	filename    as String * 12			' dos file name
	terminator  as byte					' chr$(0)
end type
' ----------------------------------------------------------------------------
' code for testing and debugging
' ----------------------------------------------------------------------------
' test$="C:\autoexec.bat"
' cls
' p$= "dir "+test$
' shell p$
' s$ = FileInfo$(test$)
' print
' print
' print
' print
' print
' print
' print
' print
' print
' print
' print s$
' print "123456789012345678901234567890123456789012345678901234567890"
' end
' -----------------------------------------------------------------------------
Function FileInfo$ (Search$) static
	' The format of the retruned string is as follows:
	' FILENAME.EXT   YYYY-MM-DD  HH:MM:SS  FILE0SIZE
	' 1234567890123456789012345678901234567890123456
	dim olddtaoff as Word        	' PB3's Disk Transfer Area offset
	dim olddtaseg as Word        	' PB3's Disk Transfer Area segment
	dim ourdtaoff as Word        	' our Disk Transfer Area offset
	dim ourdtaseg as Word        	' our Disk Transfer Area segment
	dim specoff   as Word        	' our Search String offset
	dim specseg   as Word        	' our Search String segment
	dim ourdta    as dtatype		' Our DTA
	dim ourerr    as Integer
	dim temp1     as dword
	dim temp2     as dword
	dim temp3     as dword

	ourerr = 0
	a?=16
	spec$ = ucase$(rtrim$(search$))+chr$(0)
	if Len(spec$) <  1   then FileInfo$ = "": exit Function
	ourdtaseg = varseg(ourdta)
	ourdtaoff = varptr(ourdta)
	specseg	  = strseg(spec$)
	specoff   = strptr(spec$)

		'------------------------------------------------------------------
        ' This routine uses calls to DOS FindFirst function.
        ' We need to save the existing DTA and replace it
        ' with our own static data area.
		'------------------------------------------------------------------
		' save PB3's DTA
		! push    es
		! mov     ah,&h2F                 ; DOS function: Get DTA
		! int     &h21                    ; Call DOS
        ! mov     olddtaoff,bx            ; Save old dta offset.
        ! mov     olddtaseg,es            ; Save old dta segment.
		! pop	  es
		'------------------------------------------------------------------
		' set up our DTA
		! push	  ds
		! mov	  dx,ourdtaoff		    ; put location in DS:DX
		! mov	  ds,ourdtaseg
		! mov       ah, &h1A              ; DOS function: Set DTA
		! int       &h21                  ; call DOS
		! pop	  ds
		'------------------------------------------------------------------
        ' Now we set up the DOS call to find first.
        ' DOS exspect the address of the spec in DS:DX and the
        ' 8 bit atribute in CX.
		'------------------------------------------------------------------
		! push      ds				    ; save data segment
        ! xor       cx,cx                 ; Zero the top half.
		! mov       cl, a?
		! mov	  dx, specoff		    ; put location in DS:DX
		! mov	  ds, specseg
		'------------------------------------------------------------------

		! mov       ax,&h4E00             ; DOS FIND FIRST function.
		'------------------------------------------------------------------
		! int       &h21                  ; Call DOS
		! pop	  ds				    ; restore data seg
	    ' Error code (if carry flag set) will be returned in AX.
		! jnc       ahnuts1               ; If no error
        ! mov	  ourerr,ax             ; Save the error code
		'------------------------------------------------------------------
ahnuts1:
 		' restore PB3's DTA.
        ! push    ds                      ; Save our data segment
        ! mov     ax, olddtaseg           ; Place new data segment in AX.
        ! mov     dx, olddtaoff           ; Place new offset in DX.
        ! mov     ds, ax                  ; Set the data segment.
		! mov     ah, &h1A                ; point DOS to our static DTA
		! int     &h21                    ; call DOS
        ! pop     ds                      ; restore our data segment
		'------------------------------------------------------------------
        ' Our DTA should now contain the information we desire.
		spec$=""
		if ourerr<>0 then FileInfo$ = "" : exit function
		spec$=ourdta.filename
		t$=""
		for i%=1 to len(spec$)
			c$=mid$(spec$,i%,1)
			if c$>chr$(32) then t$=t$+c$
		next i%
		Spec$=left$(t$+space$(25),15)
		' fill in the date$
		' I have chosen to format the DateTime$ in order from year to seconds
		' This was done to make it easy to compare the dates of two files
		' or to sort a list of files by date and time.
		temp1 = ourdta.filedate
		! mov       ax, temp1        	      ; Retrieve file date
		! push      ax
		! push      ax
        ! and       ax, &b0000000000011111  ; Mask off the day.
 		! mov	  temp1,ax
		! pop	  ax
        ! and       ax, &b0000000111100000  ; Mask off the month
        ! mov       cl, 5                   ; We rotate the Month to the right
        ! ror       ax,cl                   ; 5 bits.
		! mov       temp2,ax
		! pop	  ax
		! and       ax, &b1111111000000000  ; Mask off the year
        ! mov       cl, 7                   ; We rotate the year to the left
        ! rol       ax,cl                   ; 7 bits.
        ! add       ax,1980                 ; Add the base year 1980 to AX.
		! mov	  temp3,ax
		Spec$ = spec$ + val2str$(temp3,4)+"-"+val2str$(temp2,2)+"-"+val2str(temp1,2)+ "  "
		' fill in the time
		temp1 = ourdta.filetime
		! mov       ax, temp1			 ; Retrieve file time.
		! push      ax
		! push      ax
        ! and       ax, &b0000000000011111  ; Mask off the seconds.
        ! rol       ax,1                    ; DOS stores time in 2 sec increments.
		! mov	  temp1,ax
		! pop	  ax
		! and       ax, &b0000011111100000  ; Mask off the minutes.
        ! mov       cl, 5                   ; We rotate minutes to the right
		! ror       ax, cl                  ; 5 bits.
		! mov	  temp2,ax
		! pop       ax
		! and       ax, &b1111100000000000  ; Mask off the hours
        ! mov       cl, 5                   ; We rotate hours to the left
        ! rol       ax, cl                  ; 5 bits.
		! mov       temp3,ax
		Spec$ = Spec$+val2str$(temp3,2)+":"+val2str$(temp2,2)+":"+val2str(temp1,2)+"  "
		Spec$ = Spec$+val2str$(ourdta.FileSize,9)
		FileInfo$=Spec$
end function

' -----------------------------------------------------------------------------
function val2str$(v???,digits%)
	val2str$=right$((string$(digits%,"0")+ltrim$(str$(v???))),digits%)
end function
' -EOF------------------------------------------------------------------------
