' PURPOSE:   Perry Drawing file management
' DATE:      1 August 1994
' CONCEPT:   
'            At least once each day every CAD operator runs a BATCH
'            file for the purpose of backing up the days work. The 
'            idea here is to change that procedure to twice a day
'            and to assit the CAD supervisor in manageing the CAD files.
'
'            This program will be called by the  Backup Batch file.
'            This will allow the CAD Supervisor (and maybe the checker)
'            to write a plain ASCII control file that will Copy, Move,
'            Delete, Rename or List files at a given operators station.
'--------------------------------------------------------------------------
defint a-z
$INCLUDE "AHNUTS.BAS"
$INCLUDE "COPYFILE.BAS"
DIM FileList$(1 to 1000)         ' array for matching files
action%=0                        ' set default to do nothing
Perry%=0
SourPath$="C:\DATA\DWG\"
DestPath$="Q:\RELEASE\"


' define two strings for stripping control characters from input
for i%=1 to 31
   m$=m$+chr$(i%)
next i%
n$=space$(31)

c$=command$
replace ANY m$ with n$ in c$
c$ = ucase$(ltrim$(rtrim$(c$)))

if c$="" then end
if dir$(c$)="" then end
' NOW just for a little caution: THE CONTROL FILE EXTENSION MUST BE ".EVE"
if right$(c$,4)<>".EVE" then print "NOT A VALID CONTROL FILE NAME": END

open c$ for input as #1
Line Input #1, l$
l$=Rtrim$(Ltrim$(Ucase$(l$)))
if l$<>"@CONTROL FILE@" then
   Print c$;" is not a valid CONTROL FILE --- Aborted"
   BEEP: BEEP: BEEP
   End
End If
close #1

' now rename the file so that there is no chance that we process it twice
p%=instr(c$,".EVE")
t$=left$(c$,p%)+"VEV"
name c$ as t$
c$=t$

CLS
Print "Drawing file maintainence with Control File: ";c$
open c$ for input as #1

p%=instr(c$,".DEL")
r$=left$(c$,p%)+"LOG"
open r$ for append as #2
print #2,"============================================================================"
print #2,date$, time$, c$
print #2,"============================================================================"


START:
   '-------------------------------------------------------------------------
   kw$=""
   ' get line from file and clean it up
   if EOF(1) then goto FINISH:
   Line Input #1, l$
   if l$=""  then goto START:

   ' clean up the input
   replace ANY m$ with n$ in l$
   l$=ltrim$(rtrim$(l$))

   ' allow for comments
   if left$(ltrim$(l$),1)=";" then goto START:
   p%=instr(l$,";")
   if p%>0 then l$=rtrim$(left$(l$,p-1))
   if l$="" then goto START:

   '------------------------------------------------------------------------
   ' check and handle in control keywords
   ' All control statements begin with @ and end with a space or end of line
   if left$(l$,1)="@" then
        ' seperate keword and any parameters
        p%=instr(l$," ")
        if p%>0 then
             kw$=ucase$(left$(l$,p%-1))
             pr$=ltrim$(mid$(l$,p%))
        else
             kw$=ucase$(l$)
             pr$=""
        end if
        select case kw$
             case "@LOG"              ' add comment to LOG File
                  print #2, pr$
             case "@ECHO"             ' display message on console
                  print pr$
             case "@PAUSE"            ' allow for pause
                  Print " Press any key to continue ...";
                  while inkey$="" :wend
                  print
             case "@ESCAPE"           ' allow for escape
                  Print " Press ESC key to abort, any other key to continue ...";
                  k$=""
                  while k$=""
                       k$=inkey$
                       if k$=chr$(27) then 
                            print #2, "**** Operator aborted operation **** ";time$
                            print
                            print "***** OPERATOR ABBORTED ******"
                            end
                       end if
                  wend
             case "@LOGLOG"           ' set mode to log only
                  action%=0
                  Print #2,"----@LOG ONLY MODE-------------------------------------------"
             case "@RENAME"           ' set mode to RENAME files
                  action%=1
                  Print #2,"----@RENAME MODE---------------------------------------------"
             case "@DELETE"           ' set mode to DELETE files
                  action%=2
                  Print #2,"----@DELETE MODE---------------------------------------------"
             case "@COPY"             ' set mode to COPY files
                  action%=3
                  Print #2,"----@COPY MODE-----------------------------------------------"
             case "@MOVE"             ' set mode to MOVE files
                  action%=4
                  Print #2,"----@MOVE MODE-----------------------------------------------"
             case "@DESTINATION"      ' set Destination Path
                  if pr$="" then
                       MajorError%=1
                       Print #2, "***** NULL destination path --- Operation Abborted *****";time$
                       end
                  end if
                  DestPath$=pr$
                  if right$(DestPath$,1)<>"\" then DestPath$=SourPath$+"\"
                  print #2, "-----DESTINATION PATH set to ";DestPath$;" -----------"
             case "@SOURCE"      ' set source Path
                  if pr$="" then
                       MajorError%=1
                       Print #2, "***** NULL SOURCE path --- Operation Abborted *****";time$
                       end
                  end if
                  SourPath$=pr$
                  if right$(SourPath$,1)<>"\" then SourPath$=SourPath$+"\"
                  print #2, "-----SOURCE PATH set to ";SourPath$;" ------------------"
             case "@PERRY"       ' confine operations to valid Perry File names
                  Perry%=1
                  print #2, "-----Valid Perry Documnet File Names Only -------------"

             case "@ANY"         ' operations on any File names
                  Perry%=0
                  print #2, "-----Any matching File names" --------------------------"
             case else
                  ' must be a comment ???
        end select
   end if
   if kw$<>"" then goto start:
   '------------------------------------------------------------------------
   ' assume we have a valid file Mask
   ' check for source path and spaces
   p%=0
   t$=""
   if instr(l$,ANY ":\ ") then
        for i%=1 to len(l$)
             c$=mid$(l$,i,1)
             if c$>chr$(32) then t$=t$+c$
        next i%
        l$=t$
        for i%=1 to len(t$)
             if mid$(l$,i%,1)=":" then p%=i
             if mid$(l$,i%,1)="\" then p%=i
        next i%
        if p%>0 then 
             SourPath$=left$(t$,p%)
             if right$(SourPath$,1)<>"\" then SourPath$=SourPath$+"\"
             print #2, "-----SOURCE PATH set to ";SourPath$;" -----------"
             if p%<>len(t$) then
                  l$=mid$(t$,p%+1)
             else
                  l$="Aint-No-Way-Man"
             end if
        end if
   end if
   '------------------------------------------------------------------------
   if len(l$)>13 then goto START:

   count%=0
   d$=dir$(l$)
   while d$<>""
        valid%=0
        if Perry%=1 then
             ' get the leading part of the file name
             ' check for valid Perry Document file name
             ' the Filename must be at least 8 characters
             t$=ucase$(left$(d$,9))
             if len(d$)<>9 then 
                  valid%=1
             else
                  if right$(d$)<>"." then valid%=1
                  ' the first 5 characters must be numeric
                  for i%=1 to 5
                       c$=mid$(t$,i%,1)
                       if c$>"9" then valid%=1
                       if c$<"0" then valid%=1
                  next i%
                  ' the next 3 characters must be alphanumeric
                  for i%=6 to 8
                       c$=mid$(t$,i%,1)
                       if c$>"Z" then valid%=1
                       if c$<"0" then valid%=1
                       if c$>"9" and c$<"A" then valid%=1
                  next i%
             end if
        end if
        if valid%=0 then
             count%=count%+1
             FileList$(count%)=d$
        end if
        if count%<1000 then
             d$=dir$
        else
             print #2, "**** MORE THAN 1000 MATCHES for ";l$;" Operation truncated *****"
             d$=""
        end if
   Wend
   '------------------------------------------------------------------------
   ' Now we should have a list of up to 1000 valid file names
   for FileIndex%=1 to Count%
        d$=FileList$(FileIndex%)
        Print #2, FileInfo$(SourPath$+d$);
        Print d$
        select case action%
             case 0
                  Print #2,""
             case 1
                  p%=instr(d$,".")
                  t$=left$(d$,p%)+"DEL"
                  if dir$(SourPath$+t$)<>"" then KILL (SourPath$+t$)
                  name (SourPath$+D$) as T$
                  Print #2, " Renamed to ";t$
             case 2
                  KILL SourPath$+D$
                  Print #2, " Deleted"
             case 3
                  ' First we need to split out the file name
                  '  add in the Release Dir Path.
                  t$=DestPath$+t$
                  if Dir$(t$)<>"" then
                       ' It is assumed that we can not modify files in the destination directory
                       Print #2,""
                       Print #2, " ***** Drawing exist in destination directory *****"
                       PRINT #2, " ***** COPY OF ";D$;" OPERATION ABORTED *****" 
                       MajorError%=1
                  Else
                       if CopyFile%(SourPath$+d$,DestPath$+t$)=0 then
                            Print #2, "Copied to ";T$
                            If VerifyFile%(SourPath$+d$,DestPath$+t$)=0 then
                                 Print #2, ", Verifyed Copy, ";
                                 Print #2, DestPath$;FileInfo$(DestPath$+T$)
                            else
                                 Print #2, ", ***** Verify Error ****** "
                                 Print #2, "******************************************************"
                                 PRINT #2, "   ***** ***** COPY OF ";D$;" NOT VALID ***** *****" 
                                 PRINT #2, "   ***** ***** COPY OF ";D$;" NOT VALID ***** *****" 
                                 PRINT #2, "   ***** ***** COPY OF ";D$;" NOT VALID ***** *****" 
                                 Print #2, "******************************************************"
                                 PRINT "   ***** ***** COPY OF ";D$;" NOT VALID ***** *****" 
                                 BEEP: BEEP: BEEP: BEEP: BEEP: BEEP: BEEP: BEEP: BEEP: BEEP: BEEP
                                 MajorError%=1
                            End if
                       Else
                            Print #2, ", ***** Copy Error ****** "
                            PRINT #2, " ***** MOVE OF ";D$;" OPERATION ABORTED *****" 
                            MajorError%=1
                       End if
                  End if
                  Print #2,"---------------------------------------------------------------"

             case 4
                  ' First we need to split out the file name
                  '  add in the Release Dir Path.
                  t$=DestPath$+t$
                  if Dir$(t$)<>"" then
                       ' It is assumed that we can not modify files in the destination directory
                       Print #2,""
                       Print #2, " ***** Drawing exist in destination directory *****"
                       PRINT #2, " ***** MOVE OF ";D$;" OPERATION ABORTED *****" 
                       MajorError%=1
                  Else
                       if CopyFile%(SourPath$+d$,DestPath$+t$)=0 then
                            Print #2, "Copied to ";T$
                            If VerifyFile%(SourPath$+d$,DestPath$+t$)=0 then
                                 Print #2, ", Verifyed Copy, ";
                                 Kill SourPath$+d$
                                 Print #2, "Erased ";D$
                                 Print #2, DestPath$;FileInfo$(DestPath$+T$)
                            else
                                 Print #2, ", ***** Verify Error ****** "
                                 PRINT #2, " ***** MOVE OF ";D$;" OPERATION ABORTED *****" 
                                 MajorError%=1
                            End if
                       Else
                            Print #2, ", ***** Copy Error ****** "
                            PRINT #2, " ***** MOVE OF ";D$;" OPERATION ABORTED *****" 
                            MajorError%=1
                       End if
                  End if
                  Print #2,"---------------------------------------------------------------"
             case Else
        end select
   Next FileIndex%
   goto START:


FINISH:
Close #1
if MajorError%<>0 then 
   Print #2, "***** MAJOR ERROR IN THIS SESION ********************************"
else
   print #2, "----- No major errors in this session ----------------------------"
end if
Print #2, "Normal Termination  ";time$
Close #2
End
