(* DATEFILE.PAS renames any file to a prefix name plus today's date *)

(* The core of this program was written by Paul Saletan, *)
(* Central Texas PC Users Group. Error trapping routines *)
(* have since been added.                                *)

uses Dos;

var
  ThisFile: File;
  Prefix: string[3];
  NewName: string;
  BigPath: PathStr;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
  Suffix: char;
  FileRec: SearchRec;
  DateDigits : string[4];
  Err : word;
  ShowDates : String[4];
  i : integer;

Const
        Brag : String[55] =
               'Compiled by David Adamson for the BatPower conference.';

{$I IOERROR.psl}

procedure ShowDate;
var
   Year, Month, Day, DayOfWeek : word;
   Yr, Mon, Dy                 : string[2];
   Reg                         : Registers;
begin
   getdate(Year, Month, Day, DayOfWeek);
   Year := Year - 1900;
   if Year > 99 then
      Year := Year - 100;
   str(Year:2, Yr);
   str(Month:2, Mon);
   str(Day:2, Dy);
   if Yr[1]  = ' ' then Yr[1]  := '0';
   if Mon[1] = ' ' then Mon[1] := '0';
   if Dy[1]  = ' ' then Dy[1]  := '0';
   DateDigits := Mon + Dy;
   writeln('Today is: ',Mon,'-',Dy,'-',Yr);
end;

Procedure Help;
begin
  if ParamCount = 0 then
    begin
    writeln('DATEFILE  renames any file to a prefix plus today''s date.');
    writeln('Usage is "DATEFILE  filename.exe prefix" where filename.exe');
    writeln('is the name of the file to be renamed and prefix is a three');
    writeln('charter entry. The "prefix" entry is optional.');

    Halt(255);
    end;
end;

Begin
 If ParamCount = 0 then Help;
 { else begin }
   ShowDate;
   BigPath:=ParamStr(1);
   Assign(ThisFile,BigPath);
   FSplit(BigPath,Dir,Name,Ext);
   case ParamCount of
     1: Prefix:=Copy(Name,1,3);
     2: Prefix:=Copy(ParamStr(2),1,3);
   end;
   Suffix := chr(64) ;
   repeat
     Suffix := Succ(Suffix);
     NewName:= Dir + Prefix + DateDigits + Suffix + Ext;
     FindFirst(NewName,AnyFile,FileRec);
   until (DosError <> 0) or (Suffix = 'Z');
   {$I-}
   Rename(ThisFile,NewName);
   {$I+}
   Err := IOerror;
   Begin
     for i := 1 to Length(NewName) do
     NewName[i] := Upcase(NewName[i]);
   end;
   if Err = 0 then writeln('New Name: ',NewName);
   Halt(Err);
End.


