                                R E A D M E . D O
				 
DO is a text and binary file manipulator. This file is intended to get you up
and running with the program, let you know a little bit about what it can do,
and give some command line examples. For a fuller description of the commands,
see the accompanying DO.DOC documentation.

There are two ways to use DO: interactively and by command line parameters,
including batch files. Using DO with command line parameters is much faster
and permits input/output redirection (piping). Powerful constructions can be
assembled by chaining together strings of DO filters. If you have the
registered version of DO, you can see many examples in the batch files that are
included as a subdirectory on your disk. However, the interactive version of DO
permits you to see both the input file and the transformed output at the same
time. It is also easier to learn because it prompts the user for each
parameter, so it will be discussed first.

INTERACTIVE DO

To use DO interactively, just enter "DO" at the DOS prompt:

C> do<ENTER>

You will be presented with a screen similar to the one seen on the first page
of the DO.DOC documentation. It should look something like this:

DO 4.1 $29 (C)ROBINETS 1986-93 2114 BANK ST,BALTIMORE 21231 LVH@CONNECT.WIN.NET
 [a] ask first; [r]eplace strings      [k] kill, fnd str; [K]opy between   
 [b] bomb; [B]uild reptd, blank lines  [n] numbr lines; [N]ix is mixed case  
 [c] copy; [C]ut columns; [$]copy$Cut  [p] paragraph from lines; [o]pposite 
 [d] do WordStar; [D]o as last,first   [q] quicksort (467808 bytes free)     
 [e] expand tabs; [l]owcase; [u]pcase  [s] show CR+LF; [x]outCR; [X]outLF 
 [f] find; [z]erofind; [y]ank strings  [t] tag; [T]oss lines; [&]tag&Toss    
 [g] glue; [j]oin; [m]erge two files   [v] valid; [V]oid set in srch,fltr   
 [h] high bits low; [H]igh bits rmvd [w] whtspc to tab; [W]htspc removed   
 [i] insrt at col; [I]nject at filpos [#] numbers only in lines w. numbers  
Ĵ
 NOTES: For ask,fnd,insrt,rplc,vset,yank,zfnd: ASCII values entered as [nnn] 
 (eg, [27] => ESC); upcase (A,F,Q,R,Y,Z) => ignore case; /cmd => line numbers
Ĵ
 COMMAND LINE EXAMPLES (where:i/o=file c=col l=lin n=num s=string [n]=ASCII) 
Ĵ
 do /b i   do e i n   do f i s[n]s[AND]s[n]s  do c i c c    do m i1 i2 > o   
 do /l i   do f i s   do z i s[ORNOT]s        do i i c s    do g i1 i2 c > o 
 do /q i   do v i s   do r i s//s             do q i c n R  do j i1 i2 l > o 
 do /w i   do z i s   do r i s//s[][13][10]s  do t i l l    do y i o1 s > o2 
Ĵ
Choose from above (or "*" for cmd ln sntx, "+" for 9 lns, "-" for 4 lns):    
                                                                             
                                                                             


Let's try a simple example on this file (README.DO, which you are reading now).
Let's say you would like to find every line in this file that does NOT contain
the string "the". (The DO.DOC documentation will tell you how to restrict the
search to just the WORD "the" and/or how to ignore case, and/or how to include
line numbers, and so on.) The appropriate command would be selected from the
menu of items in the second part of the screen seen above. In this case, it is
"[z]erofind", so you would type a lower-case "z" and then press <ENTER>.

You will be prompted for an input file name, so you would enter the name of
this file: "readme.do".

Then you will be prompted for an output file name. We don't care about that for
now, so just press the <ENTER> key. (If you do enter an output file name, be
sure that it is not the name of an existing file, or it will be overwritten.)
Just before pressing <ENTER>, the screen should look like this:

DO 4.1 $29 (C)ROBINETS 1986-93 2114 BANK ST,BALTIMORE 21231 LVH@CONNECT.WIN.NET
 [a] ask first; [r]eplace strings      [k] kill, fnd str; [K]opy between   
 [b] bomb; [B]uild reptd, blank lines  [n] numbr lines; [N]ix is mixed case  
 [c] copy; [C]ut columns; [$]copy$Cut  [p] paragraph from lines; [o]pposite 
 [d] do WordStar; [D]o as last,first   [q] quicksort (462816 bytes free)     
 [e] expand tabs; [l]owcase; [u]pcase  [s] show CR+LF; [x]outCR; [X]outLF 
 [f] find; [z]erofind; [y]ank strings  [t] tag; [T]oss lines; [&]tag&Toss    
 [g] glue; [j]oin; [m]erge two files   [v] valid; [V]oid set in srch,fltr   
 [h] high bits low; [H]igh bits rmvd [w] whtspc to tab; [W]htspc removed   
 [i] insrt at col; [I]nject at filpos [#] numbers only in lines w. numbers  
Ĵ
 NOTES: For ask,fnd,insrt,rplc,vset,yank,zfnd: ASCII values entered as [nnn] 
 (eg, [27] => ESC); upcase (A,F,Q,R,Y,Z) => ignore case; /cmd => line numbers
Ĵ
 COMMAND LINE EXAMPLES (where:i/o=file c=col l=lin n=num s=string [n]=ASCII) 
Ĵ
 do /b i   do e i n   do f i s[n]s[AND]s[n]s  do c i c c    do m i1 i2 > o   
 do /l i   do f i s   do z i s[ORNOT]s        do i i c s    do g i1 i2 c > o 
 do /q i   do v i s   do r i s//s             do q i c n R  do j i1 i2 l > o 
 do /w i   do z i s   do r i s//s[][13][10]s  do t i l l    do y i o1 s > o2 
Ĵ
Choose from above (or "*" for cmd ln sntx, "+" for 9 lns, "-" for 4 lns): z  
Enter input file name: readme.do                                             
Enter output file name (if any):                                             


Then you will be prompted for the search string. Enter "the" without the quote
marks. The string can contain any ASCII characters, including spaces. (The
documentation will tell you how to embed special characters and how to use the
options that you see on the screen.) Just before pressing the <ENTER> key, the
screen will look like this:

DO 4.1 $29 (C)ROBINETS 1986-93 2114 BANK ST,BALTIMORE 21231 LVH@CONNECT.WIN.NET
 [a] ask first; [r]eplace strings      [k] kill, fnd str; [K]opy between   
 [b] bomb; [B]uild reptd, blank lines  [n] numbr lines; [N]ix is mixed case  
 [c] copy; [C]ut columns; [$]copy$Cut  [p] paragraph from lines; [o]pposite 
 [d] do WordStar; [D]o as last,first   [q] quicksort (462816 bytes free)     
 [e] expand tabs; [l]owcase; [u]pcase  [s] show CR+LF; [x]outCR; [X]outLF 
 [f] find; [z]erofind; [y]ank strings  [t] tag; [T]oss lines; [&]tag&Toss    
 [g] glue; [j]oin; [m]erge two files   [v] valid; [V]oid set in srch,fltr   
 [h] high bits low; [H]igh bits rmvd [w] whtspc to tab; [W]htspc removed   
 [i] insrt at col; [I]nject at filpos [#] numbers only in lines w. numbers  
Ĵ
                                                                             
                                                                             
+                                                                             
                                                                             
Ĵ
                                                                             
                                                                             
                                                                             
                                                                             
Ĵ
Find (using [^],[W],[And],[Or],[Then],[AndNot],[OrNot],[ThenNot],[XOR],[$]): 
the                                                                          
                                                                             


Note that the three information screens have disappeared and have been replaced
by two small windows (although they can be enlarged a little). When you press
the <ENTER> key, the top window will show the input file before DO has done
anything to the file, and the lower window will show the transformed output
file. (If you entered an output file name above, its contents will be identical
to what will be displayed in the lower screen.) Although DO will process the
file much more slowly than it would as a command line option, it is is still
much too fast to see. If you want to see a line at a time, press the <SPACE>
bar repeatedly. To return to full speed, press the <ENTER> key. To abort, press
the <ESC> key. In any event, the final screen should look something like this:

DO 4.1 $29 (C)ROBINETS 1986-93 2114 BANK ST,BALTIMORE 21231 LVH@CONNECT.WIN.NET
 [a] ask first; [r]eplace strings      [k] kill, fnd str; [K]opy between   
 [b] bomb; [B]uild reptd, blank lines  [n] numbr lines; [N]ix is mixed case  
 [c] copy; [C]ut columns; [$]copy$Cut  [p] paragraph from lines; [o]pposite 
 [d] do WordStar; [D]o as last,first   [q] quicksort (462816 bytes free)     
 [e] expand tabs; [l]owcase; [u]pcase  [s] show CR+LF; [x]outCR; [X]outLF 
 [f] find; [z]erofind; [y]ank strings  [t] tag; [T]oss lines; [&]tag&Toss    
 [g] glue; [j]oin; [m]erge two files   [v] valid; [V]oid set in srch,fltr   
 [h] high bits low; [H]igh bits rmvd [w] whtspc to tab; [W]htspc removed   
 [i] insrt at col; [I]nject at filpos [#] numbers only in lines w. numbers  
Ĵ
INCIDENTAL DAMAGES SO THE FOREGOING LIMITATION MAY NOT APPLY.                
Ĵ
+                                                                             
                                                                             
Ĵ
INCIDENTAL DAMAGES SO THE FOREGOING LIMITATION MAY NOT APPLY.                
Ĵ
                                                                             
                                                                             
Ĵ
Press space for pause, "+" for info (ENTER to go on); ESC to abort.          
readme.do: 160 lines read; 113 lines with zerofinds.                         
Choose from above (or "*" for cmd ln sntx, "+" for 9 lns, "-" for 4 lns):    


Note that a summary statement appears in the lowest (command) window. In this
case, 113 lines were found that did not contain the lower-case string, "the".
(Your screen will show different values, since I am actually using DO on this
file as I write it.) At this point, you have five options:

  (1)	Press <ENTER> to quit DO and go back to the DOS prompt.
  

  (2)	Press one of the keys above to execute another command interactively.
  	If you choose this option, you do not need to re-enter the input file
	name if it remains the same as before: Just press <ENTER> when you are
	prompted for the file name. This is convenient if you are testing the
	effects of commands on a data file, for example.
	
  (3)	Press "*" to see what the equivalent command-line syntax would be
  	for the last command. This is convenient if you are writing a batch
	file and don't know what the command line should be: Just do DO
	interactively, and press "*". You will remain in DO after the query.
	
  (4)	Press "+" to expand the I/O windows from 4 lines to 9 lines. The
  	effect of the command will be evident only after you execute the next
	command. This option has no effect if DO is already in the 9-line mode.
	Choosing this option will also make the price stop blinking. (The
	registered versions don't blink and may have the price replaced with
	your choice of three characters.)
	
  (5)	Press "-" to reduce the I/O windows from 9 lines to 4 lines. The
  	effect of the command will be evident only after you execute the next
	command. This option has no effect if DO is already in the 4-line mode.
	Choosing this option will also make the price stop blinking. (The
	registered versions don't blink	and may have the price replaced with
	your choice of three characters.)
	
That's all there is to it. I encourage you to experiment on the files of your
choice, preferably with the DO.DOC documentation in front of you. You will be
surprised at what you can do with DO.

Now for the command-line version of what we did above. At the DOS prompt,
either of these commands will effect the example used for the interactive
version of DO:

	C> do z readme.do the
	C> do z readme.do the > outfile
	
If you redirect (or pipe) the output, note that informational messages will
still go to the screen. The output file never contains any characters that are
not the result of operations upon the input file.

******************************************************************************

Do is ShareWare, and so here is the legalese:

----------------------------------------------------------------------------
DEFINITION OF SHAREWARE

Shareware distribution gives users a chance to try software before buying it.
If you try a Shareware program and continue using it, you are expected to
register. Individual programs differ on details -- some request registration
while others require it, some specify a maximum trial period. With
registration, you get anything from the simple right to continue using the
software to an updated program with printed manual.

Copyright laws apply to both Shareware and commercial software, and the
copyright holder retains all rights, with a few specific exceptions as
stated below. Shareware authors are accomplished programmers, just like
commercial authors, and the programs are of comparable quality. (In both
cases, there are good programs and bad ones!) The main difference is in the
method of distribution. The author specifically grants the right to copy and
distribute the software, either to all and sundry or to a specific group.
For example, some authors require written permission before a commercial disk
vendor may copy their Shareware. 

Shareware is a distribution method, not a type of software. You should find
software that suits your needs and pocketbook, whether it's commercial or
Shareware. The Shareware system makes fitting your needs easier, because you
can try before you buy. And because the overhead is low, prices are low
also. Shareware has the ultimate money-back guarantee -- if you don't use the
product, you don't pay for it. 
 ----------------------------------------------------------------------------
DISCLAIMER - AGREEMENT

Users of DO must accept this disclaimer of warranty:

"DO is supplied as is. The author disclaims all warranties, expressed or
implied, including, without limitation, the warranties of merchantability and
of fitness for any purpose. The author assumes no liability for damages,
direct or consequential, which may result from the use of DO." 

DO is a "shareware program" and is provided at no charge to the user for
evaluation. Feel free to share it with your friends, but please do not give
it away altered or as part of another system. The essence of "user-supported"
software is to provide personal computer users with quality software without
high prices, and yet to provide incentive for programmers to continue to
develop new products. If you find this program useful and find that you are
using DO and continue to use DO after a reasonable trial period, you must make
a registration payment of $29.00 to RobiNets Homuncular Solutions. The $29.00
registration fee will license one copy for use on any one computer at any one
time. You must treat this software just like a book. An example is that this
software may be used by any number of people and may be freely moved from one
computer location to another, so long as there is no possibility of it being
used at one location while it's being used at another. Just as a book cannot
be read by two different persons at the same time.

Commercial users of DO must register and pay for their copies of DO within
30 days of first use or their license is withdrawn. Site-License
arrangements may be made by contacting RobiNets Homuncular Solutions. 

Anyone distributing DO for any kind of remuneration must first contact
RobiNets Homuncular Solutions at the address below for authorization. This
authorization will be automatically granted to distributors recognized by
the (ASP) as adhering to its guidelines for shareware distributors, and such
distributors may begin offering DO immediately. (However, RobiNets Homuncular
Solutions must still be advised so that the distributor can be kept
up-to-date with the latest version of DO.)

You are encouraged to pass a copy of DO along to your friends for
evaluation. Please encourage them to register their copy if they find that
they can use it. All registered users will receive a copy of the latest
version of DO, two utility programs (PEEK, which finds numbers or text in
binary files, and PSORT, a disk-based sort program that handles millions of
records), a collection of useful batch files that use DO, written
documentation, and one hour of free phone support (your nickle).
 ----------------------------------------------------------------------------
THE INFORMATION AND CODE PROVIDED HEREUNDER (COLLECTIVELY REFERRED TO
AS "SOFTWARE") IS PROVIDED AS IS WITHOUT WARRANTY OF ANY KIND, EITHER
EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE. IN NO EVENT SHALL
ROBINETS BE LIABLE FOR ANY DAMAGES WHATSOEVER INCLUDING DIRECT, INDIRECT,
INCIDENTAL, CONSEQUENTIAL, LOSS OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN
IF ROBINETS HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES. SOME STATES
DO NOT ALLOW THE EXCLUSION OR LIMITATION OF LIABILITY FOR CONSEQUENTIAL OR
INCIDENTAL DAMAGES SO THE FOREGOING LIMITATION MAY NOT APPLY.
 ----------------------------------------------------------------------------
===================
OMBUDSMAN STATEMENT
===================
Larrie Hutton of RobiNets Homuncular Solutions is a member of the Association
of Shareware Professionals (ASP). ASP wants to make sure that the shareware
principle works for you. If you are unable to resolve a shareware-related
problem with an ASP member by contacting the member directly, ASP may be able
to help. The ASP Ombudsman can help you resolve a dispute or problem with an
ASP member, but does not provide technical support for members' products.
Please write to the ASP Ombudsman at 545 Grover Road, Muskegon, MI
49442-9427 USA, FAX 616-788-2765 or send a CompuServe message via CompuServe
Mail to ASP Ombudsman 70007,3536.
 ----------------------------------------------------------------------------
