***********************************************************
*  lpath.prg        long path statements                  *
***********************************************************
* 03-24-94  Version 1.0 created by Gene Poleto.
* 03-29-94  Version 1.1 created by John Wright.
*           Do not allow path to exceed 255 characters.
*           Check for existing path before adding.
*           Do NOT alter original command line (causes garbage).
* 03-30-94  Merged Gene's 1.01 code to my 1.1 code to create 1.2.
*           Added PATH_ALREADY_THERE and PATH_TOO_LONG procedures
*           to consolidate error messages like Gene did in 1.01.
*           Fixed problem with append not working correctly on
*           long paths.  Merged APPEND_PATH and PREPEND_PATH
*           procedures into new CHANGE_PATH procedure.
*           Rewrote SAVE_PATH procedure to simplify code.
* 03-31-94  Argh!  Need to check end of original path to be sure
*           it ends in a semi-colon when adding to the path.

#include error.hdr
#include fileio.hdr
#include iif.hdr
#include string.hdr
#include system.hdr
#include warn.hdr

************************************************************
*  global variables                                        *
************************************************************
vardef
   file         file_out
   uint         no_env_chars
   uint         env_size, path_len, path_start, semi_colon, last_semi_colon
   ulong        env_seg
   ulong        i, j, k
   char(255)    path_to_add
   char(255)    existing_path
   char(255)    cmdline
   char(1)      pth[256]
   char(13)     type_to_add
   logical      path_found, path_is_last, quiet_mode
enddef
*-------------------------------------------------------------------------
procedure error_proc              && <<<<<  ERROR_PROC  >>>>>
   ? e_message
endpro
*-------------------------------------------------------------------------
proc show_syntax
   ? 'LPATH 1.2 - Create Long PATH statements (up to 255 characters)'
   ?
   ? 'LPATH          Display Path, And Environment Statistics'
   ? 'LPATH =  xxx   Remove Old Path, If It Exists, Then Make New Path'
   ? 'LPATH /a xxx   Append  To Existing Path        (goes to end)'
   ? 'LPATH /p xxx   Prepend To Existing Path        (goes to beginning)'
   ? 'LPATH /r xxx   Remove Specified Path Segment'
   ? 'LPATH /s       Generate File C:\ORGLPATH.BAT To Restore Original Path'
   ? 'LPATH /q       Quiet Mode, No Screen Displays  (for .BAT files)'
   ? 'LPATH /h or /? Display Help Screen'
   ?
   ? 'Parameter can be prefaced by  / or - character, case is unimportant.'
   ? 'xxx represents a new path to act upon, duplicates are ignored.'
   ? '/q is the only parameter that can be used with other parameters.'
   ? 'ERRORLEVEL 5 is returned if action not completed. (for .BAT files)'
   ?
   ? 'LPATH written in Force 2.4 by Gene Poleto; updated by John Wright.'
   ?
endpro && show_syntax
*-------------------------------------------------------------------------
proc get_env_size_chars           && <<<<<  GET_ENV_SIZE_CHARS  >>>>>
   env_size = (peek(env_seg-1, 4) * 0x1000) + (peek(env_seg-1, 3) * 0x10)
   if peek(env_seg,0) = 0 .and. peek(env_seg,1) = 0
      no_env_chars = 2
      return
   endif
   i = env_seg
   j = 0
   do while .t.
      if peek(i,j) = 0 .and. peek(i,j+1) = 0
         exit
      endif
      j = j+1
   enddo
   no_env_chars = j+2
endpro && get_env_size_chars
*-------------------------------------------------------------------------
proc get_path_start               && <<<<<  GET_PATH_START  >>>>>
   vardef
      char(5)   temp
   enddef
   path_found = .f.
   temp = ""
   j = 0
   do while .t.
      if peek(env_seg,j) = 0 .and. peek(env_seg,j+1) = 0
         exit
      endif
      temp = chr(peek(env_seg,j+0)) + chr(peek(env_seg,j+1)) + ;
             chr(peek(env_seg,j+2)) + chr(peek(env_seg,j+3)) + ;
             chr(peek(env_seg,j+4))
      if temp = 'PATH=' .and. (j = 0 .or. peek(env_seg,j-1) = 0) && eliminate
         path_found = .t.                                        && spfpath=,
         exit                                                    && etc.
      endif
      j = j+1
   enddo
   path_start = j
endpro && get_path_start
*-------------------------------------------------------------------------
proc get_path_len                 && <<<<<  GET_PATH_LEN  >>>>>
   j = path_start
   i = 0
   do while i <= 255
      if peek(env_seg,j) = 0
         exit
      endif
      j = j+1
      i = i+1
   enddo
   path_len = i
endpro && get_path_len
*-------------------------------------------------------------------------
proc get_path                     && <<<<<  GET_PATH  >>>>>
   vardef
      ulong     i
      uint      j
      char(1)   temp
   enddef
   get_env_size_chars       && env_size, no_env_chars
   i = 0
   do while i <= 255
      pth[i] = "0"
      i = i+1
   enddo
   j = 0
   path_is_last = .f.
   get_path_start
   if .not. path_found
      path_start = 0
      path_len   = 0
      return
   endif
   get_path_len
   j = path_start
   i = 0
   do while i <= path_len     && will have ; if in org
      temp = chr(peek(env_seg,j))
      pth[i] = temp
      j = j+1
      i = i+1
   enddo

   j = path_start + path_len
   if (peek(env_seg,j-1) = 0 .and. peek(env_seg,j+0) = 0) .or. ;
      (peek(env_seg,j+0) = 0 .and. peek(env_seg,j+1) = 0)
      path_is_last = .t.
   endif
endpro && get_path
*-------------------------------------------------------------------------
proc print_stats                  && <<<<<  PRINT_STATS  >>>>>
   if quiet_mode
      quit
   endif
   do get_path        && path_found,path_start,path_len,path_is_last,pth[256]
   ?
   i = 0
   do while i <= path_len-1
      ?? pth[i]
      i = i+1
   enddo
   ?
   ? 'Environment Space Used by Path: ' + str(path_len,5,0)
   ? ' Other Environment Space Usage: ' + ;
     str(no_env_chars-path_len,5,0)
   ? '   Remaining Environment space: ' + str(env_size-no_env_chars,5,0)
   ? '   Allocated Environment space: ' + str(env_size,5,0)
   ?
   return
endpro && print_stats
*-------------------------------------------------------------------------
proc make_path_last               && <<<<<  MAKE_PATH_LAST  >>>>>
   vardef
      uint      i, j, k
   enddef
   if .not. path_found
      return
   endif
   if path_is_last
      j = path_start + path_len
      if peek(env_seg, j-1) <> asc(";")
         poke(env_seg, j, asc(";"))
         poke(env_seg, j+1, 0)
         poke(env_seg, j+2, 0)
         path_len = path_len + 1  && okay because we return
         return
      endif
   endif
   i = path_start
   do while .t.      && poke everything but path
      if peek(env_seg, i + path_len + 0) = 0 .and. ;
         peek(env_seg, i + path_len + 1) = 0
         exit
      endif
      poke(env_seg, i, peek(env_seg, i + path_len + 1))  && don't include
      i = i+1                                            && added ; in
   enddo                                                 && path_len
   if peek(env_seg, i-0) <> 0
      poke(env_seg, i-0, 0)
   endif

   i = no_env_chars - path_len - 2
   j = 0
   do while j <= (path_len + 1)     && poke path into last place
      if pth[j] = "0"
         exit
      endif
      poke(env_seg, i, asc(pth[j]))
      i = i+1
      j = j+1
   enddo
   if pth[j-2] <> ";"
      poke(env_seg, i-1, asc(";"))
      path_len = path_len + 1
      no_env_chars = no_env_chars + 1
   endif
   poke(env_seg, i+0, 0)
   poke(env_seg, i+1, 0)
   get_path_start
endpro && make_path_last
*-------------------------------------------------------------------------
proc kill_path                    && <<<<<  KILL_PATH  >>>>>
   if path_start <> 0
      poke(env_seg, path_start, 0)
   endif
endpro && kill_path
*-------------------------------------------------------------------------
proc no_path_quit                 && <<<<<  NO_PATH_QUIT  >>>>>
   if .not. quiet_mode
      ? 'No existing path - use LPATH = path'
      ?
   endif
   quit
endpro && no_path_quit
*-------------------------------------------------------------------------
proc too_much_quit                && <<<<<  TOO_MUCH_QUIT  >>>>>
   if .not. quiet_mode
      ? 'Insufficient Environment Space - Path Not Changed'
      ?
   endif
   quit 5
endpro && too_much_quit
*-------------------------------------------------------------------------
proc path_already_there           && <<<<<  PATH_ALREADY_THERE  >>>>>
   if .not. quiet_mode
      ? path_to_add + ' is already in the path!'
      ?
   endif
   * Use return instead of quit so existing path is shown...
   return
endpro && too_much_quit
*-------------------------------------------------------------------------
proc path_too_long                && <<<<<  PATH_TOO_LONG  >>>>>
   if .not. quiet_mode
      ? 'Existing path and new path are greater than 255!'
      ?
   endif
   quit 5
endpro && too_much_quit
*-------------------------------------------------------------------------
proc change_path                  && <<<<<  CHANGE_PATH  >>>>>
   para const char(255) cmdline
   if path_to_add $ existing_path
      do path_already_there
      return
   endif
   do get_path        && path_found,path_start,path_len,path_is_last,pth[256]
   if .not. path_found
      do no_path_quit
   endif
   if no_env_chars + len(path_to_add) > env_size
      do too_much_quit
   endif
   if path_len + len(path_to_add) > 255
      do path_too_long
   endif
   make_path_last
   do kill_path

   * Put the PATH= statement in place
   i = path_start
   poke(env_seg, i+0, asc("P"))
   poke(env_seg, i+1, asc("A"))
   poke(env_seg, i+2, asc("T"))
   poke(env_seg, i+3, asc("H"))
   poke(env_seg, i+4, asc("="))
   i = i + 5

   if type_to_add = 'add_to_front'
      j = len(path_to_add)
      k = 1
      do while k <= j
         poke(env_seg, i, asc(substr(path_to_add, k, 1)))
         i = i+1
         k = k+1
      enddo
   endif

   * Put original path in place
   j = len(existing_path)
   k = 1
   do while k <= j
      poke(env_seg, i, asc(substr(existing_path, k, 1)))
      i = i+1
      k = k+1
   enddo

   * Make sure path ends with semi-colon
   if RIGHT( existing_path, 1 ) <> ";"
      poke(env_seg, i, asc(";") )
      i = i+1
   endif

   if type_to_add = 'add_to_back'
      j = len(path_to_add)
      k = 1
      do while k <= j
         poke(env_seg, i, asc(substr(path_to_add, k, 1)))
         i = i+1
         k = k+1
      enddo
   endif

   poke(env_seg, i+0, 0)
   poke(env_seg, i+1, 0)
endpro && append_path
*-------------------------------------------------------------------------
proc new_path                     && <<<<<  NEW_PATH  >>>>>
   para const char(255) cmdline
   do get_path        && path_found,path_start,path_len,path_is_last,pth[256]
   if no_env_chars - path_len + len(path_to_add) > env_size
      do too_much_quit
   endif
   
   if path_found
      make_path_last
      do kill_path
   endif
   if path_to_add = 'PATH=;'
      return
   endif

   get_env_size_chars
   path_start = no_env_chars - 2
   
   if path_start <> 0
      poke(env_seg, path_start+1, 0)
   endif
   i = path_start + 1
   j = 1
   do while i <= path_start+1 + len(path_to_add)
      poke(env_seg, i, asc(substr(path_to_add, j, 1)))
      i = i+1
      j = j+1
   enddo
   poke(env_seg, i+0, 0)
   poke(env_seg, i+1, 0)
endpro && new_path
*-------------------------------------------------------------------------
proc parse_cmdline                && <<<<<  PARSE_CMDLINE  >>>>>
   para char(255) cmdline
   vardef
      uint      p
   enddef
   type_to_add = ""
   path_to_add = ""
   quiet_mode = .f.
   cmdline = upper(alltrim(cmdline))
   p = iifn("/Q" $ cmdline, at("/Q", cmdline), at("-Q", cmdline))
   if p <> 0
      cmdline = stuff(cmdline, p, 1, "")
      cmdline = stuff(cmdline, p, 1, "")
      cmdline = alltrim(cmdline)
      quiet_mode = .t.
   endif
   if "/A" $ cmdline .or. "-A" $ cmdline
      p = iifn(at("/A", cmdline) <> 0, at("/A", cmdline), at("-A", cmdline))
      path_to_add = substr(cmdline, p+2, len(cmdline)-1)
      type_to_add = 'add_to_back'
   endif
   if "/P" $ cmdline .or. "-P" $ cmdline
      p = iifn(at("/P", cmdline) <> 0, at("/P", cmdline), at("-P", cmdline))
      path_to_add = substr(cmdline, p+2, len(cmdline)-1)
      type_to_add = 'add_to_front'
   endif
   if "/R" $ cmdline .or. "-R" $ cmdline
      p = iifn(at("/R", cmdline) <> 0, at("/R", cmdline), at("-R", cmdline))
      path_to_add = substr(cmdline, p+2, len(cmdline)-1)
      type_to_add = 'remove'
   endif
   if "/S" $ cmdline .or. "-S" $ cmdline
      type_to_add = 'save_path'
   endif
   if "=" $ cmdline
      p =  at("=", cmdline)
      path_to_add = 'PATH=' + substr(cmdline, p+1, len(cmdline)-1)
      type_to_add = 'make_new_path'
   endif
   if .not. isempty(path_to_add)
      path_to_add = alltrim(path_to_add)
      if right(path_to_add, 1) <> ";"
         path_to_add = path_to_add + ";"
      endif
      do while .t.
         p = at(" ", path_to_add)
         if p <> 0
            path_to_add = stuff(path_to_add, p, 1, "")
            loop
         endif
         exit
      enddo
   endif
endpro && parse_cmdline
*-------------------------------------------------------------------------
proc remove_path                  && <<<<<  REMOVE_PATH  >>>>>
   para const char(255) cmdline
   vardef
      uint      p, block_size, remove_start
      char(255) test_path
   enddef
   do get_path        && path_found,path_start,path_len,path_is_last,pth[256]
   if .not. path_found
      return
   endif
   make_path_last
   do get_path        && path_found,path_start,path_len,path_is_last,pth[256]
   block_size = len(path_to_add)
   path_found = .f.
   i = 0
   j = 0
   do while i <= path_len
      test_path = ""
      k = 1
      do while k <= block_size
         test_path = test_path + pth[j]
         j = j+1
         k = k+1
      enddo
      if path_to_add $ test_path
         path_found = .t.
         exit
      endif
      i = i+1
      j = j + 1 - block_size
   enddo
   if .not. path_found
      return
   endif
   remove_start = j - block_size + 1
   i = path_start + remove_start - 1
   j = i
   do while i <= j + path_len - remove_start - block_size + 1
      poke(env_seg, i, peek(env_seg, i + block_size))
      i = i+1
   enddo
   poke(env_seg, i+0, 0x0)
   poke(env_seg, i+1, 0x0)
endpro && remove_path
*-------------------------------------------------------------------------
proc save_path                    && <<<<<  SAVE_PATH  >>>>>
   vardef
      logical   first_time
   enddef
   if existing_path <> ""
      path_len = LEN( existing_path )
   else
      return
   endif
   if RIGHT( existing_path, 1 ) <> ";" .AND. path_len < 255
      existing_path = existing_path + ";"
      path_len = path_len + 1
   endif

   f_open(file_out, "c:\orglpath.bat", &f_create, &f_text)
   f_put(file_out, "@echo off"+CHR(13)+CHR(10) )

   first_time = .t.
   i = 1
   j = 1
   k = 1
   do while i <= path_len
      if ( substr( existing_path, i, 1 ) = ";" .and. j >= 40 ) .or. i = path_len
         if first_time
            first_time = .f.
            cmdline = "LPATH /q = "
         else
            cmdline = "LPATH /q /a "
         endif
         cmdline = cmdline + SUBSTR( existing_path, k, j )
         if .NOT. quiet_mode
            ? cmdline
         endif
         f_put( file_out, cmdline + CHR(13) + CHR(10) )
         k = i + 1
         j = 0
      endif
      i = i+1
      j = j+1
   enddo
   f_close(file_out)
   if .NOT. quiet_mode
      ?
      ? replicate("-",80)
   endif
endpro && save_path
*-------------------------------------------------------------------------
procedure force_main              && <<<<<  FORCE_MAIN  >>>>>
   para const char(255) original_line
   vardef
      ulong     psp
   enddef
   on error do error_proc

   cmdline = original_line
   existing_path = GETENV("PATH")

   set exact on
   if     "-H" $ upper(cmdline) .or. "/H" $ upper(cmdline) .or. ;
          "-?" $ upper(cmdline) .or. "/?" $ upper(cmdline)
      show_syntax
      quit
   endif

   psp = (peek(0,0xbb) * 0x100) + peek(0,0xba)             && 0ad2
   env_seg = (peek(psp, 0x2d) * 0x100) + peek(psp, 0x2c)   && 0b6c

   do parse_cmdline with cmdline
   do case
      case type_to_add = 'add_to_back'
         do change_path with cmdline
      case type_to_add = 'add_to_front'
         do change_path with cmdline
      case type_to_add = 'make_new_path'
         do new_path with cmdline
      case type_to_add = 'remove'
         do remove_path with cmdline
      case type_to_add = 'save_path'
         do save_path
   endcase

   if .NOT. quiet_mode
      do print_stats
   endif
   quit
endpro && force_main
*-------------------------------------------------------------------------

