@echo off
echo ------------------------------------------------------------
echo Exercise test utility program: test.exe
echo.
echo This test assumes test.exe is newer than test.c;
echo i.e., the timestamp of test.exe is more recent.
echo ------------------------------------------------------------
echo.
if not exist test.exe goto noTest
if not exist test.c goto noTest

REM Create/change tmp files/directories

attrib +r test.exe > nul
if errorlevel 1 echo attrib errorlevel
if not exist test.dir\nul md test.dir
type nul > zero

REM Test #1 *** Compare file lengths - IsSameSize(f1,f2) ***
test ! -S test.c test.exe
if errorlevel 1 echo test1  -OK-	!SameSize(f1,f2)
test -S test.c test.exe
if errorlevel 1 echo test1  *FAIL*	SameSize(f1,f2)

REM Test #2
test -S test.c test.c
if errorlevel 1 echo test2  -OK-	SameSize(f1,f2)

REM Test #3
test ! -S test.exe unknownfile
if errorlevel 1 echo test3  -OK-	different sizes [or not exist]
test -S test.exe unknownfile
if errorlevel 1 echo test3-FAIL: same file sizes

REM Test #4 *** Compare file time stamps - IsNewerThan(f1,f2) ***
test -N zero test.exe
if errorlevel 1 echo test4  -OK-	file1 is newer than file2

REM Test #5
test -N test.c test.exe
if errorlevel 1 goto err5
echo test5  -OK-	file1 is NOT newer than file2
goto test6
:err5
echo test5  *FAIL*	file1 is newer than file2

REM Test #6
:test6
test -D test.c test.exe
if errorlevel 1 echo test6  *FAIL*	same time stamps
test ! -D zero test.exe
if errorlevel 1 echo test6  -OK-	different time stamps

REM Test #7 *** Directory ***
test ! -d test.c
if errorlevel 1 echo test7  -OK-	file is not a directory

REM Test #8
test -d test.dir
if errorlevel 1 echo test8  -OK-	tmp is a directory

REM Test #9
test -m zero
if errorlevel 1 echo test9  -OK-	file has been modified

REM Test #10
test ! -m %COMSPEC%
if errorlevel 1 echo test10 -OK-	file is older than 1 day

REM Test #11 *** Zero file length ***
test -z zero
if errorlevel 1 echo test11 -OK-	ZeroLen(f1)
test ! -z zero
if errorlevel 1 echo test11 *FAIL*	!ZeroLen(f1)

REM Test #12
test ! -z test.exe
if errorlevel 1 echo test12 -OK-	!ZeroLen(f1)
test -z test.exe
if errorlevel 1 echo test12 *FAIL*	ZeroLen(f1)

pause

REM Test #13 *** Non-zero file length ***
test ! -s zero
if errorlevel 1 echo Test13 -OK-	ZeroLen(f1)

REM Test #14
test -s test.c
if errorlevel 1 echo Test14 -OK-	!ZeroLen(f1)

REM TEST #15 *** Executable files ***
test ! -x test.c
if errorlevel 1 echo test15 -OK-	file is not executable

REM TEST #16
test -x test.exe
if errorlevel 1 echo test16 -OK-	file is executable
test ! -x test.exe
if errorlevel 1 echo test16 *FAIL*	file is not executable

REM TEST #17
test -x %0.bat
if errorlevel 1 echo test17 -OK-	file is executable
test ! -x %0.bat
if errorlevel 1 echo test17 *FAIL*	file is not executable

REM Test #18 *** Writable/read-only files ***
test ! -w test.exe
if errorlevel 1 echo test18 -OK-	file is read-only
test -w test.exe
if errorlevel 1 echo test18 *FAIL*	file is writable

REM Test #19
test -w test.c
if errorlevel 1 echo test19 -OK-	file is writable
test ! -w test.c
if errorlevel 1 echo test19 *FAIL*	file is read-only

REM Test #20 *** Regular file ***
test ! -f nul
if errorlevel 1 echo test20 -OK-	file is a special file
test -f nul
if errorlevel 1 echo test20 *FAIL*	file is a regular file

REM Test #21
test -f test.exe
if errorlevel 1 echo test21 -OK-	file is a regular file

REM Test #22 *** Block special ***
test -b nul
if errorlevel 1 echo test22 -OK-	file is a block special file

REM Test #23
test ! -b test.exe
if errorlevel 1 echo test23 -OK-	file is not a block special file

REM Test #24 *** Character special ***
test -c nul
if errorlevel 1 echo test24 -OK-	file is a character special file.

REM Test #25
test ! -c test.exe
if errorlevel 1 echo test25 -OK-	file is not a character special file

REM Test #26 *** Logical or ***
test -d test.c -o -z zero
if errorlevel 1 goto ok26
echo test26 *FAIL*	!IsAdir(f1) and !ZeroLen(f2)
goto test27
:ok26
echo test26 -OK-	IsAdir(f1) or ZeroLen(f2)

REM Test #27
:test27
test -d test.c -o -z test.c
if errorlevel 1 echo test27 *FAIL*	IsAdir(f1) or ZeroLen(f2)
test ! -d test.c -o ! -z test.c
if errorlevel 1 echo test27 -OK-	!IsAdir(f1) and !ZeroLen(f2)

REM Test #28 *** Logical AND ***
test -w test.c -a ! -z test.c
if errorlevel 1 echo test28 -OK-	file1 is writable and !ZeroLen(file2)

REM Test #29
test -w test.c -a -z zero
if errorlevel 1 goto ok29
echo test29 *FAIL*	ReadOnly(file1) or !ZeroLen(file2)
goto test30
:ok29
echo test29 -OK-	writable(f1) and ZeroLen(f2)

REM Test #30
:test30
test -d test.dir -z zero -o -S test.c test.exe
if errorlevel 1 goto ok30
echo test30 *FAIL*	expression false
goto test31
:ok30
echo test30 -OK-	expression true

REM Test #31
:test31
test
if errorlevel 1 goto err31
echo test31 -OK-	no arguments
goto done
:err31
echo test31 *FAIL*	no arguments

:done
echo.
echo All tests numbered from 1-31 should appear with OK status!

REM *** Clean up new or changed files ***
:clean
attrib -r test.exe > nul
del zero > nul
rd test.dir
goto end

:noTest
echo Error: Missing required program(s).  The files 'test.exe' or 'test.c'
echo        must be located in this directory for test to complete.
echo.
echo        DOS attrib command must be in path.
:end
