Option Explicit
DefInt A-Z
' Type defs for bitmaps
Type BMPHEAD
    ID As String * 2
    FileSize As Long
    reserved(1) As Integer
    HeaderSize As Long
End Type

Type BITMAPINFOHEADER
    biSize As Long
    biWidth As Long
    biHeight As Long
    biPlanes As Integer
    biBitCount As Integer
    biCompression As Long
    biSizeImage As Long
    biXPelsPerMeter As Long
    biYPelsPerMeter As Long
    biClrUsed As Long
    BiClrImportant As Long
End Type

Type BITMAPINFO
    bmiHeader As BITMAPINFOHEADER
    bmiColors As String * 1024
End Type

' Type defs for CUT Files
Type CUTHEAD
    Width As Integer
    Height As Integer
    Key As Integer
End Type
	  
' Type defs for GIF files
Type GIFHEADER
    GIF As String * 6
    Width As Integer
    Height As Integer
    Flags As String * 1
    Background As String * 1
    Aspect As String * 1
End Type

Type IMAGEBLOCK
    left As Integer
    top As Integer
    Width As Integer
    Height As Integer
    Flags As String * 1
End Type

Type PLAINTEXT
    BlockSize As String * 1
    left As Integer
    top As Integer
    GridWidth As Integer
    GridHeight As Integer
    CellWidth As String * 1
    CellHeight As String * 1
    ForeColor As String * 1
    BackColor As String * 1
End Type

Type CONTROLBLOCK
    BlockSize As String * 1
    Flags As String * 1
    Delay As Integer
    TransParent_Color As String * 1
    Terminator As String * 1
End Type

Type APPLICATION
    BlockSize As String * 1
    ApplString As String * 8
    Authentication As String * 3
End Type

' Type def for IFF/LBM files
Type IFFHEAD
    Ftype As String * 4
    Size As String * 4
    SubType As String * 4
End Type

Type BMHD
    W As String * 2
    H As String * 2
    X As String * 2
    Y As String * 2
    nPlanes As String * 1
    Masking As String * 1
    Compression As String * 1
    Pad1 As String * 1
    TransparentColor As String * 2
    XAspect As String * 1
    YAspect As String * 1
    PageW As String * 2
    PageH As String * 2
End Type

' Type defs for IMG files
Type IMGHEAD
    Key As String * 3
    Flag As String * 1
    Pad1 As String * 1
    Bits As String * 1
    Pad2 As String * 6
    Width As String * 2
    Height As String * 2
End Type

' Type defs for MAC files
Type MACHEAD
    ZeroByte As String * 1
    Name As String * 64
    Type As String * 4
    Creator As String * 4
    Filler As String * 10
    DataFork_Size As String * 4
    RsrcFork_Size As String * 4
    Creation_Date As String * 4
    Modif_Date As String * 4
    Filler2 As String * 29
End Type

' Type def for MSP files
Type MSPHEAD
    Key1 As Integer
    Key2 As Integer
    Width As Integer
    Height As Integer
    ScrAspX As Integer
    ScrAspY As Integer
    PrnAspX As Integer
    PrnAspY As Integer
    PrndX As Integer
    PrndY As Integer
    Wcheck As Integer
    Res1 As Integer
    Res2 As Integer
    Res3 As Integer
End Type

' Type def for PCX files
Type PCXHEAD
    Manufacturer As String * 1
    Version As String * 1
    Encoding As String * 1
    Bits_Per_Pixel As String * 1
    XMin As Integer
    YMin As Integer
    XMax As Integer
    YMax As Integer
    HRes As Integer
    VRes As Integer
    Palette As String * 48
    reserved As String * 1
    Color_Planes As String * 1
    Bytes_Per_Line As Integer
    Palette_Type As Integer
    Filler As String * 58
End Type

' Type def for PIC files
Type PICHEAD
    Mark As Integer
    XSize As Integer
    YSize As Integer
    XOff As Integer
    YOff As Integer
    BitsInf As String * 1
    Emark As String * 1
    EVideo As String * 1
    EDesc As Integer
    ESize As Integer
End Type

' Type def for TGA files
Type TGAHEAD
    IdentSize As String * 1
    ColorMapType As String * 1
    ImageType As String * 1
    ColorMapStart As Integer
    ColorMapLength As Integer
    ColorMapBits As String * 1
    XStart As Integer
    YStart As Integer
    Width As Integer
    Height As Integer
    Bits As String * 1
    Descriptor As String * 1
End Type

' Type def for TIF files
Type TIFFTAG
    Tag As Long
    Type As Long
    Length As Long
    Offset As Long
End Type

' Type defs for WMF files
Type RECT
    left As Integer
    top As Integer
    right As Integer
    bottom As Integer
End Type

Type METAFILEHEADER
    Key As Long
    HMF As Integer
    bbox As RECT
    inch As Integer
    reserved As Long
    checksum As Integer
End Type

Type METAHEADER
    mtType As Integer
    mtHeaderSize As Integer
    mtVersion As Integer
    mtSize As Long
    mtNoObjects As Integer
    mtMaxRecord As Long
    mtNoParameters As Integer
End Type

' Type defs for WPG files
Type WPGHEAD
    ID As String * 4
    Start As Long
    Product As String * 1
    Filetype As String * 1
    MajorVersion As String * 1
    Minorversion As String * 1
    Encrypt As Integer
    reserved As Integer
End Type

Type STARTRECORD
    Version As String * 1
    Flags As String * 1
    ScreenWidth As Integer
    ScreenHeight As Integer
End Type

Type COLORMAP
    StartIndex As Integer
    PalleteSize As Integer
End Type

Type BITMAP
    Width As Integer
    Height As Integer
    Bits As Integer
    XResolution As Integer
    YResolution As Integer
End Type
	  
' Type defs for displaying logical fonts
Type LOGFONT
    lfHeight As Integer
    lfWidth As Integer
    lfEscapement As Integer
    lfOrientation As Integer
    lfWeight As Integer
    lfItalic As String * 1
    lfUnderline As String * 1
    lfStrikeOut As String * 1
    lfCharSet As String * 1
    lfOutPrecision As String * 1
    lfClipPrecision As String * 1
    lfQuality As String * 1
    lfPitchAndFamily As String * 1
    lfFaceName As String * 32
End Type

Type TEXTMETRIC
    tmHeight As Integer
    tmAscent As Integer
    tmDescent As Integer
    tmInternalLeading As Integer
    tmExternalLeading As Integer
    tmAveCharWidth As Integer
    tmMaxCharWidth As Integer
    tmWeight As Integer
    tmItalic As String * 1
    tmUnderlined As String * 1
    tmStruckOut As String * 1
    tmFirstChar As String * 1
    tmLastChar As String * 1
    tmDefaultChar As String * 1
    tmBreakChar As String * 1
    tmPitchAndFamily As String * 1
    tmCharSet As String * 1
    tmOverhang As Integer
    tmDigitizedAspectX As Integer
    tmDigitizedAspectY As Integer
End Type

Global Const BITSPIXEL = 12
Global Const GMEM_MOVEABLE = &H2
Global Const HORZRES = 8
Global Const LB_SETTABSTOPS = &H413
Global Const MM_ANISOTROPIC = 8
Global Const PLANES = 14
Global Const RASTERCAPS = 38
Global Const SRCCOPY = &HCC0020
Global Const VERTRES = 10


Declare Function CreateCompatibleDC% Lib "GDI" (ByVal hDC%)
Declare Function CreateFontIndirect% Lib "GDI" (lpLogFont As LOGFONT)
Declare Function DeleteDC% Lib "GDI" (ByVal hDC%)
Declare Function DeleteMetaFile% Lib "GDI" (ByVal HMF%)
Declare Function DeleteObject% Lib "GDI" (ByVal hObject%)
Declare Function GetDeviceCaps% Lib "GDI" (ByVal hDC%, ByVal nIndex%)
Declare Function GetMetaFile% Lib "GDI" (ByVal lpFilename$)
Declare Function GetTextMetrics% Lib "GDI" (ByVal hDC%, lpMetrics As TEXTMETRIC)
Declare Function GlobalAlloc% Lib "Kernel" (ByVal wFlags%, ByVal dwBytes&)
Declare Function GlobalFree% Lib "Kernel" (ByVal hMem%)
Declare Function GlobalLock& Lib "Kernel" (ByVal hMem%)
Declare Function GlobalUnlock% Lib "Kernel" (ByVal hMem%)
Declare Function lread% Lib "Kernel" Alias "_lread" (ByVal hFile%, ByVal lpBuffer&, ByVal wBytes%)
Declare Function PlayMetaFile% Lib "GDI" (ByVal hDC%, ByVal HMF%)
Declare Function RestoreDC% Lib "GDI" (ByVal hDC%, ByVal nSavedDC%)
Declare Function SaveDC% Lib "GDI" (ByVal hDC%)
Declare Function SelectObject% Lib "GDI" (ByVal hDC%, ByVal hObject%)
Declare Function SendMessage% Lib "User" (ByVal hWnd%, ByVal Msg%, ByVal wParma%, lParam%)
Declare Function SetMapMode% Lib "GDI" (ByVal hDC%, ByVal nMapMode%)
Declare Function SetViewportExt& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function SetViewportOrg& Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%)
Declare Function StretchBlt% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal nWidth%, ByVal nHeight%, ByVal hSrcDC%, ByVal XSrc%, ByVal YSrc%, ByVal nSrcWidth%, ByVal nSrcHeight%, ByVal dwRop&)
Declare Function TextOut% Lib "GDI" (ByVal hDC%, ByVal X%, ByVal Y%, ByVal lpString$, ByVal nCount%)

Declare Function ReadBMP% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadCUT% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadGIF% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%, ByVal lpoffset&)
Declare Function ReadIFF% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadIMG% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadMAC% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadMSP% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadPCX% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadPIC% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadTGA% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadTIF% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)
Declare Function ReadWPG% Lib "\vb\demos\file.dll" (ByVal hfilename$, ByVal hDC%, ByVal hWnd%, ByVal hDither%, ByVal hPrint%, ByVal X%, ByVal Y%, ByVal hScale%)

