Option Explicit
   Type RECT
      left As Integer
      top As Integer
      right As Integer
      bottom As Integer
   End Type
    
   Type Size
      cx As Integer
      cy As Integer
   End Type
   
   Type POINTAPI
      X As Integer
      y As Integer
   End Type
   
   Declare Function PlayMetafile% Lib "GDI" (ByVal hDC%, ByVal hmf%)
   Declare Function SetMapMode Lib "GDI" (ByVal hDC As Integer, ByVal nMapMode As Integer) As Integer
   Declare Function SetViewPortExt Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal y As Integer) As Long
   Declare Function SetViewPortExtEx Lib "GDI" (ByVal hDC As Integer, ByVal nX As Integer, ByVal nY As Integer, lpSize As Size) As Integer
   Declare Function SetViewPortOrg Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal y As Integer) As Long
   Declare Function SetViewPortOrgEx Lib "GDI" (ByVal hDC As Integer, ByVal nX As Integer, ByVal nY As Integer, lpPoint As POINTAPI) As Integer
   Declare Function ScaleViewPortExtEx% Lib "GDI" (ByVal hDC%, ByVal nXnum%, ByVal nXdenom%, ByVal nYnum%, ByVal nYdenom%, lpSize As Size)
   Declare Function GetViewportExtEx Lib "GDI" (ByVal hDC As Integer, lpSize As Size) As Integer
   Declare Function SetWindowExt Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal y As Integer) As Long
   Declare Function SetWindowExtEx Lib "GDI" (ByVal hDC As Integer, ByVal nX As Integer, ByVal nY As Integer, lpSize As Size) As Integer
   Declare Function SetWindowOrg Lib "GDI" (ByVal hDC As Integer, ByVal X As Integer, ByVal y As Integer) As Long
   Declare Function SetWindowOrgEx Lib "GDI" (ByVal hDC As Integer, ByVal nX As Integer, ByVal nY As Integer, lpPoint As POINTAPI) As Integer
   
   Global Const MM_ISOTROPIC = 7

Function Printgraph (source As Control, originx As Integer, originy As Integer, rightx As Integer, bottomy As Integer) As Integer
      
    '*****************************************************************
    '*  PrintGraph accepts parameters and then prints Graph or a picture
    '*  containing a metafile to the printer
    '*
    '*     source  - accepts a Graph or picture control containing a
    '*               metafile to be printed to the printer
    '*
    '*     originx, originy - specifies the x and y coordinates of the
    '*                        origin of the output area (in Pixels)
    '*
    '*     rightx, bottomy - specifies the right and bottom of the
    '*                       output area (in Pixels)
    '*
    '********************************************************************
    Dim pagewidth%, pageheight%, oldmapmode%
    Dim success%, ApiError%, successl&
    Dim scalingx%, scalingy%
    Dim lpold_vpextent As Size
    Dim lpold_winextent As Size
    Dim lpoldsize As Size
    Dim lpDrawTextRect As RECT
    Dim lpoldwindoworg  As POINTAPI
    Dim lpoldvieworg  As POINTAPI
    
    
    On Error GoTo handler

      ' Display hour glass:
        screen.MousePointer = 11
        ' Initialize the printer object's hDC from VB's perspective:
        printer.Print " "
        printer.ScaleMode = 3  ' pixels equivalent to MM_TEXT
        pagewidth% = printer.ScaleWidth
        pageheight% = printer.ScaleHeight
        
        scalingx = rightx - originx
        scalingy = bottomy - originy
        
        oldmapmode% = SetMapMode(printer.hDC, MM_ISOTROPIC)
        ' Make logical units equal to device units:
        ' The SDK recommends that this be done when using MM_ISOTROPIC:
        success% = SetWindowOrgEx(printer.hDC, 0, 0, lpoldwindoworg)
        
        
        success% = SetWindowExtEx(printer.hDC, pagewidth%, pageheight%, lpold_winextent)
        success% = SetViewPortOrgEx(printer.hDC, originx, originy, lpoldvieworg)
        success% = SetViewPortExtEx(printer.hDC, 1, 1, lpold_vpextent)
        success% = ScaleViewPortExtEx(printer.hDC, scalingx, 1, scalingy, 1, lpoldsize)
        
        
        ' Send the metafile to the target hDC:
        ApiError% = PlayMetafile(printer.hDC, source.Picture)
        If ApiError% = 0 Then
        MsgBox "PlayMetaFile failed"
        Printgraph = False
        End If
        
        ' Reset device context to initial values:
        successl& = SetWindowOrg(printer.hDC, lpoldwindoworg.X, lpoldwindoworg.y)
        successl& = SetWindowExt(printer.hDC, lpold_winextent.cx, lpold_winextent.cy)
        successl& = SetViewPortOrg(printer.hDC, lpoldvieworg.X, lpoldvieworg.y)
        successl& = SetViewPortExt(printer.hDC, lpold_vpextent.cx, lpold_vpextent.cy)
        
        oldmapmode% = SetMapMode(printer.hDC, oldmapmode%)
        
        Printgraph = True
        
        
        screen.MousePointer = 0
    Exit Function

handler:
      
      MsgBox "Function PrintMetafile has failed with error number " & Trim(Str(Err)) & " - recheck your parameters"

      screen.MousePointer = 0
      Printgraph = False
      Exit Function

End Function

