VERSION 2.00
Begin Form Form1 
   Caption         =   "File Association Example"
   ClientHeight    =   1470
   ClientLeft      =   1695
   ClientTop       =   3390
   ClientWidth     =   5430
   Height          =   1875
   Icon            =   0
   Left            =   1635
   LinkTopic       =   "Form1"
   ScaleHeight     =   1470
   ScaleWidth      =   5430
   Top             =   3045
   Width           =   5550
   Begin Label Label2 
      Height          =   315
      Left            =   480
      TabIndex        =   1
      Top             =   285
      Width           =   4440
   End
   Begin Label Label1 
      BorderStyle     =   1  'Fixed Single
      Height          =   285
      Left            =   420
      TabIndex        =   0
      Top             =   870
      Width           =   4560
   End
End
DefInt A-Z

' Registration Database (REG.DAT) functions.
' (Requires Windows 3.1+, or 3.0 with SHELL.DLL.)
'
Declare Function RegCloseKey& Lib "Shell.dll" (ByVal hkey&)
Declare Function RegCreateKey& Lib "Shell.dll" (ByVal hkey&, ByVal lpszSubKey$, lphKey&)
Declare Function RegDeleteKey& Lib "Shell.dll" (ByVal hkey&, ByVal lpszSubKey$)
Declare Function RegOpenKey& Lib "Shell.dll" (ByVal hkey&, ByVal lpszSubKey$, lphKey&)
Declare Function RegQueryValue& Lib "Shell.dll" (ByVal hkey&, ByVal lpszSubKey$, ByVal lpszValue$, dwLength&)
Declare Function RegSetValue& Lib "Shell.dll" (ByVal hkey&, ByVal lpszSubKey$, ByVal fdwType&, ByVal lpszValue$, ByVal dwLength&)

' Private initialization file (.INI) functions.
'
Declare Function GetPrivateProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpDefault$, ByVal lpRetString$, ByVal nSize%, ByVal lpFileName$)
Declare Function WritePrivateProfileString% Lib "Kernel" (ByVal lpAppName$, ByVal lpKeyName$, ByVal lpString As Any, ByVal lpFileName$)


''' Written by Lou A. Moccia (thescree@aol.com), 10/94.
''' Released "as-is" and shared freely with all fellow
''' VB-WIN programmers.
''' The REG.DAT code presented here was worked out through
''' a bit of trial-and-error, because I could not find this
''' info for VB anywhere, not even that popular "guide to
''' the Windows API" book for VB.  I do have to give some
''' credit to the Windows SDK Help file included with VB3,
''' however shame on Microsoft for only providing dreaded
''' C examples!
''' Anyway, I hope you find this code useful!

Sub Form_Load ()


Extension$ = "TXT"

Label2.Caption = "Current association for """ & Extension$ & """ files:"

Label1.Caption = Get_Association$(Extension$)


End Sub

'--------------------------------------------------------------------------------------
' Returns the association for the specified file extension. The Registration
' Database (REG.DAT) file is accessed first by a file utility like File Manager
' when it attempts to launch a document file, so here REG.DAT is checked for the
' association first. If nothing is found there, then the [Extensions] section
' of the WIN.INI file is checked.
'
' Extension$ = The file extension to check for an association.
'              Sample form:  "txt"
'              Do not include a period before the extension.
'
' Returns:  The full association string, or an empty string if not found.
'           Sample return from REG.DAT:  "c:\windows\notepad.exe %1"
'           Sample return from WIN.INI:  "c:\windows\notepad.exe ^.txt"
'           It will be up to you to parse off the %1 or ^.xxx part if desired.
'--------------------------------------------------------------------------------------
Function Get_Association$ (Extension$)

Get_Association$ = ""
Ext$ = "." & Extension$
tmp$ = Space$(256)
cb& = Len(tmp$)
On Error Resume Next
r& = RegOpenKey(1, Ext$, lphKey&)
If r& = 0& Then
    r1& = RegQueryValue(lphKey&, "shell\open\command", tmp$, cb&)
    ' If no error and the length of the returned string is greater than 1 (a null
    ' is always returned), get the string up to the null and trim it.
    If r1& = 0& And cb& > 1 Then Get_Association$ = Trim$(Left$(tmp$, cb& - 1))
    r1& = RegCloseKey(lphKey&)
Else
    ret% = GetPrivateProfileString("Extensions", Extension$, "", tmp$, Len(tmp$), "WIN.INI")
    ' If the returned string is greater than 5 (the end part ^.xxx),
    ' get the string and trim it.
    If ret% > 5 Then Get_Association$ = Trim$(Left$(tmp$, ret%))
End If

End Function

'--------------------------------------------------------------------------------------
' Updates an association in the Registration Database (REG.DAT) file and
' in the [Extensions] section of the WIN.INI file for the specified file
' extension, just like File Manager does.
'
' Extension$ = The file extension to associate or disassociate.
'              Sample form:  "txt"
'              Do not include a period before the extension.
'
' Application$ = To associate, the application command.
'                Sample form:  "c:\windows\notepad.exe"
'                To disassociate, an empty string.
'
' Description$ = Optional description of the file extension, used
'                in REG.DAT. Really only useful to yourself.
'                Sample text:  "Text Files"
'                Empty string for no description.
'
' If does not matter if the association already exists or not.
'--------------------------------------------------------------------------------------
Sub Set_Association (Extension$, Application$, Description$)

Ext$ = "." & Extension$
If Len(Application$) = 0 Then
    ret% = WritePrivateProfileString("Extensions", Extension$, 0&, "WIN.INI")
    r& = RegOpenKey(1, "", lphKey&)
    If r& = 0& Then r1& = RegDeleteKey(lphKey&, Ext$)
Else
    Association$ = Application$ & " ^." & Extension$
    ret% = WritePrivateProfileString("Extensions", Extension$, Association$, "WIN.INI")
    r& = RegCreateKey(1, Ext$, lphKey&)
    If r& = 0& Then
        r1& = RegSetValue(lphKey&, "", 1, Description$, 0&)
        Association$ = Application$ & " %1"
        r1& = RegSetValue(lphKey&, "shell\open\command", 1, Association$, 256&)
    End If
End If
If r& = 0& Then r1& = RegCloseKey(lphKey&)

End Sub

