//
//  Copyright (C) 1994 by
//  HITAM Software, St. Louis, MO, USA
//  All Rights Reserved.
//
//  This software is furnished under a license and may be used and copied
//  only in accordance of the terms of such license and with the
//  inclusion of the above copyright notice. This software or any other
//  copies thereof may not be provided or otherwise made available to any
//  other person. No title to and ownership of the software is hereby
//  transferred.
//
//  The information in this software is subject to change without notice
//  and should not be construed as a commitment by HITAM Software
//
//  HITAM Software assumes no responsibility for
//  the use or reliability of its software on equipment which is not
//  supplied by HITAM Software
//
//  FACILITY: DEMO_CPP
//
//  ABSTRACT:
//
//     These files comprise the C++ demonstration program for showing the              
//     capabilities of the SPLASH Libraries. Code is Microsoft C++ built               
//     using the Microsoft Foundation Class Library V2.5 with Microsoft                
//     Visual C++ V1.5. Code is compatible in 16 bit Windows and 32 bit                
//     Windows.                                                                        
//                                                                                     
//     Dependancies:                                                                   
//                   SPLASHxx.LIB   Import Library for Windows                         
//                   SPLASHxx.DLL   Run-Time Library for Windows                       
//                   SPLASH.H       SPLASH Libraries Header File                       
//                   RESOURCE.H     Application Constants                              
//                   DEMO_CPP.DEF   Module Definition File                             
//
//  AUTHOR(S): Todd Osborne (HITAM Software)
//
//  CREATED: 06/15/94
//
//  MODIFICATION HISTORY:
//
//  Version Date        By      Reason
//

#include <afxwin.h>
#include "resource.h"
#include "demo_cpp.h"
#include "splash.h"

CTheApp ThisApp;

BOOL CTheApp::InitInstance()
{
	// Create main dialog box window and show m_strAPPTITLE in caption bar
	m_pMainWnd = new CMainDlgWindow();
	
	if ( m_pMainWnd != NULL )
	{
		#ifdef _WIN32
			m_pMainWnd->SetWindowText("SPLASH32.DLL Demo for C/C++");
		#else
			m_pMainWnd->SetWindowText("SPLASH16.DLL Demo for C/C++");
		#endif
		
		// Set application (window) icon
		SetClassWord(m_pMainWnd->m_hWnd, GCW_HICON, (WORD)LoadIcon(IDI_APPLICATION));
	
		return TRUE;
	}
	else
		return FALSE;
}

CMainDlgWindow::CMainDlgWindow()
{
	//{{AFX_DATA_INIT(CMainDlgWindow)
	
	// We can use the help file path as a start for the default file
	// Parse it to last backslash and add "SPLASH.BMP"
	m_strSplashFileName = App.m_pszHelpFilePath;
	m_strSplashFileName = m_strSplashFileName.Mid(0, m_strSplashFileName.ReverseFind('\\') + 1) + "SPLASH.BMP";
	m_nHowLong = 1;
	m_nWhichDLL = 0;
	//}}AFX_DATA_INIT
	
	// Create the Main Dialog Window
	Create(IDD_MAIN);
}

// ***** MESSAGE HANDLERS ******

BOOL CMainDlgWindow::OnCommand(WPARAM wParam, LPARAM lParam)
{
	// Handle messages before message map
	// This is where we trap buton clicks to call DLL
	// The button ID's for the AccuSoft functions are between 100 - 110
	// Button ID 111 is used to show splash using normal bitmap loading techniques (No AccuSoft DLL's are needed)
	
	if ( LOWORD(lParam) != 0 && HIWORD(lParam) == BN_CLICKED )
	{
		// Call DDX routine to get data from screen into member vars
		UpdateData(TRUE);
		
		// The wParam is the control ID that sent the message
		// Subtract 100 from the control ID and call ShowSplashAnyFormat for values 0-10
		// Call ShowSplashFromFile for 11 and ShowSplashFromResource for 12
		
		int nButton = wParam - 100;
		
		char* psz = m_strSplashFileName.GetBuffer(m_strSplashFileName.GetLength());
		
		if ( nButton >= 0 && nButton <=10 )
			// This will show the splash screen using AccuSoft DLL(s). These DLL's are capable
			// of more than 16 color displays and can produce interesting visual effects.
			// Contact AccuSoft for more information.
			ShowSplashAnyFormat(psz, nButton, (m_nWhichDLL == 0 ) ? "ACCUSOFT.DLL" : "ACCU32IF.DLL", m_nHowLong);
			
		else if ( nButton == 11 )
			// This will show the splash screen by passing the name of a Windows bitmap (BMP)
			// file. This routine currently supports up to 16 colors. No additional DLL's are
			// needed.
			ShowSplashFromFile(psz, m_nHowLong);
		
		else if ( nButton == 12 )
			// This will show the splash screen by passing the name of a resource embedded in
			// the calling program. This routine currently supports up to 16 colors. No additional
			// DLL's are needed. This is not available to languages and applications that do not
			// store their resources within their EXE or DLL. Sorry VB guys!
			ShowSplashFromResource(AfxGetInstanceHandle(), "IDB_SPLASH", m_nHowLong);
				
		m_strSplashFileName.ReleaseBuffer();
	
		// End the splash screen
		EndSplash();
	}	
			
	// Do default processing of this message
	CWnd::OnCommand(wParam, lParam);
	
	return 1;
}

void CMainDlgWindow::OnCancel()
{
	// Override default processing that closes window
}

void CMainDlgWindow::OnClose()
{
	DestroyWindow();
}

void CMainDlgWindow::PostNcDestroy()
{
	// Destroy this dialog box pointer
	delete this;

	// Tell Windows to shut us down
	::PostQuitMessage(0);
}

BOOL CMainDlgWindow::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	// Center this window on screen
	CenterWindow();
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CMainDlgWindow::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CMainDlgWindow)
	DDX_Text(pDX, IDC_EDIT1, m_strSplashFileName);
	DDX_CBIndex(pDX, IDC_COMBO1, m_nHowLong);
	DDX_Radio(pDX, IDC_RADIO1, m_nWhichDLL);
	//}}AFX_DATA_MAP
}

void CMainDlgWindow::KillTime(int nHowLong)
{
	// Loop for nHowLong seconds
	DWORD CurTime = GetCurrentTime();	// This is in milliseconds (since Windows started)
	while ( GetCurrentTime() < CurTime + (nHowLong * 1000) );
}

BEGIN_MESSAGE_MAP(CMainDlgWindow, CDialog)
	//{{AFX_MSG_MAP(CMainDlgWindow)
	ON_WM_CLOSE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()
