#ifndef _SPLASH_H
#define _SPLASH_H

//
//  Copyright (C) 1994 by
//  HITAM Software, St. Louis, MO, USA
//  All Rights Reserved.
//
//  This software is furnished under a license and may be used and copied
//  only in accordance of the terms of such license and with the
//  inclusion of the above copyright notice. This software or any other
//  copies thereof may not be provided or otherwise made available to any
//  other person. No title to and ownership of the software is hereby
//  transferred.
//
//  The information in this software is subject to change without notice
//  and should not be construed as a commitment by HITAM Software.
//
//  HITAM Software assumes no responsibility for
//  the use or reliability of this software on equipment which is not
//  supplied by HITAM Software.
//
//  FACILITY: General Windows Functionality
//
//  ABSTRACT:
//
//     SPLASH.C and SPLASH.H are used to create a splash, or startup,                  
//     screen that is displayed while another program is initializing. This              
//     gives users immediate feedback and an indication that the                       
//     application is starting properly.                                                        
//                                                                                     
//     SPLASH16.DLL is the 16 bit Windows Version.                                     
//     SPLASH32.DLL is the 32 bit Windows Version. (Not included w/o registration)
//     SPLASH16.LIB is the import library for SPLASH16.DLL                             
//     SPLASH32.LIB is the import library for SPLASH32.DLL (Not included w/o registration)                            
//     SPLASH.H     is the header file for both 16 and 32 bit versions.                
//                                                                                     
//     SPLASHxx.DLL supports standard SDK painting functions for drawing               
//     splash screens based on bitmap files (BMP) and bitmap resources                 
//     embedded in the calling program. In addition, it supports the                   
//     ACCUSOFT.DLL and ACCUGOLD.DLL from AccuSoft. This allows display of             
//     splash screens with more than 16 colors and special effects.                     
//                                                                                     
//     Currently, SPLASHxx.DLL supports 16 colors for internal functions.              
//     ShowSplashAnyFormat uses the AccuSoft DLL(s) and is capable of more             
//     than 16 colors.                                                                 
//                                                                                     
//     See README.TXT for more information                                             
//
//  AUTHOR(S): Todd Osborne
//
//  CREATED: 06/08/94
//
//  MODIFICATION HISTORY:
//
//  Version Date        By      Reason
//

// To show a splash bitmap from a bitmap resource in a DLL or EXE file, pass
// ShowSplashFromResource the instance handle of the DLL or EXE, the null
// terminated string of the bitmap resource to load, and the number of seconds
// to show the splash screen.

// To show a splash bitmap from a file (any format) pass the null terminated
// filename, effect constant, the name of the DLL provided by AccuSoft and the number of
// seconds to show the splash screen to ShowSplashAnyFormat. You will need to have the
// appropriate DLL from AccuSoft to do this.
// For ACCUGOLD.DLL, pass ACCU32IF.DLL as the 3rd parameter. If you are using the basic
// ACCUSOFT.DLL, pass this instead.

// To show a splash bitmap from a Windows bitmap file (BMP) pass the null terminated
// filename to ShowSplashFromFile, and the number of seconds to show the splash screen.
// No additonal DLL's (other than SPLASHxx.DLL) are required to perform this operation.

#ifdef __cplusplus
extern "C" {
#endif

BOOL FAR PASCAL _export ShowSplashFromFile(char FAR* lpszFileName, UINT nWait);
BOOL FAR PASCAL _export ShowSplashAnyFormat(char FAR* lpszFileName, int Effect,char FAR* lpszAccuSoftDLLName, UINT nWait);
BOOL FAR PASCAL _export ShowSplashFromResource(HINSTANCE hInstance, char far* lpszBitmap, UINT nWait);
void FAR PASCAL _export EndSplash();

#ifdef __cplusplus
}
#endif

// Effects that can be passed as second parameter to SPLASH.EXE
#define NO_EFFECT       0
#define TOP_WIPE        1
#define BOTTOM_WIPE     2
#define LEFT_WIPE       3
#define RIGHT_WIPE      4
#define BLINDS          5
#define BLOCKS          6
#define CENTER          7
#define LOUVERS         8
#define SQUAREOUT       9
#define ZIGZAG          10

#endif

