VERSION 2.00
Begin Form fEZPrint 
   BackColor       =   &H00C0C0C0&
   BorderStyle     =   3  'Fixed Double
   Caption         =   "Replacement for the Printer Object"
   ClientHeight    =   6525
   ClientLeft      =   1065
   ClientTop       =   465
   ClientWidth     =   7335
   Height          =   6990
   Left            =   975
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   6525
   ScaleWidth      =   7335
   Top             =   90
   Width           =   7515
   Begin CommandButton cmdPrint 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Print"
      Enabled         =   0   'False
      Height          =   330
      Left            =   5985
      TabIndex        =   11
      Top             =   105
      Width           =   1065
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Mail Merge"
      Height          =   540
      Index           =   7
      Left            =   210
      TabIndex        =   10
      Top             =   5775
      Width           =   1905
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&Indent"
      Height          =   540
      Index           =   6
      Left            =   210
      TabIndex        =   9
      Top             =   5145
      Width           =   1905
   End
   Begin vsViewPort vsViewPort1 
      BackColor       =   &H00808080&
      Height          =   5895
      Left            =   2415
      Top             =   525
      VirtualHeight   =   0
      VirtualWidth    =   0
      Width           =   4635
      Begin vsPrinter VSPrinter1 
         AbortCaption    =   ""
         BackColor       =   &H00FFFFFF&
         FontName        =   "Arial"
         FontSize        =   40
         HdrFontBold     =   -1  'True
         HdrFontName     =   "Courier New"
         HdrFontSize     =   14
         Height          =   4005
         Left            =   210
         Top             =   210
         Width           =   2850
      End
   End
   Begin ComboBox cmbZoom 
      Enabled         =   0   'False
      Height          =   300
      Left            =   3780
      Style           =   2  'Dropdown List
      TabIndex        =   7
      Top             =   105
      Width           =   960
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "&AlignText"
      Height          =   540
      Index           =   5
      Left            =   210
      TabIndex        =   6
      Top             =   4515
      Width           =   1905
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Draw"
      Height          =   540
      Index           =   4
      Left            =   210
      TabIndex        =   5
      Top             =   3885
      Width           =   1905
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Multi-Columns"
      Height          =   540
      Index           =   3
      Left            =   210
      TabIndex        =   3
      Top             =   2625
      Width           =   1905
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Tables"
      Height          =   540
      Index           =   2
      Left            =   195
      TabIndex        =   2
      Top             =   3255
      Width           =   1905
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Paragraph"
      Height          =   540
      Index           =   1
      Left            =   210
      TabIndex        =   1
      Top             =   1995
      Width           =   1905
   End
   Begin CommandButton Command1 
      BackColor       =   &H00C0C0C0&
      Caption         =   "Line by Line"
      Height          =   540
      Index           =   0
      Left            =   210
      TabIndex        =   0
      Top             =   1365
      Width           =   1905
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      AutoSize        =   -1  'True
      BackStyle       =   0  'Transparent
      Caption         =   "Zoom"
      ForeColor       =   &H00000000&
      Height          =   195
      Index           =   1
      Left            =   3150
      TabIndex        =   8
      Top             =   105
      Width           =   495
   End
   Begin Image Image1 
      Height          =   375
      Left            =   105
      Picture         =   FEZPRINT.FRX:0000
      Top             =   105
      Width           =   345
   End
   Begin Label Label1 
      Alignment       =   2  'Center
      BackStyle       =   0  'Transparent
      Caption         =   "VSPrinter: The Visual Printer"
      FontBold        =   -1  'True
      FontItalic      =   0   'False
      FontName        =   "MS Sans Serif"
      FontSize        =   13.5
      FontStrikethru  =   0   'False
      FontUnderline   =   0   'False
      ForeColor       =   &H00800000&
      Height          =   1065
      Index           =   0
      Left            =   525
      TabIndex        =   4
      Top             =   105
      Width           =   1800
   End
End
Option Explicit

Dim MyPage%   'Keep the output view to be printed

Sub cmbZoom_Click ()
  
  mousepointer = 11
    
  'Change the screen size to zoom value
  vsPrinter1.Width = vsPrinter1.PageWidth * cmbZoom.List(cmbZoom.ListIndex) / 100
  vsPrinter1.Height = vsPrinter1.PageHeight * cmbZoom.List(cmbZoom.ListIndex) / 100
  VSViewPort1.VirtualWidth = vsPrinter1.Width + 2 * vsPrinter1.Left + 100
  VSViewPort1.VirtualHeight = vsPrinter1.Height + 2 * vsPrinter1.Top + 100
  
  mousepointer = 0

End Sub

Sub cmdPrint_Click ()
  
  mousepointer = 11
  
  ' Cancel Preview mode and print
  vsPrinter1.Preview = False
  command1_click MyPage
  vsPrinter1.Preview = True

  mousepointer = 0

End Sub

Sub command1_click (Index%)
      
  cmbZoom.Enabled = True
  cmdPrint.Enabled = True

  MyPage = Index%

  vsPrinter1.Action = 3 'Start Document
  mousepointer = 11

  Select Case Index

    Case 0
      DoLine

    Case 1
      DoParagraph

    Case 2
      DoTable

    Case 3
      DoColumns

    Case 4
      DoDrawing

    Case 5
      DoAlign
    
    Case 6
      DoIndent

    Case 7
      DoMailMerge "Joe Smith", "Chief Financial Officer"
      DoMailMerge "Mary Kerney", "President"

  End Select
  
  vsPrinter1.Action = 6 'End Document
  mousepointer = 0

End Sub

Sub DoAlign ()
      
      vsPrinter1.SpaceAfter = 500
      vsPrinter1.TextColor = QBColor(1)
      vsPrinter1.TextAlign = 1  'Center
      vsPrinter1.FontUnderline = True
      vsPrinter1.Paragraph = ""
      vsPrinter1.Paragraph = "VSPrinter automatically aligns proportional fonts"
      vsPrinter1.FontUnderline = False
      
      vsPrinter1.TextColor = QBColor(0)
      vsPrinter1.CurrentY = vsPrinter1.PageHeight / 2
      vsPrinter1.TextAlign = 2  'Rigth
      vsPrinter1.Paragraph = "The text is Right aligned"
      vsPrinter1.TextAlign = 1  'Center
      vsPrinter1.Paragraph = "The text is centered"
      vsPrinter1.TextAlign = 0  'Left
      vsPrinter1.Paragraph = "The text is Left aligned"
      vsPrinter1.SpaceAfter = 0

End Sub

Sub DoColumns ()
      Dim s$, i%

      s = "VSPrinter can also print in multiple columns. "
      s = s + "You have control over column breaks, and you can save "
      s = s + "a whole lot of paper by using multiple columns."
      
      vsPrinter1.Columns = 2
      vsPrinter1.PageBorder = 4
      
      vsPrinter1.TextColor = QBColor(1)
      vsPrinter1 = s
      vsPrinter1 = ""
      vsPrinter1.TextColor = QBColor(0)
      vsPrinter1 = s

      'Restore settings
      vsPrinter1.Columns = 1
      vsPrinter1.PageBorder = 3

End Sub

Sub DoDrawing ()
      Dim s$, x%, y%

      vsPrinter1.CurrentX = vsPrinter1.PageWidth / 2
      vsPrinter1.CurrentY = vsPrinter1.PageHeight / 2

      vsPrinter1.TextAlign = 1              ' Center
      vsPrinter1.TextColor = &H800000       'Blue
      vsPrinter1 = "Add graphics to your reports!"
      vsPrinter1.TextColor = &H0&           'Black
      vsPrinter1 = "With VSPrinter, it's easy!"
      vsPrinter1.TextAlign = 0              ' Left

      vsPrinter1.X1 = vsPrinter1.PageWidth / 4 * .25
      vsPrinter1.Y1 = vsPrinter1.PageHeight / 4 * .25
      vsPrinter1.X2 = vsPrinter1.PageWidth / 4 * 1.25
      vsPrinter1.Y2 = vsPrinter1.PageHeight / 4 * 1.25
      vsPrinter1.BrushColor = &HFF&         'Red
      vsPrinter1.BrushStyle = 6             'Cross
      vsPrinter1.Draw = 3                   'Circle

      vsPrinter1.X1 = vsPrinter1.PageWidth * .7
      vsPrinter1.Y1 = vsPrinter1.PageHeight * .7
      vsPrinter1.X2 = vsPrinter1.PageWidth * .9
      vsPrinter1.Y2 = vsPrinter1.PageHeight * .9
      vsPrinter1.BrushColor = &H800080      'Purple
      vsPrinter1.BrushStyle = 7             'Cross Diagonal
      vsPrinter1.Draw = 2                   'Rect.

      ' complex graphics
      s = ""
      For x = vsPrinter1.MarginLeft To vsPrinter1.PageWidth - vsPrinter1.MarginRight Step 20
        y = 6000 + Cos(x * 3.1416 / 180) * (x - vsPrinter1.PageWidth / 2) / 10
        s = s + Str(x) + Str(y)
      Next
      vsPrinter1.PenWidth = 10
      vsPrinter1.PolyLine = s
      vsPrinter1.PenWidth = 0

End Sub

Sub DoGraphics ()

End Sub

Sub DoIndent ()
  
  vsPrinter1.IndentFirst = 1000
  vsPrinter1 = "You can automatically indent the FIRST LINE of the paragrah."
  vsPrinter1 = ""

  vsPrinter1.IndentFirst = 0
  vsPrinter1.IndentLeft = 1000
  vsPrinter1 = "You can automatically indent from the LEFT margin of the paragrah."
  vsPrinter1 = ""
  
  vsPrinter1.IndentLeft = 0
  vsPrinter1.IndentRight = 1000
  vsPrinter1 = "You can automatically indent from the RIGHT margin of the paragrah."
  vsPrinter1 = ""

  vsPrinter1.IndentLeft = 1000
  vsPrinter1.IndentFirst = 1500
  vsPrinter1 = "You can even combined all levels of indentation."

  'Restore Values
  vsPrinter1.IndentLeft = 0
  vsPrinter1.IndentFirst = 0
  vsPrinter1.IndentRight = 0

End Sub

Sub DoLine ()
      vsPrinter1.Text = "With VSPrinter you can print"
      vsPrinter1.FontBold = True
      vsPrinter1.Text = " Line by Line"
      vsPrinter1.FontBold = False
      vsPrinter1.Text = " just like you would in VB."
      vsPrinter1.Text = " Text wraps automatically, so your life becomes easier."

End Sub

Sub DoMailMerge (FullName$, Position$)
  
  vsPrinter1 = ""
  vsPrinter1 = Format$(Now, "mmmm d, yyyy")
  vsPrinter1 = ""
  vsPrinter1 = "This letter is to inform that " & FullName & " has been promoted as " & Position & " of this company."
  vsPrinter1 = ""

End Sub

Sub DoParagraph ()

      Dim s$

      s = "You can print whole paragraphs at once! This is very easy. "
      
      vsPrinter1 = s + s
      vsPrinter1 = ""
      vsPrinter1 = "VSPrinter takes care of indentation, wrapping, spacing, etc."

End Sub

Sub DoTable ()
  Dim s$, fmt$

  vsPrinter1.PageBorder = 7       'All

  ' Print Title
  vsPrinter1 = ""
  vsPrinter1 = "Print by Table"

  vsPrinter1.FontSize = 22
  
  vsPrinter1 = ""
  vsPrinter1 = "You can now print reports that includes paragraphs and tables.  With VSView, printing a grid it is very easy."
  vsPrinter1 = ""

  '---------------------------------------------------------------
  
  'Set sizes and justification
  fmt = "2500|>1600|^1440|>2100|>1700;"                   '^Center > Right
  s = fmt + "Product|Code|Region|Units Sold|Revenue;"     'Set header

  vsPrinter1.PenWidth = 8
  vsPrinter1.Table = s
  
  
  'Print main table
  s = fmt + "Spam in a Can|00012|North|  372|$23,542;"
  s = s + "Flipper Tuna|00231|North|  832|$44,432;"
  s = s + "Jiffy Lubed Butter |00978|North|  452|$53,535;"
  s = s + "Saturn Bars|00543|North|  654|$12,535;"

  vsPrinter1.FontSize = 18
  vsPrinter1.Table = s

  vsPrinter1 = ""
  vsPrinter1 = "The table's cells could be aligned the way you want to."
  
  'Restore Values
  vsPrinter1.FontSize = 40
  vsPrinter1.PageBorder = 3       'Top & Bottom

End Sub

Sub DoTitle ()
  
  vsPrinter1.Action = 3 'Start Document

  vsPrinter1.CurrentX = vsPrinter1.PageWidth / 2
  vsPrinter1.CurrentY = vsPrinter1.PageHeight / 2
  vsPrinter1.TextAlign = 1 'Center

  vsPrinter1.TextColor = QBColor(2)
  vsPrinter1.Paragraph = "VideoSoft VSPrinter"
  vsPrinter1.TextColor = QBColor(0)
  vsPrinter1.Paragraph = ""
  vsPrinter1.Paragraph = "Click on any button"

  vsPrinter1.TextAlign = 0 'Left

  vsPrinter1.Action = 6 'End Document

End Sub

Sub Form_Load ()
  
  vsPrinter1.Preview = True
  vsPrinter1.PreviewPage = 1

  cmbZoom.AddItem "35"
  cmbZoom.AddItem "50"
  cmbZoom.AddItem "75"
  cmbZoom.AddItem "100"
  cmbZoom.AddItem "150"
  cmbZoom.AddItem "200"
  cmbZoom.ListIndex = 0

  MyPage = 0    'Default to first button

End Sub

