// ***************************************************************************
// HYPEROID.H - hyperoid internal header information
//
// Version: 1.1  Copyright (C) 1990,91 Hutchins Software
//      This software is licenced under the GNU General Public Licence
//      Please read the associated legal documentation
//
// Author: Edward Hutchins
// Internet: eah1@cec1.wustl.edu
// USMail: c/o Edward Hutchins, 63 Ridgemoor Dr., Clayton, MO, 63105
//
// Revisions:
// 10/31/91 made game better/harder - Ed.
//
// Music: R.E.M./The Cure/Ministry/Front 242/The Smiths/New Order/Hendrix...
// Beers: Bass Ale, Augsberger Dark
//
// 03/04/92 ported to Win32 - Paul Tissue & Robert Hess [Microsoft].
// ***************************************************************************

#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>
#include <limits.h>

#define OEMRESOURCE
#include "winext.h"

//
// typedefs and defines
//

// color stuff
#define PALETTE_SIZE 16
typedef enum {
  BLACK, DKGREY, GREY, WHITE,
  DKRED, RED, DKGREEN, GREEN, DKBLUE, BLUE,
  DKYELLOW, YELLOW, DKCYAN, CYAN, DKMAGENTA, MAGENTA
} COLORS;

// degrees scaled to integer math
#define DEGREE_SIZE 256
#define DEGREE_MASK 255
#define DEGREE_MAX 0x4000

// object limits
#define MAX_PTS 16
#define MAX_OBJS 100
#define MAX_COORD 0x2000
#define CLIP_COORD (MAX_COORD+300)

// timer stuff
#define DRAW_TIMER 1
#define DRAW_DELAY 50
#define RESTART_TIMER 2
#define RESTART_DELAY 5000

// restart modes
typedef enum { RESTART_GAME, RESTART_LEVEL, RESTART_NEXTLEVEL } RESTART_MODE;

// letter scaling
#define LETTER_MAX 256

// extra life every
#define EXTRA_LIFE 33333

// list node
typedef struct tagNODE {
  struct tagNODE  *npNext, *npPrev;
} NODE;
pointerdef( NODE );

// list header
typedef struct {
  NPNODE          npHead, npTail;
} LIST;
pointerdef( LIST );

// object descriptor
typedef struct {
  NODE    Link;               // for object list
  POINT   Pos;                // position of center of object
  POINT   Vel;                // velocity in logical units/update
  INT     nMass;              // mass of object
  INT     nDir;               // direction in degrees
  INT     nSpin;              // angular momentum degrees/update
  INT     nCount;             // used by different objects
  INT     nDelay;             // used by different objects
  BYTE    byColor;            // palette color
  BYTE    byPts;              // number of points in object
  POINT   Pts[MAX_PTS];       // points making up an object
  POINT   Old[MAX_PTS];       // last plotted location
} OBJ;
pointerdef( OBJ );

//
// inline macro functions
//

// function aliases
#define AddHeadObj(l,o) AddHead((l),((NPNODE)o))
#define RemHeadObj(l) ((NPOBJ)RemHead(l))
#define RemoveObj(l,o) Remove((l),((NPNODE)o))
#define HeadObj(l) ((NPOBJ)((l)->npHead))
#define NextObj(o) ((NPOBJ)((o)->Link.npNext))

// real-time check of the keyboard
#define IsKeyDown(x) (GetAsyncKeyState(x)<0)

// I HATE typing this allatime!
#define INTRES(x) MAKEINTRESOURCE(x)

// size of an array
#define DIM(x) (sizeof(x)/sizeof((x)[0]))

// faster than MulDiv!
#define MULDEG(x,y) ((INT)(((LONG)(x)*(y))/DEGREE_MAX))

// DEG - convert an integer into a degree lookup index
#define DEG(x) ((WORD)(x)&DEGREE_MASK)

// ACCEL - accelerate an object in a given direction
#define ACCEL(o,d,s) \
(((o)->Vel.x += MULDEG((s),nCos[DEG(d)])), \
((o)->Vel.y += MULDEG((s),nSin[DEG(d)])))

// PTINRECT - a faster PtInRect
#define PTINRECT(r,p) \
(((r)->left <= (p).x) && ((r)->right > (p).x) && \
((r)->top <= (p).y) && ((r)->bottom > (p).y))

// INTRECT - a faster IntersectRect that just returns the condition
#define INTRECT(r1,r2) \
(((r1)->right >= (r2)->left) && \
((r1)->left < (r2)->right) && \
((r1)->bottom >= (r2)->top) && \
((r1)->top < (r2)->bottom))

// MKRECT - make a rect around a point
#define MKRECT(r,p,s) \
(((r)->left = ((p).x-(s))), ((r)->right = ((p).x+(s))), \
((r)->top = ((p).y-(s))), ((r)->bottom = ((p).y+(s))))

//
// prototypes
//

#ifndef WIN32
  #ifndef APIENTRY
    #define APIENTRY far pascal
  #endif
#endif

// hyperoid.c
INT APIENTRY arand( INT x );
VOID APIENTRY AddHead( NPLIST npList, NPNODE npNode );
NPNODE APIENTRY RemHead( NPLIST npList );
VOID APIENTRY Remove( NPLIST npList, NPNODE npNode );
VOID APIENTRY DrawObject( HDC hDC, NPOBJ npObj );
VOID APIENTRY SetRestart( RESTART_MODE Restart );
VOID APIENTRY AddExtraLife( VOID );
VOID APIENTRY Hit( HDC hDC, NPOBJ npObj );
VOID APIENTRY Explode( HDC hDC, NPOBJ npObj );
BOOL APIENTRY HitPlayer( HDC hDC, NPOBJ npObj );
NPOBJ APIENTRY CreateLetter( CHAR cLetter, INT nSize, INT nCount );
VOID APIENTRY DrawLetters( HDC hDC );
VOID APIENTRY DrawHunterShots( HDC hDC );
VOID APIENTRY FireHunterShot( NPOBJ npHunt );
VOID APIENTRY CreateHunter( VOID );
VOID APIENTRY DrawHunters( HDC hDC );
VOID APIENTRY CreateSpinner( VOID );
VOID APIENTRY DrawSpinners( HDC hDC );
VOID APIENTRY CreateRoid( POINT Pos, POINT Vel, INT nSides, BYTE byColor, INT nDir, INT nSpeed, INT nSpin );
VOID APIENTRY BreakRoid( HDC hDC, NPOBJ npRoid, NPOBJ npShot );
VOID APIENTRY DrawRoids( HDC hDC );
VOID APIENTRY DrawShots( HDC hDC );
VOID APIENTRY DrawFlames( HDC hDC );
VOID APIENTRY FireShot( VOID );
VOID APIENTRY AccelPlayer( INT nDir, INT nAccel );
VOID APIENTRY DrawPlayer( HDC hDC );
VOID APIENTRY DrawObjects( HWND hWnd );
VOID APIENTRY CheckScore( HWND hWnd );
VOID APIENTRY HitList( HDC hDC, NPLIST npList );
VOID APIENTRY ExplodeBadguys( HDC hDC, NPLIST npList );
VOID APIENTRY NewGame( HWND hWnd );
VOID APIENTRY RestartHyperoid( VOID );
VOID APIENTRY Panic( BOOL bPanic );
VOID APIENTRY PaintHyperoid( HWND hWnd );
VOID APIENTRY DisableHyperoidInput( HWND hWnd, BOOL bCapture );
LONG APIENTRY HyperoidWndProc( HWND hWnd, UINT message, UINT wParam, LONG lParam );
BOOL APIENTRY InitHyperoid( VOID );
VOID APIENTRY ExitHyperoid( VOID );
int APIENTRY WinMain(HANDLE hInstance, HANDLE hPrevInstance, LPSTR lpCmdLine, int nCmdShow);
VOID APIENTRY NCPaintHyperoid( HWND hWnd );
BOOL APIENTRY EraseHyperoidBkgnd( HWND hWnd, HDC hDC );

// roidsupp.c
VOID APIENTRY PrintLetters( LPSTR npszText, POINT Pos, POINT Vel, BYTE byColor, INT nSize );
VOID APIENTRY SpinLetters( LPSTR npszText, POINT Pos, POINT Vel, BYTE byColor, INT nSize );
HPALETTE APIENTRY CreateHyperoidPalette( VOID );
BOOL APIENTRY CreateHyperoidClass( VOID );
VOID APIENTRY SetHyperoidMenu( HWND hWnd, INT nFirstID, INT nLastID );
HWND APIENTRY CreateHyperoidWindow( LPSTR lpszCmd, INT nCmdShow );
VOID APIENTRY SaveHyperoidWindowPos( HWND hWnd );
VOID APIENTRY GetHyperoidIni( VOID );
VOID APIENTRY HyperoidHelp( HWND hWnd );
BOOL APIENTRY HyperoidAboutDlg( HWND hDlg, UINT mess, UINT wParam, LONG lParam );
VOID APIENTRY AboutHyperoid( HWND hWnd );

#include "resource.h"

// user messages
#define UM_SIZE (WM_USER+0)
