// ***************************************************************************
// WINEXT.H - additional windows definitions
//
// Version 1.0  03/21/89  Copyright (C) 1989,90,91 Lantern Coroporation.
// Author: Edward Hutchins
// Status: Freeware
// Revisions:
// 06/06/90 modified HUGE to LARGE to preserve compatibility with math.h
//          also nested windows.h include to prevent modifications on the
//          actual source file - Ed.
// 10/01/90 added CONST and CONSTP,NP,LP,HP and a few comments - Ed.
// 08/28/91 added EXPORT and SEGMENT - Ed.
// 10/28/91 added DLLEXP - Ed.
// 11/02/91 posted on Compuserve - Ed.
//
// 03/04/92 ported to Win32 - Paul Tissue & Robert Hess [Microsoft].
// ***************************************************************************

#if !defined(WINEXT_H)
#define WINEXT_H

#if defined(__cplusplus)
extern "C" {
#endif // __cplusplus

//-- some handy Win32 porting macros
#ifdef WIN32
  #define huge
  #define MoveTo(hDC, X, Y)         MoveToEx         ( hDC, X, Y, NULL )
  #define SetWindowExt(hDC, X, Y)   SetWindowExtEx   ( hDC, X, Y, NULL )
  #define SetViewportExt(hDC, X, Y) SetViewportExtEx ( hDC, X, Y, NULL )
  #define SetViewportOrg(hDC, X, Y) SetViewportOrgEx ( hDC, X, Y, NULL )
#endif

#include <windows.h>

#ifndef UNREFERENCED_PARAMETER
#define UNREFERENCED_PARAMETER(a) (a = a)
#endif

//
// extra data types and defines
//

#define LARGE _far
#ifndef CDECL
  #define CDECL cdecl
#endif
#define CONST const
#define HNULL (0)
#define LPNULL (0L)

#ifndef WIN32
typedef char        CHAR;
typedef int         INT;
typedef float       FLOAT;
#endif

typedef double      DOUBLE;
typedef double      LDOUBLE;

// extend the string type
typedef CHAR *HPSTR;

// useful macros for typedefing pointers to objects //
#define npointerdef(o) typedef o FAR * NP ## o
#define lpointerdef(o) typedef o FAR * LP ## o
#define hpointerdef(o) typedef o FAR * HP ## o
#define pointerdef(o) npointerdef(o); lpointerdef(o); hpointerdef(o);

// define the different kinds of pointers to things //
pointerdef( BOOL );
npointerdef( BYTE );
pointerdef( CHAR );
npointerdef( INT );
hpointerdef( INT );
npointerdef( WORD );
hpointerdef( WORD );
npointerdef( LONG );
hpointerdef( LONG );
npointerdef( DWORD );
hpointerdef( DWORD );
pointerdef( FLOAT );
pointerdef( DOUBLE );
pointerdef( LDOUBLE );
npointerdef( HANDLE );
hpointerdef( HANDLE );
npointerdef( VOID );
hpointerdef( VOID );

// these are here for compatibility - use NPVOID etc...
typedef VOID NEAR *NPMEM;
typedef VOID FAR *LPMEM;

// window proc function pointer
#ifndef WIN32
typedef LONG (FAR PASCAL *WNDPROC)( HWND, UINT, UINT, LONG );
#endif

//
// scope protocol definitions
//

#define GLOBAL      // GLOBAL
#define LOCAL       static
#define IMPORT      extern
#define FROM(where) // FROM where
#define PROTO       // PROTOTYPE

#define EXPORT _export
#define SEGMENT _segment

#if defined(__cplusplus)
}
#endif // __cplusplus

// c++ class export type
#if defined(__DLL__)
#define DLLEXP EXPORT
#else
#define DLLEXP LARGE
#endif

#endif // WINEXT_H
