/* Unix compatible directory functions for Windows NT
 * Patched together code from the NT port of Perl done by 
 * Clark Williams of Intergraph Corp. with the header file
 * from the Microsoft Windows NT SDK Posix subsystem.
*/

/*
 * $Id: $
 */

/*
 * $Log: $
 */

#ifndef NTDIRENT
#define NTDIRENT

#include <sys/types.h>
#include <limits.h>

#ifdef __cplusplus
extern "C" {
#endif

#define NAME_MAX 255

struct dirent	{
	ino_t	d_ino;					/* inode number (not used by MS-DOS) */
	int	d_namlen;					/* Name length */
	char	d_name[NAME_MAX+1];		/* file name */
};


typedef struct DIR {
	char *start;			/* Starting position */
	char *curr;			/* Current position */
	long size;			/* Size of string table */
	long nfiles;			/* number if filenames in table */
	struct dirent dirstr;		/* Directory structure to return */
} DIR;


DIR *cdecl opendir(const char *);
struct dirent *readdir(DIR *);
long telldir(DIR *dirp);
void seekdir(DIR *dirp,long loc);
void rewinddir(DIR *);
void closedir(DIR *);

#ifdef __cplusplus
}
#endif

#endif /* NTDIRENT_H */
