/* REXX *****/
/* trace ?r */

ret_code = RxFuncQuery( 'Load' )
if ret_code \= 0 then do
    ret_code = RxFuncAdd( 'Load', 'MERXUtil', 'Load' );
    if ret_code \= 0 then do
        say 'RxAddFunc( Load ) Failed RC='||ret_code
        exit
    end
    else
        rc=Load()
end
else
    rc=Load()

say
say 'first, we''ll display the original JCL stream:'
say

do while lines( 'samp.jcl' )
    say linein( 'samp.jcl' )
end

/*
 * make sure to close the stream
 */
call lineout 'samp.jcl'

say
say 'press <ENTER> to continue...'
pull response

index = 1

say
say 'next, we''re going to strip comments and concatenate any continuation'
say 'lines, and then write the results away to a stem variable.'
say

do while lines( 'samp.jcl' )
    input = linein( 'samp.jcl' )
    notdone = 0
    do while notdone = 0
        if lastpos( ",", input ) == length( input ) then do
            temp = linein( 'samp.jcl' )
            input = input || strip( substr( temp, pos( "//", temp )+2 ))
        end
        else
            notdone = 1
    end
    if pos( "//*", input ) \= 0 then iterate
    junk.index = input
    index = index+1
end

junk.0 = index-1

say

do i=1 to junk.0
    say format( i, 3, '0' ) junk.i
end

say
say 'press <ENTER> to continue...'
pull response

say
say 'now, we''ll tokenize the stream, but we''re going to treat the JOB'
say 'card specially since we "know" it''s general format:'

parse value junk.1 with '//' jname 'JOB (' acctinfo '),' other
say
say 'jobname = 'jname
say 'account = 'acctinfo
say 'other   = '

rc=ParseLine( other, ",", junk1. )
do i=1 to junk1.0
    say '          'junk1.i
end

say
say 'press <ENTER> to continue...'
pull response

say 'now, we''ll do the rest of the stream...'
say
do i=2 to junk.0
    say format( i, 3 ) junk.i
    rc=ParseLine( substr( junk.i, pos( "//", junk.i)+2 ), "() ,", junk1. )
    do j=1 to junk1.0
        say '    'format( i, 3 )||'.'||right( j, 2, '0' ) junk1.j
    end
end

say
say 'jtest EXEC complete... BYE, NOW!!!'

exit
