/* REXX *****/
/* trace ?r */

/* -------------------------------------------------------------------
 *
 * this EXEC demonstrates the installed math functions by calculating
 * miscellaneous trigonometric identities.
 *
 */

/*
 * first, make sure that MERXUtil is loaded
 */
ret_code = RxFuncQuery( 'Load' )
if ret_code \= 0 then do
    ret_code = RxFuncAdd( 'Load', 'MERXUtil', 'Load' );
    if ret_code \= 0 then do
        say 'RxAddFunc( Load ) Failed RC='||ret_code
        exit
    end
    else
        rc=Load()
end
else
    rc=Load()

numeric digits 15

y = .75
say
say 'let x='y
say

a1 = sin(y)
b1 = cos(y)
a2 = a1*a1
b2 = b1*b1

say 'sin^2(x) + cos^2(x) = 1'
say '> sin(x) =' a1
say '> cos(x) =' b1
say '> sin^2(x) =' a2
say '> cos^2(x) =' b2
say '> sin^2(x) + cos^2(x) =' a2 + b2

say
say 'tan(x) = 1/cot(x) = sin(x)/cos(x)'
say '> sin(x) =' a1
say '> cos(x) =' b1
say '> sin(x)/cos(x) =' a1/b1
say '> tan(x) =' tan(y)
say 'so,' tan(y) '=' 1/cot(y) '=' a1/b1

say
say 'sin(x) = tan(x)*cos(x)'
say 'so,' sin(y) '=' tan(y)*cos(y)

say
say 'cos(x) = cot(x)*sin(x)'
say 'so,' cos(y) '=' cot(y)*sin(y)

say
say 'tan(x) = sin(x)*sec(x)'
say 'so,' tan(y) '=' sin(y)*sec(y)

say
say 'cot(x) = cos(x)*csc(x)'
say 'so,' cot(y) '=' cos(y)*csc(y)

say
say 'sec(x) = csc(x)*tan(x)'
say 'so,' sec(y) '=' csc(y)*tan(y)

say
say 'csc(x) = sec(x)*cot(x)'
say 'so,' csc(y) '=' sec(y)*cot(y)

say
say 'mtest EXEC complete... BYE, NOW!!!'















 
now let's see if we can pick it out of the list and kill iterror!BYE, NOW!!!STARTRXSLEEP




