/* REXX *****/
/* trace ?r */

/* -------------------------------------------------------------------
 *
 * this EXEC demonstrates the Start, RxSleep, ps and Kill functions.
 * first, a command shell is started minimized with a title "test".
 * next we go to sleep for a few seconds to allow the system the
 * opportunity to start that process.  when we come back, we call the
 * ps function to list all of the top-level windows on the system and
 * scan the returned stem for the process that we started.  we then
 * loop through the stem a second time, but when we find our process,
 * we kill it with a call to the Kill function.
 *
 */

/*
 * first, make sure that MERXUtil is loaded
 */
ret_code = RxFuncQuery( 'Load' )
if ret_code \= 0 then do
    ret_code = RxFuncAdd( 'Load', 'MERXUtil', 'Load' );
    if ret_code \= 0 then do
        say 'RxAddFunc( Load ) Failed RC='||ret_code
        exit
    end
    else
        rc=Load()
end
else
    rc=Load()

say
say 'first, we''re going to start a program'
new = start( cmd, "test", min )

/*
 * the purpose here is to relinquish control.  otherwise, we run
 * fast enough that the process started above doesn't get the
 * chance to initialize before we go off and do our process walk
 * which means that we never see it
 */
say
say 'now, we''ll sleep for a few seconds to give it a chance'
rc=rxsleep( 500 );

say
say 'ok, now let''s see if we can pick it out of the ps() list'
say
rc=ps( junk. )
if rc == 'OK' then do
    do i=1 to junk.0

        /*
         * parse upper isn't used because we're going to display
         * the process names the way the system returns them.
         *
         */
        parse var junk.i hwnd pid priority ttime ktime utime pname
        if strip( upper( pname )) == "TEST" then do
            say '*'hwnd pid pname ' <------  here it is'
        end
        else
            say ' 'hwnd pid pname
    end
end

say
say 'ok, now let''s see if we can pick it out of the list and kill it'
do i=1 to junk.0
    parse upper var junk.i hwnd pid priority ttime ktime utime pname
    if strip( pname ) == "TEST" then do
        rc = kill( pid )
        if rc \= 'OK' then say 'error calling kill('pid')'
    end
end

say
say 'stest EXEC complete... BYE, NOW!!!'



 
  

  
 8
  

 ]	
  
  
 ]	 
 !
 
    	 R]
              N  ?      
now let's see if we can pick it out of the list and kill iterror!BYE, NOW!!!STARTRXSLEEP  
 

   A
  1 1 
