/* REXX *****/
/* trace ?r */

ret_code = RxFuncQuery( 'Load' )
if ret_code \= 0 then do
    ret_code = RxFuncAdd( 'Load', 'MERXUtil', 'Load' );
    if ret_code \= 0 then do
        say 'RxAddFunc( Load ) Failed RC='||ret_code
        exit
    end
    else
        rc=Load()
end
else
    rc=Load()

say
say 'first, we''ll test RxComputerName()'
say '    the computer name is' RxComputerName()

say
say 'next, test RxUserName()'
say '    the current user is' RxUserName()

say
say 'next, test RxNTUpTime()'
say '    the system has been active for' RxNTUpTime() 'milliseconds'

say
say 'next, test RxSystemInfo()'
sysinfo = RxSystemInfo()
parse var sysinfo oem npro tpro mpro page minapp maxapp

say '        oemid                =' oem
say '        number of processors =' npro
say '        processor type       =' tpro
say '        processor mask       =' mpro
say '        page size            =' page
say '        min appl addr        =' minapp
say '        max appl addr        =' maxapp

say
say 'next, test RxNTMemory()'
memory = RxNTMemory()
parse var memory tph aph tpa apa tvr avr load

say '        total physical       =' tph
say '        available physical   =' aph
say '        total pagefile       =' tpa
say '        available pagefile   =' apa
say '        total virtual        =' tvr
say '        available virtual    =' avr
say '        memory load [0..100] =' load

say
say 'press <ENTER> to continue...'
pull response

say
say 'next, we''re going to use our ParseLine function to build a stem with all'
say 'of our drives in it.  we''ll use the RxNTGetDisks() function as input to'
say 'ParseLine() and then we''re going to walk the resulting stem variable,'
say 'calling RxNTDiskType() for each drive included in the stem.  Then we''re'
say 'going to call RxNTDiskInfo() for each drive listed in the stem, followed'
say 'by a call to the RxNTVolumeInfo() function for each drive in the stem.'

rc=parseline( RxNTGetDisks(), " ", junk. )

say
say 'here are our drives and their types:'
do i=1 to junk.0
    say '   'junk.i ' -> ' RxNTDiskType( junk.i )
end

say
say 'press <ENTER> to continue...'
pull response

say
say 'next, test RxNTDiskInfo()'
do i=1 to junk.0
    disk = RxNTDiskInfo( junk.i )
    say '    disk information for' junk.i
    rc=DoDiskInfo()
end

say
say 'press <ENTER> to continue...'
pull response

say
say 'next, test RxNTVolumeInfo()'
do i=1 to junk.0
    volinfo = RxNTVolumeInfo( junk.i )
    say '    volume information for' junk.i
    rc=DoVolInfo()
end

say
say 'press <ENTER> to continue...'
pull response

say
rc = charout( , 'would you like to test the environmental variable functions? [yN] ' )
pull response

if upper( response ) == 'Y' then
    call 'vtest.cmd'

say
say 'stest EXEC complete... BYE, NOW!!!'

exit

/*
 * support routines:
 */

DoVolInfo: procedure expose volinfo

    parse var volinfo root vname volser fnlen flags fsname

    say '        root                 =' root
    say '        volume name          =' vname
    say '        volume serial        =' volser
    say '        filename comp length =' fnlen
    say '        flags                =' flags
    say '        filesystem name      =' fsname
    say
return "OK"


DoDiskInfo: procedure expose disk

    parse var disk root spc bps fc tc

    say '        root                 =' root
    say '        sectors/cluster      =' spc
    say '        bytes/sector         =' bps
    say '        free clusters        =' fc
    say '        total clusters       =' tc
    say '        free bytes           =' spc*bps*fc
    say '        total bytes          =' spc*bps*tc
    say
return "OK"
