/***************************************************************************
  Windows Sockets FTP Client Application Suport Module

  Written by:
      John A. Junod             Internet: <junodj@gordon-emh2.army.mil>
      267 Hillwood Street                 <zj8549@trotter.usma.edu>
      Martinez, GA 30907      Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.  It would be nice (but is not required) to give me a little 
  credit for any use of this code.  

  THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY 
  OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
  PURPOSE. IN NO EVENT SHALL JOHN A. JUNOD BE LIABLE FOR ANY DAMAGES 
  WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS 
  OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF JOHN A. JUNOD HAS BEEN 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*****************************************************************************/
/*
  MODULE: WS_GLOB.H  (global header file)
*/

#include <stdio.h>
#include <string.h>

#ifdef _MSC_
#include <direct.h>
#else
#include <dir.h>
#endif

#include "winsock.h"

#ifndef WS_GLOBHEADER

#define WS_GLOBHEADER

#ifndef INADDR_NONE
#define INADDR_NONE 0xffffffff
#endif

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN 64
#endif

#ifndef MAXPACKET
#define MAXPACKET 4096
#endif

// some miscellaneous definitions that we use

#define FTP_PRELIM   1
#define FTP_COMPLETE 2
#define FTP_CONTINUE 3
#define FTP_RETRY    4
#define FTP_ERROR    5

#ifndef IS_GLOBAL_C

extern BOOL bAutoStart;
extern BOOL bAborted;
 
extern u_int uiTimeOut;              // 30 second timeout??

extern char szMsgBuf[MAXPACKET];     // main i/o buffer
extern char szMsgBuf2[MAXPACKET];     // main i/o buffer
extern u_char szSendPkt[MAXPACKET];  // output transfer buffer
extern char szString[512];           // temp string area
extern char szMailAddress[];
extern char szViewer[];
extern char szDlgPrompt[80];         // used by input dialog as prompt
extern char szDlgEdit[80];           // used by input dialog for output
extern char szUserID[80];            // used by host dialog for userid
extern char szPassWord[80];          // used by host dialog for password
extern char szRemoteHost[80];        // remote host name/addr to connect to
extern char szGateUserID[80];        // used by host dialog for gateway userid
extern char szGatePassWord[80];      // used by host dialog for gateway password
extern char szGateHost[80];        // gateway host name/addr to connect to
extern char szAppName[20];           // this programs name "ws_ftp"
extern char szTmpFile[];             // used for directory listings
extern char szTmp1File[];            // used for remote file displays
extern char szIniFile[];             // INI file name
 
extern char szFormName[10];          // ** not used in this version
extern char szModeName[10];          // ** not used in this version
extern char szStructName[10];        // ** not used in this version
extern char szTypeName[10];          // ** not used in this version

extern BOOLEAN globalsucceed;

extern char fType;                   // file transfer type
extern char cType;                   // current transfer type
extern char cForm;                   // format (not used???)
extern char cMode;                   // mode (not used???)
 
extern GLOBALHANDLE hGMem[100];      // memory for debug window display
 
extern HCURSOR hStdCursor;           // cursors
extern HCURSOR hWaitCursor;          // cursors
 
extern HWND hInst;                   // handle of instance
extern HWND hWndMain;                // handle of main window
// child window handles
// lgk new boxes for dir selection
extern HWND hLdirBox, hRdirBox , hBtnAbort;
extern HWND hLbxLDir,hLbxLFiles,hLbxRDir,hLbxRFiles;
extern HWND hBtnLCWD,hBtnLMKD,hBtnLRMD,hBtnLDisplay,hBtnLREN,hBtnLDEL;
extern HWND hBtnRCWD,hBtnRMKD,hBtnRRMD,hBtnRDisplay,hBtnRREN,hBtnRDEL;
extern HWND hBtnLtoR,hBtnRtoL;
extern HWND hBtnConnect,hBtnClose,hBtnLong,hBtnOption,hBtnAbout,hBtnExit;
extern HWND hTxtLDir,hTxtRHost,hTxtRDir,hTxtStatus,hTxtLBytes,hTxtRBytes;
extern HWND hRBascii,hRBbinary,hRBl8,   hTxtStatus1;
extern HWND hScroll;
#define SCRLWND 7531

extern int bConnected;               // connected flag
extern int bCmdInProgress;           // command in progress flag
extern int bSendPort;                // use PORT commands (must be 1!!!)
extern int use_gateway ;
 
extern int nWndx;                    // the x axis multiplier
extern int nWndy;                    // the y axis multiplier
 
// options
extern int bBell;          // completion bell (not used in this version)
extern int bCRstrip;       // crlf conversion (not used in this version)
extern int bDoGlob;        // globbing (not used in this version)
extern int bHash;          // show hash (not used in this version)
extern int bInteractive;   // prompting (not used in this version)
extern int bMCase;         // case conversion (not used in this version)
extern int bRecvUniq;      // unique name on receive (not used in this ver)
extern int bStorUniq;      // unique name on transmit (not used in this ver)
extern int bVerbose;       // maximum verbosity (turns extra debug msgs on)
 
extern int iCode;          // return code from last command(..)
 
extern int ptrhGMem;
 
extern volatile SOCKET ctrl_socket;           // control channel socket
extern volatile SOCKET data_socket;           // data channel socket
extern volatile SOCKET listen_socket;         // data listen socket
 
extern struct sockaddr saDestAddr;     
extern struct sockaddr_in saSockAddr;         // endpoint address
extern struct sockaddr_in saSockAddr1;        // used when bSendPort==0
extern struct sockaddr_in saCtrlAddr;
 
extern WORD sVPos;                   // scroll pos for debug window
 
extern WSADATA WSAData;              // windows sockets dll information

// lgk new globals for mutli threading

extern HANDLE threadhandle;
extern DWORD threadid;

#endif /* if IS_GLOBAL_C */
 
#endif /* if WS_GLOBHEADER */

