/***************************************************************************
  Windows Sockets Client Application Support Module

  Written by:
      John A. Junod             Internet: <junodj@gordon-emh2.army.mil>
      267 Hillwood Street                 <zj8549@trotter.usma.edu>
      Martinez, GA 30907      Compuserve: 72321,366 

  This program executable and all source code is released into the public
  domain.  It would be nice (but is not required) to give me a little 
  credit for any use of this code.  

  THE INFORMATION AND CODE PROVIDED IS PROVIDED AS IS WITHOUT WARRANTY 
  OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO 
  THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
  PURPOSE. IN NO EVENT SHALL JOHN A. JUNOD BE LIABLE FOR ANY DAMAGES 
  WHATSOEVER INCLUDING DIRECT, INDIRECT, INCIDENTAL, CONSEQUENTIAL, LOSS 
  OF BUSINESS PROFITS OR SPECIAL DAMAGES, EVEN IF JOHN A. JUNOD HAS BEEN 
  ADVISED OF THE POSSIBILITY OF SUCH DAMAGES.

*****************************************************************************/

#include "ws_glob.h"
#include "ws_ftp.h"
#include <io.h>     // access()
#include <stdlib.h> // atoi()

char szInitDir[80];
char szSessionName[80];

#define MAXTYPES 16
LPSTR szHostTypes[MAXTYPES]={
  "auto detect",
  "Chameleon",
  "FTP PC-TCP",
  "IBM-PC TCP/IP",
  "IBM-VM/MVS",
  "KA9Q/NOS",
  "NCSA/CUTCP",
  "SI NT FTPD",
  "Super TCP",
  "Unisys 5000 (EXOS)",
  "UNIX (default)",
  "VMS-Multinet",
  "VMS-UCX",
  "WinQVT/Net",
  "Windows NT",
  "Solaris - Unix"
  };

// int nTypes[MAXHOSTS];
BOOL bSavePWD=FALSE;
BOOL bUseGateWay=FALSE;
char szCrypt[160];
LPSTR szAnony="anonymous";
int nHostType=HOST_TYPE_AUTO;
extern BOOL bHELP;
extern BOOL bCanMKD,bCanRMD,bCanREN,bCanDELE;
extern HBRUSH hbrGray1,hbrGray2;

   // lgk new function to get remote search string

 char *remotesearchstring()
  {

   char temp[110];
   SendMessage(hRdirBox,WM_GETTEXT,100,(LONG)temp);
   return temp;
  }
 

void LoadConfigNames(HWND);
/*
// this encryption is not secure nor is it intended to be
// this is just to keep the password from being plain text
// in the ini file.  I'd really recommend people don't save
// their passwords
*/
LPSTR EnCrypt(LPSTR userid,LPSTR passwd)
{
  int nIndex;
  if(lstrcmp(userid,szAnony)==0)
    return(passwd);
  szCrypt[0]=0;
  for(nIndex=0;nIndex<lstrlen(passwd);nIndex++) {
    wsprintf(&szCrypt[nIndex*2],"%02X",
      ((char)passwd[nIndex])+nIndex);
  }
  return(szCrypt);
}

int unhex(char c) {
  if(c>'9') return(c-'7');
  return (c-'0');
}

LPSTR DeCrypt(LPSTR userid,LPSTR passwd)
{
  int nIndex;
  if(lstrcmp(userid,szAnony)==0)
    return(passwd);
  szCrypt[0]=0;
  for(nIndex=0;nIndex<lstrlen(passwd);nIndex+=2) {
    (BYTE)szCrypt[nIndex/2]=
      ((unhex(passwd[nIndex])*16)+
       unhex(passwd[nIndex+1]))-(nIndex/2);
    szCrypt[nIndex/2+1]=0;
  }
  return(szCrypt);
}

/*******************************************************
  Set the dialog box controls according to the current
  selected host.
*/
SetDefaultHostStuff(HWND hWndDlg,LPSTR szSession) {

  szRemoteHost[0]=0;
  GetPrivateProfileString(szSession,"HOST",szSession,szRemoteHost,79,szIniFile);
  SetDlgItemText(hWndDlg,DLG_HOST_ADDRESS,szRemoteHost);

  szUserID[0]=0;
  GetPrivateProfileString(szSession,"UID",NULL,szUserID,79,szIniFile);
  SetDlgItemText(hWndDlg,DLG_HOST_USERID,szUserID);

  szPassWord[0]=0; szMsgBuf[0]=0; bSavePWD=FALSE;
  GetPrivateProfileString(szSession,"PWD",NULL,szMsgBuf,79,szIniFile);
  if(szUserID[0]!=0 && szMsgBuf[0]!=0) {
    lstrcpy(szPassWord,DeCrypt(szUserID,szMsgBuf));
    bSavePWD=TRUE;
  }
  CheckDlgButton(hWndDlg,DLG_HOST_PWD,bSavePWD);

  if(lstrcmpi(szUserID,szAnony)==0) {
    CheckDlgButton(hWndDlg,DLG_HOST_ANONY,TRUE);
    if(szPassWord[0]==0) {
      if(szMailAddress[0]==0)
        StdInput(szMailAddress,"Enter your e-mail address:");
      else
        lstrcpy(szPassWord,szMailAddress);
    }
  } else
    CheckDlgButton(hWndDlg,DLG_HOST_ANONY,FALSE);
  SetDlgItemText(hWndDlg,DLG_HOST_PASSWORD,szPassWord);

  szInitDir[0]=0;
  GetPrivateProfileString(szSession,"DIR",NULL,szInitDir,79,szIniFile);
  SetDlgItemText(hWndDlg,DLG_HOST_DIR,szInitDir);

  szGateHost[0]=0; bUseGateWay=FALSE;
  GetPrivateProfileString(szSession,"GATEHOST",NULL,szGateHost,79,szIniFile);
  if(szGateHost[0]!=0) bUseGateWay=TRUE;
  CheckDlgButton(hWndDlg,DLG_HOST_GATEWAY,bUseGateWay);

  nHostType=GetPrivateProfileInt(szSession,"TYPE",HOST_TYPE_AUTO,szIniFile);
  SendDlgItemMessage(hWndDlg,DLG_HOST_TYPE,CB_SETCURSEL,nHostType-6000,0l);

  uiTimeOut=GetPrivateProfileInt(szSession,"TIMEOUT",65,szIniFile);
  SetDlgItemInt(hWndDlg,DLG_HOST_TIMEOUT,uiTimeOut,FALSE);

  return TRUE;
}

BOOL CALLBACK WS_GateMsgProc(HWND hWndDlg, WORD Message,
                               WORD wParam, LONG lParam)
{
 //nt nIndex;
 //INT nRC;

  switch(Message)
  {
    case WM_INITDIALOG:
      GetPrivateProfileString(szSessionName,"GATEHOST",
        NULL,szGateHost,79,szIniFile);
      SetDlgItemText(hWndDlg,DLG_HOST_ADDRESS,szGateHost);
      GetPrivateProfileString(szSessionName,"GATEUSERID",
        NULL,szGateUserID,79,szIniFile);
      SetDlgItemText(hWndDlg,DLG_HOST_USERID,szGateUserID);
      if(GetPrivateProfileString(szSessionName,"GATEPASSWORD",
        NULL,szGatePassWord,79,szIniFile))
        strcpy(szGatePassWord,DeCrypt(szGateUserID,szGatePassWord));
      SetDlgItemText(hWndDlg,DLG_HOST_PASSWORD,szGatePassWord);
      CheckDlgButton(hWndDlg,DLG_HOST_PWD,bSavePWD);
      break;
    case WM_CLOSE:
      PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
      break;

      
        case WM_CTLCOLORBTN:
            if(LOWORD(lParam)<10) return((LRESULT)NULL);
       case WM_CTLCOLORDLG:
        case WM_CTLCOLORSTATIC:
          SetBkColor((HDC) wParam, RGB(192,192,192));
          return(LRESULT)hbrGray1;
		  break;

        case WM_CTLCOLORLISTBOX:
          return(LRESULT)hbrGray1;
          break;

    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case IDOK:
          GetDlgItemText(hWndDlg,DLG_HOST_ADDRESS,szGateHost,79);
          WritePrivateProfileString(szSessionName,"GATEHOST",
             szGateHost,szIniFile);
          GetDlgItemText(hWndDlg,DLG_HOST_USERID,szGateUserID,79);
          WritePrivateProfileString(szSessionName,"GATEUSERID",
             szGateUserID,szIniFile);
          GetDlgItemText(hWndDlg,DLG_HOST_PASSWORD,szGatePassWord,79);
          if(IsDlgButtonChecked(hWndDlg,DLG_HOST_PWD))
            WritePrivateProfileString(szSessionName,"GATEPASSWORD",
              EnCrypt(szGateUserID,szGatePassWord),szIniFile);
          else
            WritePrivateProfileString(szSessionName,"GATEPASSWORD",
              NULL,szIniFile);
          EndDialog(hWndDlg,TRUE);
          break;
        case IDCANCEL:
          EndDialog(hWndDlg, FALSE);
          break;
      }
      break;
    default:
      return FALSE;
  }
  return TRUE;
}

/******************************************************************
  Message processing for host dialog box
*/
BOOL CALLBACK WS_HostMsgProc(HWND hWndDlg, UINT Message,
                               WPARAM wParam, LPARAM lParam)
{
  int nIndex;
 //char szRHost[80];
  UINT nRC;

  switch(Message)
  {
    case WM_INITDIALOG:
      LoadConfigNames(hWndDlg);
      for(nIndex=0;nIndex<MAXTYPES;nIndex++)
        SendDlgItemMessage(hWndDlg,DLG_HOST_TYPE,CB_ADDSTRING,
          0,(LONG)(LPSTR)szHostTypes[nIndex]);
      SetDlgItemText(hWndDlg,DLG_HOST_NAME,szSessionName);
      SetDlgItemText(hWndDlg,DLG_HOST_ADDRESS,szRemoteHost);
      SetDlgItemText(hWndDlg,DLG_HOST_USERID,szUserID);
      SetDlgItemText(hWndDlg,DLG_HOST_PASSWORD,szPassWord);
      SetDlgItemText(hWndDlg,DLG_HOST_DIR,szInitDir);
      SetDlgItemInt(hWndDlg,DLG_HOST_TIMEOUT,uiTimeOut,FALSE);
      CheckDlgButton(hWndDlg,DLG_HOST_PWD,bSavePWD);
      SendDlgItemMessage(hWndDlg,DLG_HOST_TYPE,CB_SETCURSEL,nHostType-6000,0L);
      if(szSessionName[0]==0)
        strcpy(szSessionName,szRemoteHost);
      SetDefaultHostStuff(hWndDlg,szSessionName);
      cwCenter(hWndDlg, 0);
      SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,WM_SETREDRAW,TRUE,0l);
      break;
    case WM_CLOSE:
      PostMessage(hWndDlg, WM_COMMAND, IDCANCEL, 0L);
      break;


	 case WM_CTLCOLORBTN:
           if(LOWORD(lParam)<10) return((LRESULT)NULL);
	 case WM_CTLCOLORDLG:
	 case WM_CTLCOLORSTATIC:
           SetBkColor((HDC) wParam, RGB(192,192,192));
		  return (LRESULT)hbrGray1;
		   break;

  	 case WM_CTLCOLORLISTBOX:
         return(LRESULT)hbrGray1;
		 break;

/*    case WM_CTLCOLOR:
      switch(HIWORD(lParam)) {
        case CTLCOLOR_BTN:
          if(LOWORD(lParam)<10) return((LRESULT)NULL);
        case CTLCOLOR_DLG:
        case CTLCOLOR_STATIC:
          SetBkColor((HDC) wParam, RGB(192,192,192));
        case CTLCOLOR_LISTBOX:
          return(LRESULT)hbrGray1;
        } 

        return(LRESULT)NULL;
		break; */

			// lgk change hiword lparam to loword wparam
    case WM_COMMAND:
      switch(LOWORD(wParam))
      {
        case DLG_HOST_NAME:
          if(HIWORD(wParam)==CBN_KILLFOCUS ||
             HIWORD(wParam)==CBN_EDITCHANGE) 
             {
              GetDlgItemText(hWndDlg,DLG_HOST_NAME,szSessionName,79);
             } 
           else if(HIWORD(wParam)==CBN_SELCHANGE) 
              {
                if((nIndex=SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,
                          CB_GETCURSEL,0,0L))!=LB_ERR)
                   SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,CB_GETLBTEXT,
                                    nIndex,(LONG)szSessionName);
                else break;

              } 
           else break;
          SetDefaultHostStuff(hWndDlg,szSessionName);

/*		           SetDefaultHostStuff(hWndDlg,szSessionName);

          if(HIWORD(lParam)==CBN_KILLFOCUS)
            SendDlgItemMessage(hWndDlg,DLG_HOST_ADDRESS,WM_SETREDRAW,TRUE,0l);
*/
          break;

        case DLG_HOST_ANONY:
          if(IsDlgButtonChecked(hWndDlg,DLG_HOST_ANONY)) {
            SetDlgItemText(hWndDlg,DLG_HOST_USERID,szAnony);
            if(*szMailAddress==0)
              StdInput(szMailAddress,"Enter your e-mail address:");
            SetDlgItemText(hWndDlg,DLG_HOST_PASSWORD,szMailAddress);
            SetFocus(GetDlgItem(hWndDlg,DLG_HOST_ANONY));
          }
          return(FALSE);

        case DLG_BTN_DEL:
          if(GetDlgItemText(hWndDlg,DLG_HOST_NAME,szSessionName,79)>0) {
            WritePrivateProfileString(szSessionName,NULL,NULL,szIniFile);
            if((nIndex=SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,
               CB_FINDSTRINGEXACT,0,(LONG)(LPSTR)szSessionName))!=CB_ERR) {
              SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,CB_DELETESTRING,
                 nIndex,0l);
            } else nIndex=0;
            if(SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,CB_SETCURSEL,nIndex,0l)
              ==CB_ERR)
              SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,CB_SETCURSEL,0,0l);
          }
          GetDlgItemText(hWndDlg,DLG_HOST_NAME,szSessionName,79);
          SetDefaultHostStuff(hWndDlg,szSessionName);
          SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,WM_SETREDRAW,TRUE,0l);
          SetFocus(GetDlgItem(hWndDlg,DLG_HOST_NAME));
          break;

        case DLG_BTN_SAVE:
        case IDOK:
          GetDlgItemText(hWndDlg,DLG_HOST_ADDRESS,szRemoteHost,79);
          if(GetDlgItemText(hWndDlg,DLG_HOST_NAME,szSessionName,79)==0)
            lstrcpy(szSessionName,szRemoteHost);
          GetDlgItemText(hWndDlg,DLG_HOST_USERID,szUserID,79);
          GetDlgItemText(hWndDlg,DLG_HOST_PASSWORD,szPassWord,79);
          GetDlgItemText(hWndDlg,DLG_HOST_DIR,szInitDir,79);
          nRC=GetDlgItemInt(hWndDlg,DLG_HOST_TIMEOUT,NULL,FALSE);
          if(nRC==0) uiTimeOut=65; else uiTimeOut=nRC;
          if(uiTimeOut > (65536/1000)) uiTimeOut=65530/1000;
          if(IsDlgButtonChecked(hWndDlg,DLG_HOST_PWD))
            bSavePWD=TRUE;
          else
            bSavePWD=FALSE;
          nIndex=SendDlgItemMessage(hWndDlg,DLG_HOST_TYPE,CB_GETCURSEL,0,0l);
          if(nIndex==CB_ERR)
            nHostType=HOST_TYPE_AUTO;
          else
            nHostType=nIndex+HOST_TYPE_AUTO;
          SaveHostName(szSessionName);
          if (IsDlgButtonChecked(hWndDlg, DLG_HOST_GATEWAY))
            { FARPROC lpfnMsgProc;
              use_gateway=1;
              lpfnMsgProc=MakeProcInstance((FARPROC)WS_GateMsgProc,hInst);
              nRC=DialogBox(hInst,(LPSTR)"DLG_GATEWAY",hWndDlg,lpfnMsgProc);
              FreeProcInstance(lpfnMsgProc);
              SetFocus(hWndDlg);
            } else use_gateway=0;
          if(LOWORD(wParam)==IDOK)
            EndDialog(hWndDlg, TRUE);
          else
            if(SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,
               CB_FINDSTRINGEXACT,0,(LONG)(LPSTR)szSessionName)==CB_ERR) {
              SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,CB_ADDSTRING,
                 0,(LONG)(LPSTR)szSessionName);
              SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,WM_SETREDRAW,TRUE,0l);
              SetFocus(GetDlgItem(hWndDlg,DLG_HOST_NAME));
            }
          break;

        case IDCANCEL:
          EndDialog(hWndDlg, FALSE);

         if(!bConnected)
           {
           EnableWindow(hBtnConnect,TRUE);
           EnableWindow(hBtnClose,FALSE);
           }
          break;
      }
      break;
    default:
      return FALSE;
  }
  return TRUE;
}

/***************************************************************
  save the information about the current host in the ini file
*/
void SaveHostName(LPSTR lpszCName)
{
  char buf[30];
  WritePrivateProfileString(lpszCName,"HOST",szRemoteHost,szIniFile);
  WritePrivateProfileString(lpszCName,"UID",szUserID,szIniFile);
  if(bSavePWD)
    WritePrivateProfileString(lpszCName,"PWD",
        EnCrypt(szUserID,szPassWord),szIniFile);
  else
    WritePrivateProfileString(lpszCName,"PWD",NULL,szIniFile);
  if(szInitDir[0]!=0)
    WritePrivateProfileString(lpszCName,"DIR",szInitDir,szIniFile);
  else
    WritePrivateProfileString(lpszCName,"DIR",NULL,szIniFile);
  wsprintf(buf,"%u",nHostType);
  WritePrivateProfileString(lpszCName,"TYPE",buf,szIniFile);
  wsprintf(buf,"%u",uiTimeOut);
  WritePrivateProfileString(lpszCName,"TIMEOUT",buf,szIniFile);
}

/*****************************************************
  convert remotename into something DOS can deal with here nt can deal with longer names
*/
// lgk add fix for vax which makes names with ;version numbe now

MakeLocalName(LPSTR localname,LPSTR shortname, LPSTR remotename)
{
  int nIndex;
  char Name[10],Ext[4],*s;
  char Name2[140], Ext2[80];
  char savedname[256];

  lstrcpy(savedname,remotename);

  // lgk on nt try the entire name first for localname

  while(*remotename!=0 && *remotename=='.')
    remotename++;
  for(nIndex=0;nIndex<140;nIndex++)
    if(*remotename!=0 && *remotename!='.' && *remotename!=' ')
      { 
        if (nIndex < 8)
         Name[nIndex] = *remotename;
        Name2[nIndex] = *remotename++;
	  }
    else break;

 if (nIndex <= 8)
   Name[nIndex]=0; 
 else Name[8]=0; 
  
  Name2[nIndex]=0; 
  Ext2[0]=0;
  Ext[0] = 0;

  if((s=strchr(remotename,'.'))!=NULL)
    remotename=s;
  while(*remotename!=0 && (*remotename=='.' || *remotename==' '))
    remotename++;
  if(*remotename!=0) {
    for(nIndex=0;nIndex<80;nIndex++)
      if(*remotename!=0 && *remotename!='.' && *remotename!=' ')
        { if (nIndex < 3) 
            Ext[nIndex] = *remotename;
          Ext2[nIndex] = *remotename++;
		}
      else break;

  if (nIndex <=3)
   Ext[nIndex]=0;
  else Ext[3] = 0;

    Ext2[nIndex] = 0;
  }
  
  if(Ext[0]==0) {
    lstrcpy(shortname,Name);
  } else {
    wsprintf(shortname,"%s.%s",Name,Ext);
  }
 if(Ext2[0]==0) {
    lstrcpy(localname,Name2);
  } else {
    wsprintf(localname,"%s.%s",Name2,Ext);
  }

  if(lstrlen(shortname)==0) {
    lstrcpy(Name,"aaremote");
    lstrcpy(shortname,Name);
  }
  if(lstrlen(localname)==0) {
    lstrcpy(Name,"aaremote");
    lstrcpy(localname,Name2);
  }

  if(bRecvUniq) {
    nIndex=0;
    while((int)access(shortname,0)==0 && nIndex<99) {
      DoPrintf("[recvuniq] %s - %s - %s",Name,Ext,shortname);
      if(Ext[0]==0)
        wsprintf(shortname,"%s.%03u",Name,nIndex);
      else if(lstrlen(Name)>5)
        wsprintf(shortname,"%-5.5s%03u.%s",Name,nIndex,Ext);
      else wsprintf(shortname,"%s%03u.%s",Name,nIndex,Ext);
      nIndex++;
    }
  }
  
 if(bRecvUniq) {
    nIndex=0;
    while((int)access(localname,0)==0 && nIndex<99) {
      DoPrintf("[recvuniq] %s - %s - %s",Name2,Ext2,localname);
      if(Ext[0]==0)
        wsprintf(localname,"%s.%03u",Name2,nIndex);
      else if(lstrlen(Name)>5)
        wsprintf(localname,"%-5.5s%03u.%s",Name2,nIndex,Ext2);
      else wsprintf(localname,"%s%03u.%s",Name2,nIndex,Ext2);
      nIndex++;
    }
  }
   
  // on nt try whole name for local name
  lstrcpy(localname,savedname);
  // fix vax however
  {
    char  *colonloc = strchr(savedname,';');
    
  if (colonloc != 0)
    {
	  int i = 0;
	  while (savedname[i] != ';')
	    {
	     Name2[i] = savedname[i];
		 ++i;
		}
     Name2[i] = '\0';
     lstrcpy(localname,Name2);
    }
  }  
  return(TRUE);
}

/*************************************************
  find filename in a UNIX directory listing
*/
LPSTR FindName(LPSTR szLine)
{
  int nIndex;
  char *pStr;

  // strip trailing garbage from the line if there is any.
  while((nIndex=strlen(szLine))>2 &&
    (szLine[nIndex-1]==0x0a || szLine[nIndex-1]==0x0d || 
     szLine[nIndex-1]==' ' || szLine[nIndex-1]==0x09))
    szLine[nIndex]=0;

  // now the name SHOULD be the last thing on the line
  if((pStr=strrchr(szLine,' '))!=NULL ||
     (pStr=strrchr(szLine,0x09))!=NULL) {
    while(*pStr && (*pStr==' ' || *pStr==0x09)) pStr++;
    return(pStr);
  }
  return(szLine);
}

/*****************************************************************
  This is the routine that take the output from LIST and breaks
  it down into files and directories.  The format for the output
  from most of the machine types was provided by Chris Sacksteder.
*/
int GetRemoteDirForWnd(HWND hWnd)
{
  char *pStr,*s,*t;
  FILE *fd;
  int result = 0;
  int nRC;
  char *searchstring = remotesearchstring();
  
  char temp[120];

  strcpy(temp,searchstring);

  // clean out the old contents of the list boxes
  SendMessage(hLbxRDir,LB_RESETCONTENT,0,0);
  SendMessage(hLbxRFiles,LB_RESETCONTENT,0,0);
  // can't do much if we aren't connected
  if(!bConnected) {
    SendMessage(hTxtRDir,WM_SETTEXT,0,(LPARAM)"");
  }
  else {
    // get the remote directory name
    strcpy(szString,"undecipherable");
    nRC=DoPWD(ctrl_socket);
    if(nRC==FTP_COMPLETE) {
      if((pStr=strchr(szMsgBuf,'"'))!=NULL)
        strncpy(szString,++pStr,180);
      if((pStr=strchr(szString,'"'))!=NULL)
        *pStr=0;
      else szString[180]=0;
    }
    SendMessage(hTxtRDir,WM_SETTEXT,0,(LPARAM)szString);

    if(!bHELP) ReadProcessHelp(ctrl_socket);
    // go get the current remote directory listing in tmpfile.tmp
   
   // lgk new code here to use search string if filled in
    if (strlen(temp) != 0)
	  {
	   char temp2[200];
	   strcpy(temp2,"LIST ");
	   strcat(temp2,temp);
       nRC=DoDirList(ctrl_socket,temp2);
	  }
    else nRC=DoDirList(ctrl_socket,"LIST");

    SendMessage(hLbxRDir,LB_ADDSTRING,0,(LPARAM)"..");
    if(nRC==FTP_COMPLETE) {
      if((fd=fopen(szTmpFile,"r"))!=NULL) {
        while(fgets(szString,180,fd)!=NULL) {
          if((pStr=strchr(szString,'\n'))!=NULL) *pStr=0;
          switch(nHostType) {
            case HOST_TYPE_SUPER:
            case HOST_TYPE_CHAMELEON:
            case HOST_TYPE_NCSA:
            // looks like a standard DOS directory
                //  filename.ext       <DIR>(or size)  date,etc...
                if(strstr(szString,"<DIR>")!=NULL || 
                   strstr(szString,"<dir>")!=NULL) {
                  if((pStr=strchr(szString,' '))!=NULL) *pStr=0;
                  if(strcmp(szString,".")!=0 && strcmp(szString,"..")!=0)
                    SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)szString);
                } else {
                  if((pStr=strchr(szString,' '))!=NULL) *pStr=0;
                  if(szString[0]!=0)
                    SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)szString);
                }
                break;
          case HOST_TYPE_WINDOWS_NT:
                  if(strstr(szString,"<DIR>")!=NULL) 
                   {
				    if ((pStr = strstr(szString,"<DIR>")) != NULL)
				        if ((pStr = strrchr(pStr,' ')) != NULL)
				          {
				           /* now we should be on name so get it */
						   ++pStr;
                           if(strcmp(pStr,".")!=0 && strcmp(pStr,"..")!=0)
                           SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)pStr);
				          }
				   }
                
                else 
                 {
				 /* get to the name	 */
				   if ((pStr = strrchr(szString,' ')) != NULL)
				       {
					     ++pStr;
						 /* Now we have the name */
                          SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)pStr);
					   }
                }
                break;
                
                case HOST_TYPE_QVT:
            // if the name is the first thing on the line and ends with a slash
            // to indicate a directory
                if((s=strchr(szString,' '))!=NULL) *s=0; // use for ftp.uwp.edu
                if(szString[strlen(szString)-1]=='/' || 
                   szString[strlen(szString)-1]=='\\')
                {
                  szString[strlen(szString)-1]=0;
                  if(strcmp(szString,".")!=0 && strcmp(szString,"..")!=0)
                    SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)szString);
                } else
                  SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)szString);
                break;
            case HOST_TYPE_IBM_VM:
            // IBM VM/VMS listing
                // filename extent (what does a directory look like??)
                szString[18]=0;
                while(strlen(szString)>1 && szString[strlen(szString)-1]==' ')
                  szString[strlen(szString)-1]=0;
                if((s=strchr(szString,' '))!=NULL) {
                  *s++ = '.';
                  t=s;
                  while(*t && *t==' ') t++;
                  if(*t && t!=s) strcpy(s,t);
                }
                if(*s && *s!=' ' && *s!='\t')  // 93.12.04 eliminate blank lines
                  SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)szString);
                break;
            case HOST_TYPE_VMS_UCX:
            case HOST_TYPE_VMS_MULTINET:
            // DEC listing
                if(*szString!=' ') {
                  if((s=strchr(szString,';'))!=NULL) {
                    *s=0;
                    if(strlen(szString)>4 &&
                       strcmp(&szString[strlen(szString)-4],".DIR")==0) {
                      szString[strlen(szString)-4]=0;
                      SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)szString);
                    } else {
                      *s=';';
                      if((s=strchr(szString,' '))!=NULL) *s=0;
                      if((s=strchr(szString,'\t'))!=NULL) *s=0;
                      SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)szString);
                    }
                  }
                }
                break;
            case HOST_TYPE_PCTCP:
            // size..... filename.ext   .......
            // <dir>     filename.ext   .......
                szString[30]=0;
                s=FindName(szString);
                if(strnicmp(szString,"<dir>",5)==0) {
                  if(strcmp(s,".")!=0 && strcmp(s,"..")!=0)
                    SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)s);
                } else
                  SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)s);
                break;
            case HOST_TYPE_IBM_TCP:
            // ........   <dir>   filename.ext
            // ........    DIR    filename.ext    - host ibm tcp
            // ........   size    filename.ext
                s=FindName(szString);
                if(strstr(szString," DIR ")!=NULL || 
                   strstr(szString,"<dir>")!=NULL) {
                  if(strcmp(s,".")!=0 && strcmp(s,"..")!=0)
                    SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)s);
                } else
                  SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)s);
                break;            
            case HOST_TYPE_NOS:
            // ka9q 
              if(strstr(szString,"Disk size")==NULL) {
                szString[13]=0; nRC=13;
                while((nRC=strlen(szString))>0 && szString[nRC-1]==' ')
                  szString[nRC-1]=0;
                if(*szString!=0) {
                  if(szString[strlen(szString)-1]=='/' || 
                     szString[strlen(szString)-1]=='\\')
                  {
                    szString[strlen(szString)-1]=0;
                    if(strcmp(szString,".")!=0)
                      SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)szString);
                  } else
                    SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)szString);
                }
                pStr=&szString[41]; nRC=13; pStr[nRC]=0;
                while((nRC=strlen(pStr))>0 && pStr[nRC-1]==' ')
                  pStr[nRC-1]=0;
                if(*pStr!=0) {
                  if(pStr[strlen(pStr)-1]=='/' ||
                     pStr[strlen(pStr)-1]=='\\')
                  {
                    pStr[strlen(pStr)-1]=0;
                    if(strcmp(pStr,".")!=0 && strcmp(pStr,"..")!=0)
                      SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)pStr);
                  } else
                    SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)pStr);
                }
              }
              break;
            case HOST_TYPE_SINTFTPD:
            case HOST_TYPE_U5000:
            case HOST_TYPE_UNIX:
            case HOST_TYPE_SOLARIS:
            default:
            // assume UNIX ls format
              pStr=FindName(szString);
              // if line starts with 'd' its a directory
              if(strchr("dl",szString[0])!=NULL) {
                if(pStr[strlen(pStr)-1]=='/' || // 93.12.04 fix for some NT ftpd
                   pStr[strlen(pStr)-1]=='\\')  // 93.12.04
                  pStr[strlen(pStr)-1]=0;       // 93.12.04
                if(strcmp(pStr,".")!=0 && strcmp(pStr,"..")!=0)
                  SendMessage(hLbxRDir,LB_ADDSTRING,0,(LONG)pStr);
              } else
              // if line starts with - or f its a file
              if(nHostType==HOST_TYPE_SINTFTPD ||
                 strchr("-f",szString[0])!=NULL) {
                SendMessage(hLbxRFiles,LB_ADDSTRING,0,(LONG)pStr);
              }
              break;
          }
        }
        fclose(fd);
      } else
        DoAddLine("couldn't open tmpfile for read.");
    } else
      DoPrintf("DoDirList returned %u",nRC);
  } // if we were connected
  SendMessage(hRdirBox,EM_SETMODIFY,0,0);
  return 0;
}

/*
  Read the output from HELP and see if we can determine the hosttype
  (if we don't already know it) and determine what functions are
  valid (things like mkdir, etc)
lgk bug fix for solaris where remotehelp hangs the system.
*/
int ReadProcessHelp(SOCKET ctrl_socket)
{
  int iRetCode;

  // lgk add support for getting the other types by executing the syst command

  BOOL defaulttype = FALSE;

  bCanMKD=bCanRMD=bCanREN=bCanDELE=FALSE;

  // lgk don't send help for solaris
  if (nHostType != HOST_TYPE_SOLARIS)
   {
    
  if(SendPacket(ctrl_socket,"HELP")!=-1) 
   {
    iRetCode=ReadLine(ctrl_socket);
    if((iRetCode/100)==5 && nHostType==HOST_TYPE_AUTO) nHostType=HOST_TYPE_NOS;
    else {
      if(nHostType==HOST_TYPE_AUTO) 
       {
        if(strstr(szMsgBuf,"NCSA")!=NULL ||
           strstr(szMsgBuf,"CUTCP")!=NULL)
          nHostType=HOST_TYPE_NCSA;
        else if(strncmp(szMsgBuf,"214-PC FTP server",17)==0 ||
              strstr(szMsgBuf,"QVT")!=NULL)
          nHostType=HOST_TYPE_QVT;
        else
		  {
		   defaulttype = TRUE;
           nHostType=HOST_TYPE_UNIX;
		  }
      }	   
      while((iRetCode!=421) && ((iRetCode/100)!=2 || szMsgBuf[3]=='-'))
       {
        if(strstr(szMsgBuf,"MKD")!=NULL) bCanMKD=TRUE;
        if(strstr(szMsgBuf,"RMD")!=NULL) bCanRMD=TRUE;
        if(strstr(szMsgBuf,"RNFR")!=NULL) bCanREN=TRUE;
        if(strstr(szMsgBuf,"DELE")!=NULL) bCanDELE=TRUE;
        iRetCode=ReadLine(ctrl_socket);
      }
    }
  // if the host type defaulted to unix then try syst instead
  if (defaulttype)
    {
   					  
      if(SendPacket(ctrl_socket,"SYST")!=-1) 
        {
		  DoPrintf("%s","SYST");
          iRetCode=ReadLine(ctrl_socket);
		  DoPrintf("%s",szMsgBuf);

          if(strstr(szMsgBuf,"Windows_NT")!=NULL)
            nHostType=HOST_TYPE_WINDOWS_NT;
          else if(strstr(szMsgBuf,"UNIX") !=NULL)
                 nHostType=HOST_TYPE_UNIX;
      	  else if(strstr(szMsgBuf,"MultiNet") !=NULL)
                 nHostType=HOST_TYPE_VMS_MULTINET;
    	  else if(strstr(szMsgBuf,"MultiNet") !=NULL)
                 nHostType=HOST_TYPE_VMS_MULTINET;
    	  else if(strstr(szMsgBuf,"VMS") !=NULL)
                 nHostType=HOST_TYPE_VMS_UCX;
	   // add others later as we find out the type
	  }
	}
  }

   }
 else // host type is  solaris so hardcode stuff
  {
     
        bCanMKD=TRUE;
        bCanRMD=TRUE;
        bCanREN=TRUE;
        bCanDELE=TRUE;
        iRetCode=214;
   }
    
  EnableWindow(hBtnRMKD,bCanMKD);
  EnableWindow(hBtnRRMD,bCanRMD);
  EnableWindow(hBtnRREN,bCanREN);
  EnableWindow(hBtnRDEL,bCanDELE);
  bHELP=TRUE;
  DoPrintf("Host type (%u): %s",nHostType-6000,szHostTypes[nHostType-6000]);
  

  return iRetCode;
}

//*************************************************//
// routines to load and save our list of hostnames //
//*************************************************//
LPSTR cfgname ="_config_";

int GPPS(LPSTR fldname,LPSTR deflt,LPSTR destination,int len) {
  return(GetPrivateProfileString(cfgname,fldname,
              deflt,destination,len,szIniFile));
}

int WPPS(LPSTR fldname,LPSTR value) {
  return (WritePrivateProfileString(cfgname,fldname,value,szIniFile));
}

void LoadConfigNames(HWND hWndDlg) {
  FILE *fp;
  char szPathName[156];
  char *s;

  szPathName[0]=0;
  if(GetWindowsDirectory(szPathName,144)!=0)
    lstrcat(szPathName,"\\");
  lstrcat(szPathName,szIniFile);
  if((fp=fopen(szPathName,"r"))!=NULL) {
    while(fgets(szPathName,150,fp)!=NULL)
      if(szPathName[0]=='[') {
        if((s=strchr(szPathName,']'))!=NULL) *s=0;
        if(stricmp(&szPathName[1],cfgname)!=0)
          SendDlgItemMessage(hWndDlg,DLG_HOST_NAME,CB_ADDSTRING,0,
            (LONG)(LPSTR)&szPathName[1]);
      }
    fclose(fp);
  }
}
            
void LoadUserInfo()
{
  UINT flags;
//  int nIndex;
 // LPSTR s;

  szSessionName[0]=0;
  szMailAddress[0]=0;
  szViewer[0]=0;
  szUserID[0]=0;
  szPassWord[0]=0;
  szInitDir[0]=0;
  nHostType=HOST_TYPE_AUTO;
  uiTimeOut=65;

  GPPS("SESSION", NULL,      szSessionName, 79);
  GPPS("MAILADDR",NULL,      szMailAddress,127);
  GPPS("VIEWER",  "notepad", szViewer,     120);
  bAutoStart=GetPrivateProfileInt(cfgname, "AUTOSTART",
           bAutoStart,szIniFile);
  flags=GetPrivateProfileInt(cfgname,"FLAGS",64+4+1,szIniFile);
  if(flags & 1) bRecvUniq=1; else bRecvUniq=0;
  if(flags & 2) bStorUniq=1; else bStorUniq=2;
  if(flags & 4) bBell=1; else bBell=0;
  if(flags & 8) bInteractive=1; else bInteractive=0;
  if(flags & 16) bVerbose=1; else bVerbose=0;
  if(flags & 32) bHash=1; else bHash=2;
//if(flags & 64) bSendPort=1; else bSendPort=0;
  if(flags & 128) bDoGlob=1; else bDoGlob=2;
}

void SaveUserInfo()
{
  UINT flags;
 // int nIndex;

  WPPS(NULL, NULL);
  WPPS("SESSION",  szSessionName);
  WPPS("MAILADDR", szMailAddress);
  WPPS("VIEWER",   szViewer);
  wsprintf(szString,"%u",bAutoStart);
  WPPS("AUTOSTART",szString);
  flags=((bRecvUniq==1)?1:0) +
//  ((bStorUniq==1)?2:0) +
    ((bBell==1)?4:0) +
    ((bInteractive==1)?8:0)+
//  ((bHash==1)?32:0) +
//  ((bSendPort==1)?64:0) +
//  ((bDoGlob==1)?128:0) +
    ((bVerbose==1)?16:0);
  wsprintf(szString,"%u",flags);
  WPPS("FLAGS",szString);
}

